/* Terraform - (C) 1997-2000 Robert Gasch (r.gasch@chello.nl)
 *  - http://212.187.12.197/RNG/terraform/
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */


#include <string.h>
#include "TFWindowMain.h"
#include "FileIO.h"
#include "HeightField.h"
#include "HeightFieldGenRandom.h"
#include "GlobalTrace.h"
#include "GlobalSanityCheck.h"
#include "MenuDefs.h"
#include "TFDialogGenSSynth.h"
#include "TFDialogGenSubdiv.h"
#include "TFDialogPrintOptions.h"
#include "TFGui.h"					// circular dependency
#include "TFWindowHandler.h"
#include "strrep.h"

#ifdef HAVE_IMLIB
#include "GuiDialogAboutDissolve.h"
#endif

extern int readhf (HeightField **HF, char *fname, bool haveGUI);


/*
 *  constructor: build the window with an itemfactory, buffered drawing area 
 * 	and colormaps. Store the generated menu in a hash table so we have 
 *	a handy reference later we can use for set_sensitvity calls
 */
TFWindowMain::TFWindowMain(FlexArray *wList) : TFWindowBase (wList),
		d_accelGroup (),
		d_vBoxList (FALSE, 5),
		d_vBoxMenu (FALSE, 0),
		d_vBoxMain (FALSE, 0),
		d_win (GTK_WINDOW_TOPLEVEL)
{
	GlobalTrace::trace (GlobalTrace::TRACE_FLOW, "+++ TFWindowMain\n");

	p_cList = NULL;
	p_scrolledWin = NULL;
	p_genSSynthDialog = p_genSubdivDialog = NULL;
	p_fileSelection = NULL;

	buildWindow ();
	//buildCListMenu ();
}


/*
 *  destructor: clean up 
 */
TFWindowMain::~TFWindowMain()
{
	GlobalTrace::trace (GlobalTrace::TRACE_FLOW, "--- TFWindowMain\n");
}


/*
 *  quit: clean up and exit
 */
void TFWindowMain::quit ()
{
	gtk_exit (0);
}


/* 
 * checkMenus: make sure only the appropriate menus are active
 */
void TFWindowMain::checkMenus ()
{
	Gtk_ObjectHandle<Gtk_MenuItem> 	m;
	string				*s;

	s = new string (strrep(_(MENU_FILE_MERGE), "_", ""));
	m = p_itemFactory->get_menuitem_widget (*s);
	if (p_cList->rows() > 1)
		m->set_sensitive (TRUE);
	else
		m->set_sensitive (FALSE);
	delete s;
}


/*
 *  buildWindow: assemble the widgets and add the menu 
 */
void TFWindowMain::buildWindow ()
{
	char			*s, *t;
	GtkStyle		*style; 
	Gtk_Style		Style; 

	t = new char[80];
	d_win.add (d_vBoxMain);

	p_itemFactory = new Gtk_ItemFactory_MenuBar("<Main>", d_accelGroup);
	style = Style.gtkobj();
	gdk_font_unref (style->font);
	style->font = gdk_font_load ("-*-Helvetica-Medium-R-Normal--*-100-*-*-*-*-*-*");

    	//d_menuBarHandle = static_cast<Gtk_ObjectHandle<Gtk_MenuBar>&> (p_itemFactory->get_menubar_widget(""));
	{
	// uglier than above but without compiler warning 
	Gtk_ObjectHandle<Gtk_MenuBar> a(p_itemFactory->get_menubar_widget(""));
    	d_menuBarHandle = a;
	}

	SanityCheck::bailout ((!d_menuBarHandle.get_object()), "d_menuBarHandle.get_object failed", "TFWindowMain::TFWindowMain");
	d_menuBarHandle->push_style (Style);

	// create the menu items
	s = _(MENU_FILE_BRANCH);
	p_itemFactory->create_item (s, TFWindow::buildAccel (s, ACCEL_TYPE_ALT, t), "<Branch>", 0);
	s = _(MENU_FILE_NEW_BRANCH);
	p_itemFactory->create_item (s, 0, "<Branch>", 0);
	s = _(MENU_FILE_NEW_SYNTHESIS);
	p_itemFactory->create_item (s, TFWindow::buildAccel (s, ACCEL_TYPE_CNTRL, t), "", 
		ItemFactoryConnector<TFWindowMain, string>(this,&TFWindowMain::fileMenuCallback, s));
	s = _(MENU_FILE_NEW_SUBDIVIDE);
	p_itemFactory->create_item (s, TFWindow::buildAccel (s, ACCEL_TYPE_CNTRL, t), "", 
		ItemFactoryConnector<TFWindowMain, string>(this,&TFWindowMain::fileMenuCallback, s));
	p_itemFactory->create_item (_(MENU_FILE_NEW_SEP), 0, "<Separator>", 0);
	s = _(MENU_FILE_NEW_RANDOM);
	p_itemFactory->create_item (s, TFWindow::buildAccel (s, ACCEL_TYPE_CNTRL, t), "", 
		ItemFactoryConnector<TFWindowMain, string>(this,&TFWindowMain::fileMenuCallback, s));

	s = _(MENU_FILE_OPEN);
	p_itemFactory->create_item (s, TFWindow::buildAccel (s, ACCEL_TYPE_CNTRL, t), "", 
	    ItemFactoryConnector<TFWindowMain, string>(this,&TFWindowMain::fileMenuCallback, s));
	s = _(MENU_FILE_MERGE);
	p_itemFactory->create_item (s, TFWindow::buildAccel (s, ACCEL_TYPE_CNTRL, t), "", 
	    ItemFactoryConnector<TFWindowMain, string>(this,&TFWindowMain::fileMenuCallback, s));

	p_itemFactory->create_item (_(MENU_FILE_SEP), 0, "<Separator>", 0);
	s = _(MENU_FILE_OPTIONS);
	p_itemFactory->create_item (s, TFWindow::buildAccel (s, ACCEL_TYPE_CNTRL, t), "", 
	    ItemFactoryConnector<TFWindowMain, string>(this,&TFWindowMain::fileMenuCallback, s));
	s = _(MENU_FILE_PRINT_SETTINGS);
	p_itemFactory->create_item (s, TFWindow::buildAccel (s, ACCEL_TYPE_CNTRL, t), "", 
	    ItemFactoryConnector<TFWindowMain, string>(this,&TFWindowMain::fileMenuCallback, s));
	s = _(MENU_FILE_ABOUT);
	p_itemFactory->create_item (s, TFWindow::buildAccel (s, ACCEL_TYPE_CNTRL, t), "", 
	    ItemFactoryConnector<TFWindowMain, string>(this,&TFWindowMain::fileMenuCallback, s));

	p_itemFactory->create_item (_(MENU_FILE_SEP), 0, "<Separator>" ,0);
	s = _(MENU_FILE_QUIT);
	p_itemFactory->create_item (s, TFWindow::buildAccel (s, ACCEL_TYPE_CNTRL, t), "",
	    ItemFactoryConnector<TFWindowMain, string>(this,&TFWindowMain::fileMenuCallback, s));

	delete [] t;

	// add accel group + menu bar to menu vbox
	d_vBoxMain.pack_start (d_vBoxMenu, FALSE, FALSE, 0);
	d_win.add_accel_group (d_accelGroup);
	d_vBoxMenu.pack_start (*d_menuBarHandle, FALSE, FALSE, 0);

	// add scrolled window to VBox 
	d_vBoxList.set_border_width (5);
	d_vBoxMain.pack_start (d_vBoxList, TRUE, TRUE, 0);
	p_scrolledWin = new Gtk_ScrolledWindow ();
	p_scrolledWin->set_border_width (2);
	p_scrolledWin->set_policy (GTK_POLICY_AUTOMATIC, GTK_POLICY_AUTOMATIC);

	// add List VBox holding CList
	p_cList = new TFCListMainWin (1);
	p_cList->set_column_title (0, "Terrain Object List");
	p_cList->column_titles_show ();
	p_cList->set_shadow_type (GTK_SHADOW_OUT);
	p_scrolledWin->add (*p_cList);
	d_vBoxList.pack_start (*p_scrolledWin, TRUE, TRUE, 0);

	// catch destroy event
	connect_to_method (d_win.destroy, this, &TFWindowMain::quit);

	d_win.show ();
	d_win.set_usize (200, 300);
	d_win.set_policy (FALSE, FALSE, FALSE);
	p_cList->show ();
	p_scrolledWin->show ();
	d_vBoxList.show ();
	d_vBoxMenu.show ();
	d_vBoxMain.show ();
	d_menuBarHandle->show();

	Gtk_Main *gtkMain = Gtk_Main::instance();
	while (gtkMain->events_pending())
		gtkMain->iteration ();
}


/*
 *  fileMenuCallback: process a menu choice in the file menu
 */
void TFWindowMain::fileMenuCallback (string m)
{
	int		rc=0;
	char		*menuitem = const_cast<char*>(m.c_str()),
			*aboutText[] = { "brought to you by", 
					"r.gasch@chello.nl", };
	HeightField	*HF = NULL;

	if (!strcmp (menuitem, _(MENU_FILE_NEW_SYNTHESIS)))
		{
		if (!p_genSSynthDialog)
			p_genSSynthDialog = new TFDialogGenSSynth ();
		else
			{
			TFDialogGenSSynth 	*TFDGen;

			TFDGen = dynamic_cast<TFDialogGenSSynth*>(p_genSSynthDialog);
			TFDGen->reset ();
			TFDGen->set_title (HeightField::getNewName());
			}
		
		p_genSSynthDialog->show ();
		}
	else
	if (!strcmp (menuitem, _(MENU_FILE_NEW_SUBDIVIDE)))
		{
		if (!p_genSubdivDialog)
			p_genSubdivDialog = new TFDialogGenSubdiv ();
		else
			{
			TFDialogGenSubdiv *TFDGen;

			TFDGen = dynamic_cast<TFDialogGenSubdiv*>(p_genSubdivDialog);
			TFDGen->reset ();
			TFDGen->set_title (HeightField::getNewName());
			}
		
		p_genSubdivDialog->show ();
		}
	else
	if (!strcmp (menuitem, _(MENU_FILE_NEW_RANDOM)))
		{
		HF = new HeightField ();
		HeightFieldGenRandom::generate (HF, 400);
		TFGui::addHeightField (HF);
		}
	else
	if (!strcmp (menuitem, _(MENU_FILE_OPEN)))
		{
		fileSelection ();
		}
	else
	if (!strcmp (menuitem, _(MENU_FILE_MERGE)))
		{
		TFDialogMerge	*mergeDialog = TFGui::getMergeDialog ();
		mergeDialog->rebuildCList ();
                mergeDialog->initHeightFields (NULL);
                mergeDialog->show ();
		}
	else                    
	if (!strcmp (menuitem, _(MENU_FILE_ABOUT)))
		{
		if (!this->s_aboutDialog)
			{
#ifdef HAVE_IMLIB
			char	buf[256];
			sprintf (buf, "%s/terraform-logo.jpg", TF_DATADIR);
			FileIO	*fio = new FileIO (buf);
			if (fio->exists())
				this->s_aboutDialog = new GuiDialogAboutDissolve ("About Terraform", buf, aboutText, 2);
			else
				fprintf (stderr, _("Error opening %s\n"), buf);
			delete fio;
#else
			this->s_aboutDialog = new GuiDialogAbout ("About Terraform", NULL, aboutText, 2);
#endif
			if (this->s_aboutDialog)
				this->s_aboutDialog->buildDialogWindow ();
			}

		if (this->s_aboutDialog)
			this->s_aboutDialog->show ();
		}
	else
	if (!strcmp (menuitem, _(MENU_FILE_OPTIONS)))
		{
		if (!this->s_optionsDialog)
			this->s_optionsDialog = new TFDialogOptions (TFWindowBase::s_winList);
		else
			this->s_optionsDialog->show ();
		}
	else
	if (!strcmp (menuitem, _(MENU_FILE_PRINT_SETTINGS)))
		{
		if (!this->s_printOptionsDialog)
			this->s_printOptionsDialog = new TFDialogPrintOptions ();
		else
			this->s_printOptionsDialog->show ();
		}
	else
	if (!strcmp (menuitem, _(MENU_FILE_QUIT)))
		{
		if (!TFGui::allWindowsSaved())
			{
			if (!this->s_quitDialog)
				this->s_quitDialog = new GuiDialogReallyQuit ("", "");
			else
				this->s_quitDialogConnection.disconnect ();

			this->s_quitDialog->set_title (_("Really Quit Terraform?"));
			this->s_quitDialog->setLabel (_("Unsaved Changes! Exit anyway?"));
			this->s_quitDialogConnection = connect_to_method (
				this->s_quitDialog->getYesButton()->clicked, 
				this, &TFWindowMain::quit);
			this->s_quitDialog->show ();
			}
		else
			quit ();
		}
	else
		SanityCheck::bailout ("uncaught <file> menuitem", "TFWindowMain::fileMenuCallback");

	if (rc)
		fprintf (stderr, _("Warning: last command returned an Error (%d)\n"), rc);
	fflush (stdout);
}


/*
 *  fileSelectionOK: user pressed OK in file selection dialog
 */
void TFWindowMain::fileSelectionOK ()
{
	gchar 	*fname;
	int	rc;
	HeightField	*HF=NULL;
	TFWindowHandler	*tfWin=NULL;

	p_fileSelection->hide ();

	fname = const_cast<char*>(p_fileSelection->get_filename().c_str());

	rc = readhf (&HF, fname, TRUE);
	tfWin = new TFWindowHandler (TFWindowBase::s_winList);
	tfWin->setHeightField (HF);

	if (rc)
		fprintf (stderr, _("Warning: last command returned an Error (%d)\n"), rc);
	else
		TFWindowBase::s_winList->append (tfWin);
}


/*
 *  fileSelectionCancel: user pressed Cancel in file selection dialog
 */
void TFWindowMain::fileSelectionCancel ()
{
	p_fileSelection->set_filename ("");
	p_fileSelection->hide ();
}


/*
 *  fileSelection: open a file selection dialog
 */
void TFWindowMain::fileSelection ()
{
	if (!p_fileSelection)
		{
		p_fileSelection = new Gtk_FileSelection ("");
		p_fileSelection->set_position (GTK_WIN_POS_MOUSE);

		connect_to_method (p_fileSelection->get_ok_button()->clicked, 
					this, &TFWindowMain::fileSelectionOK);
		connect_to_method (p_fileSelection->get_cancel_button()->clicked,
					this, &TFWindowMain::fileSelectionCancel);
		}

	p_fileSelection->set_title ("Load Height Field");
	p_fileSelection->show ();
}
