/* Terraform - (C) 1997-2000 Robert Gasch (r.gasch@chello.nl)
 *  - http://212.187.12.197/RNG/terraform/
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */


#include "TFWindowBase.h"
#include "GlobalTrace.h"

//
// initialize static class variables. These are shared between the 
// main terraform dialog and the individual HF dialogs 
//
FlexArray		*TFWindowBase::s_winList = NULL;
GuiDialogAbout		*TFWindowBase::s_aboutDialog = NULL;
GuiDialogOAC 		*TFWindowBase::s_optionsDialog = NULL;
GuiDialogOAC 		*TFWindowBase::s_mergeDialog = NULL;
GuiDialogYN 		*TFWindowBase::s_printOptionsDialog = NULL;
GuiDialogReallyQuit 	*TFWindowBase::s_quitDialog = NULL;
Connection		TFWindowBase::s_quitDialogConnection = NULL;



/* 
 * Constructor: check if wList is valid 
 */
TFWindowBase::TFWindowBase (FlexArray *wList)
{
	GlobalTrace::trace (GlobalTrace::TRACE_FLOW, "+++ TFWindowBase\n");

	SanityCheck::bailout ((!wList), "wList==NULL", "TFWindowBase::TFWindowBase");

	if (s_winList)
		SanityCheck::bailout ((wList!=s_winList), "wList!=s_winList", "TFWindowBase::TFWindowBase");

	s_winList = wList;
}


/* 
 * Destructor: nothing to clean up 
 */
TFWindowBase::~TFWindowBase ()
{
	GlobalTrace::trace (GlobalTrace::TRACE_FLOW, "--- TFWindowBase\n");
}

