/* Terraform - (C) 1997-2000 Robert Gasch (r.gasch@chello.nl)
 *  - http://212.187.12.197/RNG/terraform/
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */


#include <time.h>
#include "TFDialogGenSSynth.h"
#include "GlobalDefs.h"
#include "GlobalSanityCheck.h"
#include "GlobalTrace.h"
#include "HeightFieldGenSSynth.h"
#include "MathRandom.h"
#include "TFGui.h"
#include "TFOptions.h"
#include "TFWindowHandler.h"
#include "agename.h"




/*
 *  constructor: initialize all data members 
 */
TFDialogGenSSynth::TFDialogGenSSynth ()
	        : GuiDialogOAC ("Spectral Synthesis Generate Dialog", 
				"Generation Parameters"),
		  d_vbList (TRUE, 5),
		  d_hbSize (TRUE, 5),
		  d_hbDim (TRUE, 5),
		  d_hbInvert (TRUE, 5),
		  d_hbGenSeed (TRUE, 5),
		  d_hbSeed (TRUE, 5)
{
	GlobalTrace::trace (GlobalTrace::TRACE_FLOW, "+++ TFDialogGenSSynth\n");

	p_seedInitStr = new char [40];
	reset ();

	p_lblSize = new Gtk_Label (_("Size"));
	p_lblDim = new Gtk_Label (_("Fractal dimension"));
	p_lblInvert = new Gtk_Label (_("Invert sin/cos"));
	p_lblGenSeed = new Gtk_Label (_("Generate new seed"));
	p_lblSeed = new Gtk_Label (_("Specify Seed"));
	p_adjDim = new Gtk_Adjustment (2.5, 2.0, 2.99, 1);
	p_adjSize = new Gtk_Adjustment (400, 10, (TFOptions::s_large ? 5000 : 1000), 1);
	p_hsDim = new Gtk_HScale (*p_adjDim);
	p_hsSize = new Gtk_HScale (*p_adjSize);

	buildDialogWindow ();
	connect_to_method (d_btnGenSeed.clicked, this, &TFDialogGenSSynth::checkboxCallback);
}



/*
 *  destructor: clean up, free allocated memory
 */
TFDialogGenSSynth::~TFDialogGenSSynth ()
{
	if (p_seedInitStr) delete p_seedInitStr;

	delete p_lblSize;
	delete p_lblDim;
	delete p_lblInvert;
	delete p_lblGenSeed;
	delete p_lblSeed;
	delete p_adjDim;
	delete p_adjSize;
	delete p_hsDim;
	delete p_hsSize;

	GlobalTrace::trace (GlobalTrace::TRACE_FLOW, "--- TFDialogGenSSynth\n");
}


/*
 *  reset: clear p_tfWin so the next generate will register a new 
 * 	window. Should be called before re-showing an existing dialog
 */
void TFDialogGenSSynth::reset ()
{
	p_HF = NULL;
	p_tfWin = NULL;
	this->set_title (_("Generate Spectral Synthesis"));
}


/*
 *  fillVBox: fill the dialog's VBox
 */
void TFDialogGenSSynth::fillVBox ()
{
	SanityCheck::bailout ((!this->p_frmBase), "TFDialogGenSSynth called without Frame label",
		"TFDialogGenSSynth::fillVBox");

        d_hbSize.pack_start (*p_lblSize, TRUE, TRUE, s_HBOff);
        p_lblSize->show ();
        p_hsSize->set_update_policy (GTK_UPDATE_DELAYED);
	p_hsSize->set_adjustment (*p_adjSize);
        p_hsSize->set_digits (0);
        p_hsSize->set_draw_value (TRUE);
        d_hbSize.pack_end (*p_hsSize, TRUE, TRUE, s_HBOff);
        p_hsSize->show ();
	d_vbList.pack_start (d_hbSize, TRUE, TRUE, s_VBOff);
	d_hbSize.show ();

        d_hbDim.pack_start (*p_lblDim, TRUE, TRUE, s_HBOff);
        p_lblDim->show ();
        p_hsDim->set_update_policy (GTK_UPDATE_DELAYED);
	p_hsDim->set_adjustment (*p_adjDim);
        p_hsDim->set_digits (2);
        p_hsDim->set_draw_value (TRUE);
        d_hbDim.pack_end (*p_hsDim, TRUE, TRUE, s_HBOff);
        p_hsDim->show ();
	d_vbList.pack_start (d_hbDim, TRUE, TRUE, s_VBOff);
	d_hbDim.show ();

	d_hbInvert.pack_start (*p_lblInvert, TRUE, TRUE, s_HBOff);
	p_lblInvert->show ();
	d_hbInvert.pack_end (d_btnInvert, TRUE, TRUE, s_HBOff);
	d_btnInvert.show ();
	d_vbList.pack_start (d_hbInvert, TRUE, TRUE, s_VBOff);
	d_hbInvert.show ();

	d_vbList.pack_start (d_sepMain, TRUE, TRUE, s_HBOff);
	d_sepMain.show ();

	d_hbGenSeed.pack_start (*p_lblGenSeed, TRUE, TRUE, s_HBOff);
	p_lblGenSeed->show ();
	d_hbGenSeed.pack_end (d_btnGenSeed, TRUE, TRUE, s_HBOff);
	d_btnGenSeed.set_active (TRUE);
	d_btnGenSeed.show ();
	d_vbList.pack_start (d_hbGenSeed, TRUE, TRUE, s_VBOff);
	d_hbGenSeed.show ();

	p_lblSeed->set_justify (GTK_JUSTIFY_RIGHT);
	d_hbSeed.pack_start (*p_lblSeed, TRUE, TRUE, s_HBOff);
	p_lblSeed->set_sensitive (FALSE);
	p_lblSeed->show ();

	MathRandom	*mRand = new MathRandom ();
	sprintf (p_seedInitStr, "%d", (int)mRand->rnd());
	delete mRand;
	d_enSeed.set_text (p_seedInitStr);
	d_enSeed.set_sensitive (FALSE);
	d_hbSeed.pack_end (d_enSeed, TRUE, TRUE, s_HBOff);
	d_enSeed.show ();
	d_vbList.pack_start (d_hbSeed, TRUE, TRUE, s_VBOff);
	d_hbSeed.show ();

	this->p_frmBase->add (d_vbList);
	d_vbList.show ();
	this->p_frmBase->show ();
	this->get_vbox()->show ();
	
}


/*
 *  buildDialogWindow:
 */
void TFDialogGenSSynth::buildDialogWindow ()
{
	this->set_usize (300, 280);
	this->get_vbox()->set_border_width (2);

	this->setupVBox ();
	fillVBox ();
	fillActionArea ();

	this->show ();
}


void TFDialogGenSSynth::checkboxCallback ()
{
	bool		status=d_enSeed.is_sensitive ();

	p_lblSeed->set_sensitive (!status);
	d_enSeed.set_sensitive (!status);
}


void TFDialogGenSSynth::buttonCallbackApply ()
{
	float			H, dim; 	// Dimension = 3-h
	char			*s;
	int			size, seed;
	bool			invert, magnitude, HFisNew=FALSE;
	HeightFieldGenSSynth	*HFGen = NULL;


	if (!p_HF)
		{
		p_HF = new HeightField ();
		HFisNew = TRUE;
		}
	HFGen = new HeightFieldGenSSynth (p_HF);

	// get slider values
	dim = p_adjDim->get_value (); 	// 2 .. 3
	H = 3-dim;
	size = (int)(p_adjSize->get_value());

	// either generate or read a random number seed
	if (d_btnGenSeed.get_active())
		{
		MathRandom	*mRand = new MathRandom ();

		seed = (int) (mRand->rnd()*G_MAXINT);
		sprintf (p_seedInitStr, "%d", seed);
		d_enSeed.set_text (p_seedInitStr);
		delete mRand;
		}
	else
		{
		s = const_cast<char*>(d_enSeed.get_text().c_str());
		seed = atoi (s);
		}

	invert = d_btnInvert.get_active ();
	magnitude = d_btnGenSeed.get_active ();

	SanityCheck::bailout ((!HFGen), "HFGen==NULL", "TFDialogGenSSynth::buttonCallbackApply");
	HFGen->generate (size, H, seed, invert);
	delete HFGen;
	HFGen = NULL;

	if (HFisNew)
		{
		p_tfWin = TFGui::addHeightField (p_HF);
		this->set_title (p_HF->getName());
		}
	else
		p_tfWin->drawHeightField ();

	this->b_applyHit = TRUE;
}


gint TFDialogGenSSynth::delete_event_impl (GdkEventAny *e)
{
	this->hide ();
	return (0);
}


