/* Terraform - (C) 1997-2000 Robert Gasch (r.gasch@chello.nl)
 *  - http://212.187.12.197/RNG/terraform/
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */


#include "TFDialogFold.h"
#include "GuiDialogOAC.h"
#include "GlobalSanityCheck.h"
#include "GlobalTrace.h"



/*
 *  constructor: initialize all data members 
 */
TFDialogFold::TFDialogFold (HeightField *HF, HeightFieldDraw *HFD)
	        : TFPreviewDialog (HF, HFD, "Terraform Fold Dialog", 
				"Edge Fold Offset", 6, 4),
		  d_hBoxFoldOffset (TRUE, 0),
		  d_vBoxOptions (TRUE, 5),
		  d_adjFoldOffset (0.1, 0.01, 0.4, 0.01),
		  d_hsFoldOffset (d_adjFoldOffset),
		  d_lblFoldOffset (_("Edge Fold Offset")),
		  d_frmOptions (_("Edge Fold Options")) 

{
	GlobalTrace::trace (GlobalTrace::TRACE_FLOW, "+++ TFDialogFold\n");

	buildDialogWindow ();
	this->setHFobjs (HF, HFD);
	sprintf (this->p_windowTitle, _("Fold: %s"), p_HF->getName());
	this->set_title (this->p_windowTitle);
	this->iterateEvents ();
	updatePreviewCallback ();

	connect_to_method (d_adjFoldOffset.value_changed, this, &TFDialogFold::updatePreviewCallback);
}


/*
 *  destructor: clean up 
 */
TFDialogFold::~TFDialogFold ()
{
	GlobalTrace::trace (GlobalTrace::TRACE_FLOW, "--- TFDialogFold\n");
}


/*
 *  fillVBox: fill the dialog's VBox
 */
void TFDialogFold::insertOptions ()
{
	SanityCheck::bailout ((!this->p_frmBase), "TFDialogFold called without Frame label",
		"TFDialogFold::setHFobjs");

	d_frmOptions.set_shadow_type (GTK_SHADOW_ETCHED_IN);
	d_frmOptions.set_border_width (5);

	d_hBoxFoldOffset.pack_start (d_lblFoldOffset, TRUE, TRUE, GuiDialogOAC::s_HBOff);
	d_lblFoldOffset.show ();
	d_hsFoldOffset.set_update_policy (GTK_UPDATE_CONTINUOUS);
	d_hsFoldOffset.set_digits (2);
	d_hsFoldOffset.set_draw_value (TRUE);
	d_hBoxFoldOffset.pack_end (d_hsFoldOffset, TRUE, TRUE, GuiDialogOAC::s_HBOff);
	d_hsFoldOffset.show ();
	d_vBoxOptions.pack_start (d_hBoxFoldOffset, TRUE, TRUE, GuiDialogOAC::s_HBOff);
	d_hBoxFoldOffset.show ();

	d_frmOptions.add (d_vBoxOptions);
	this->p_tblMain->attach (d_frmOptions, 3, 6, 1, 3);
	d_vBoxOptions.show ();
	d_frmOptions.show ();
	this->p_frmBase->show ();
	this->get_vbox()->show ();
}


/*
 *  buildDialogWindow:
 */
void TFDialogFold::buildDialogWindow ()
{
	this->set_usize (450, 225);
	this->set_title (this->p_windowTitle);

	this->get_vbox()->set_border_width (2);

	this->setupVBox ();
	this->insertPreview ();
	insertOptions();
	this->fillActionArea ();

	this->show ();
}


/*
 *  buttonCallbackApply: fold the height field 
 */
void TFDialogFold::buttonCallbackApply ()
{
	float		value = d_adjFoldOffset.get_value ();

	SanityCheck::bailout ((!p_HFO), "p_HFO==NULL", "TFDialogFold::buttonCallbackApply");
	p_HFO->fold ((int)(value*
			(p_HF->getWidth()+p_HF->getHeight())/2));
	p_HFD->draw ();

	// only do this if window stays open 
	if (b_applyHit)
		{
		this->setHFobjs (p_HF, p_HFD);
		updatePreviewCallback ();
		}

	this->b_applyHit = TRUE;
}


/*
 *  updatePreviewCallback: update the preview after a widget has been updated.
 */
void TFDialogFold::updatePreviewCallback ()
{
	if (!d_cbUsePreview.get_active())
		return;

	float		value = d_adjFoldOffset.get_value ();

	SanityCheck::bailout ((!p_HFPreview), "p_HFPreview==NULL", "TFDialogFold");
        SanityCheck::bailout ((!p_HFOPreview), "p_HFOPreview==NULL", "TFDialogFold");
        SanityCheck::bailout ((!p_HFDPreview), "p_HFDPreview==NULL", "TFDialogFold");
	this->previewUpToDate ();
	p_HFPreview->restoreBackup ();
	p_HFOPreview->fold ((int)(value*
			(p_HFPreview->getWidth()+p_HFPreview->getHeight())/2));
	p_HFDPreview->setColormap (p_HFD->getColormap());
	p_HFDPreview->draw ();
}

