/* Terraform - (C) 1997-2000 Robert Gasch (r.gasch@chello.nl)
 *  - http://212.187.12.197/RNG/terraform/
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */


#include <math.h>
#include <stream.h>
#include <stdlib.h>

#include "MathComplex.h"
#include "GlobalSanityCheck.h"
#include "GlobalTrace.h"


#define El(v, xp, yp)	v[(yp*xsize)+xp]	// HF array 2D access

/* 
 *  magnitude: compute the real HF from the complex matrix 
 */ 
float *MathComplex::magnitude (float *vReal, float *vImag, int xsize, int ysize)
{
	int 		x, y;
	float		*hfout; 

	GlobalTrace::trace (GlobalTrace::TRACE_FLOW, 
                "Calculating Magnitude real and imaginary planes ...\n");

	SanityCheck::bailout ((!vReal), "vReal==NULL", "MathComplex::magnitude");
	SanityCheck::bailout ((!vImag), "vImag==NULL", "MathComplex::magnitude");
	SanityCheck::bailout ((xsize!=ysize), "xsize!=ysize", "MathComplex::magnitude");

	hfout = new float[(int)(xsize*ysize)];

	for (x=1; x<xsize; x++) 
		for (y=1; y<ysize; y++) 
			El (hfout, x, y) = sqrt ( pow (El(vReal, x, y), 2) + 
						  pow (El(vImag, x, y), 2) );

	return hfout;
}


/* 
 *  integrate: integrate the real HF from the complex matrix 
 */ 
/*
float *MathComplex::integrate (float *vReal, float *vImag, int xsize, int ysize)
{
	int 		x, y;
	float 		*hfout; 

	GlobalTrace::trace (GlobalTrace::TRACE_FLOW, 
                "Integrating real HF from complex matrix");

	SanityCheck::bailout ((!vReal), "vReal==NULL", "MathComplex::getRealHF");
	SanityCheck::bailout ((!vImag), "vImag==NULL", "MathComplex::getRealHF");

	hfout = new float[(int)(xsize*ysize)];

	El (hfout,0,0) = 0;        // start with corner [0,0] = 0.0 

	for (x=1; x<xsize; x++)
		El (hfout, x, 0) = El (hfout, x-1, 0) + El (vReal, x, 0);
	for (y=1; y<ysize; y++)
		El (hfout, 0, y) = El (hfout, 0, y-1) + El (vImag, 0, y);

	for (x=1; x<xsize; x++) 
		for (y=1; y<ysize; y++) 
			El (hfout,x,y) = 0.5 * ( El (hfout,x-1,y) + 
						 El (vReal,x,y)   +
                      		         	 El (hfout,x,y-1) +
						 El (vImag,x,y)	 );

	return hfout;
}

*/
