/* Terraform - (C) 1997-2000 Robert Gasch (r.gasch@chello.nl)
 *  - http://212.187.12.197/RNG/terraform/
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */


#ifndef _HEIGHT_FIELD_DRAW_H
#define _HEIGHT_FIELD_DRAW_H

#include "HeightField.h"
#include "HeightFieldModel.h"
#include "TFWindow.h"
#include "GuiColormap.h"
#include "MathTrig.h" 		// PT2 and PT3 defs


#define MENU_BAR_OFFSET	25
#define HFWIN_MINX	 	200
#define HFWIN_MINY	 	50+MENU_BAR_OFFSET
#define HFWIN_SIZEX(thf) 	(thf->Width()<HFWIN_MINX ? HFWIN_MINX : thf->Width())
#define HFWIN_SIZEY(thf) 	thf->Height()+MENU_BAR_OFFSET

#define MAXCOL			225	// 15 x 15
#define BANDSIZE		15

#define PLANE 			0
#define WIRE   			1                	// wireframe 
#define HEIGHT		 	2			// wireframe + height
#define SLOPE  			3
#define LIGHT  			4
#define NDM			PLANE			// Number of Draw Modes

#define LOAD			0
#define SAVE			1

#define         PTYPE                   float

#define D 	double

#define MIN_SCREEN_SIZE	10
#define MAX_SCREEN_SIZE	2000
#define MIN_SCALE_FACTOR 0.25
#define MAX_SCALE_FACTOR 5


/*
 *  HeightFieldDraw: draws a height field in 2 or 3 D. Provides a single 
 * 	object with mutator functions to set display options. 
 */
class HeightFieldDraw
	{
	public:
				HeightFieldDraw(HeightField *HF, TFWindow *tfWin);
				HeightFieldDraw(HeightField *HF, GuiBufferedDrawingArea *drawArea);
				~HeightFieldDraw ();

		// various functions
		int		draw (bool changedHF=TRUE);
		void		resetView ();
		void		updateParams ();
		void		clear ();
		void		printSettings ();
		void		help ();
		int		rotateFastView (float a, float b, float c);

		// mutator functions which set display options
		int		setColormap (GuiColormap *colorMap);
		int		setMode (char *s);
		int		setScale (float s, int *x=NULL, int *y=NULL);
		int		alterScale (float f, int *x=NULL, int *y=NULL);
		void		setSync (int syncRate);
		void		setFastWire (bool fastWire);
		void 		setEyePos (double _x_, double _y_, double _z_);
		void 		setLightPos (double _x_, double _y_, double _z_);
		void 		setYScale (double yscale);
		void 		setSeaFill (int sfill);
		void 		setResolution (int i);
		void		setFastOptions (bool halfWireRes, bool halfYscale, bool doRotZ);

		// access functions 
		int		getMode ()		{return d_shader;}
		GuiColormap	*getColormap () 	{return p_cMap;}
		GdkColor	*getColor2d (int x, int y);
                GdkColor	*getColorElv (PTYPE elv);

		bool		d_fastDoRotZ;	// accessible for TFGui.cc
	private:
		int		tri3d (D x0, D z0,D x1,D z1,D y0,D y1,D y2,D y3, int offset); 
		int		drawhf2d ();
		int		drawhf3dFast ();
		int		drawhf3d ();
		int		draw2dContourLines ();
		PTYPE		hf_abs (PTYPE n);

		HeightField		*p_HF;
		HeightFieldModel	*p_HFM;
		GuiColormap		*p_cMap;
		TFWindow		*p_tfWin;
		GuiBufferedDrawingArea	*p_drawArea;
		unsigned char 		*p_RGBbuf;
		time_t			d_clTimestamp;
		PT3 			d_light;  		// position of light source 
		PT3 			d_eye;    		// position of viewer 
		D			d_zcenter, 			
					d_zsf, d_ysf, 		// z & y coordinate scale factors
					d_ycorr, d_zeps, 
					d_bright, d_eyeinc,
					d_slMin, d_slScale,
					d_scale;
		PTYPE			d_nrange, d_prange,
					d_fastWireResAdj,
					d_fastYscaleAdj;
		int			d_resolution, 		// resolution 
					d_wireResolution,
					d_ncolors, 		// max number of colors
					d_nLandColors,          // number of colors used for land
					d_nWaterColors,         // number of colors used for water
					d_nbands,
					d_bandsize, 
					d_xgsize, d_ygsize, 	// size of display window
					d_bandLandOffset,	// land offset in X_Color table in bands and in colors
					d_yoff, d_maxcon, 
					d_cmin, d_cmax, 
					d_erasewin, 
					d_tile, d_shader, 
					d_sxmid, d_symid;
		bool			b_sea, 
					b_fastWire,
					b_drawContour; 
	};

#endif // _HEIGHT_FIELD_DRAW_H
