/* Terraform - (C) 1997-2000 Robert Gasch (r.gasch@chello.nl)
 *  - http://212.187.12.197/RNG/terraform/
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */


#include <stdio.h>
#include "terraform.h"
#include "GuiDialogAboutDissolve.h"				// include gtk, gtk--
#include "GlobalSanityCheck.h"
#include "GlobalTrace.h"
#include "MathRandom.h"


#ifndef HAVE_IMLIB
ERROR: You have select an impossible compile option. GuiDialogAboutDissolve
only makes sense if you have imlib to read the JPG picture file. 
#endif


/*
 * Constructor: init everything 
 */
GuiDialogAboutDissolve::GuiDialogAboutDissolve (char *winTitle, char *fileName, 
						char **msgPtrs, int nMesgs)
		: GuiDialogAbout (winTitle, fileName, msgPtrs, nMesgs)
{
	GlobalTrace::trace (GlobalTrace::TRACE_FLOW, "+++ GuiDialogAboutDissolve\n");

	SanityCheck::bailout ((!winTitle), "winTitle==NULL", "GuiDialogAboutDissolve::GuiDialogAboutDissolve");
	SanityCheck::bailout ((!fileName), "fileName==NULL", "GuiDialogAboutDissolve::GuiDialogAboutDissolve");
	SanityCheck::bailout ((!strlen(fileName)), "strlen(fileName)==0", "GuiDialogAboutDissolve::GuiDialogAboutDissolve");

	connect_to_method (expose_event, this, 
			&GuiDialogAboutDissolve::handleExposeEvent);

	p_drawArea = NULL;
	p_pixmap = NULL;
	p_dissolveMap = NULL;
	d_animSize = 2;
	d_animSteps = 20;
	d_animFrame = 0;
}


/*
 * Destructor
 */
GuiDialogAboutDissolve::~GuiDialogAboutDissolve ()
{
	if (p_dissolveMap)
		delete [] p_dissolveMap; 

	GlobalTrace::trace (GlobalTrace::TRACE_FLOW, "--- GuiDialogAboutDissolve\n");
}


/*
 *  buildDialogWindow: call the proper functions to setup the window
 */
void GuiDialogAboutDissolve::buildDialogWindow ()
{
	GdkGC		*gc;
	int		w, h, i, j, k;
	MathRandom	*mRand;

        this->set_title (this->p_winTitle);
	this->add (this->d_vBox);
        this->d_vBox.set_border_width (0);

	this->loadLogo ();
	w = this->p_image->rgb_width;
	h = this->p_image->rgb_height;

	// fill the dissolveMap with data
	d_dissolveWidth = w/d_animSize + (w%d_animSize==0?0:1);
	d_dissolveHeight = h/d_animSize + (h%d_animSize==0?0:1);
	p_dissolveMap = new guchar[d_dissolveWidth*d_dissolveHeight];
	mRand = new MathRandom ();
	for (i=0, k=0; i<d_dissolveWidth; i++)
		for (j=0; j<d_dissolveHeight; j++, k++)
			p_dissolveMap[k] = (int) mRand->rnd (0, d_animSteps-1);
	delete mRand;

	this->realize ();		// needed since Gtk 1.0.1
	p_pixmap = gdk_pixmap_new (this->get_window(), w, h, 
				   d_preview.get_visual().get_best_depth());
	gc = gdk_gc_new (p_pixmap);
	gtk_preview_put (GTK_PREVIEW (d_preview.gtkobj()), p_pixmap, gc, 
			0, 0, 0, 0, w, h);

	p_drawArea = new GuiBufferedDrawingArea ();
	this->d_vBox.pack_start (*p_drawArea, TRUE, TRUE, 0);
	p_drawArea->show ();

	//this->d_vBox.pack_start (this->d_preview, TRUE, TRUE, 0);
	//this->d_preview.show ();

	this->d_vBox.pack_start (this->d_frame, TRUE, TRUE, 0);
	this->d_frame.show ();
	this->d_frame.set_shadow_type (GTK_SHADOW_ETCHED_IN);
	this->d_frame.add (this->d_vBoxFrame);

	this->addLabels (&(this->d_vBoxFrame));
	this->d_vBoxFrame.show ();

	//printf ("%d\n", d_lbl1->height());
	// how do I calculate the proper window height? 
	// d_lbl1->height() returns 1
	this->set_usize (w, h+15*this->d_nMessage);

        this->d_vBox.show ();
        this->show ();

	p_drawArea->setUsize (w, h);
}



/*
 *  handleExposeEvent: redraw the exposed area from the backing pixmap
 */
int GuiDialogAboutDissolve::handleExposeEvent (GdkEventExpose *event)
{
	//printf ("Expose: %d, %d, %d, %d\n\n", event->area.x, event->area.y,
        //	event->area.width, event->area.height);

	if (event->area.width == p_drawArea->width())
		{
		p_drawArea->clear ();
		p_drawArea->setSync (0);
		d_animFrame = 0;
		if (!d_animFrame)
			connect_to_method (Gtk_Main::timeout(50), this,
					&GuiDialogAboutDissolve::logoTimer);
		}
	return (0);
}



/*
 *  load_logo: load the logo from file into preview (and add preview to d_vBox)
 */
int GuiDialogAboutDissolve::logoTimer ()
{
	int	i, j, k;

	if (d_animFrame < d_animSteps)
	    {
	    for (j=0, k=0; j<d_dissolveHeight; j++)
	        for (i=0; i<d_dissolveWidth; i++, k++)
			{
			if (p_dissolveMap[k] == d_animFrame)
			    {
			    p_drawArea->drawPixmap (p_pixmap, 
				i*d_animSize, j*d_animSize,
				i*d_animSize, j*d_animSize,
				d_animSize, d_animSize);
			    }
			}
	    p_drawArea->sync ();
	    d_animFrame++;
	    }
	else
		return 0;

	return 1;
}


/*
int GlobalTrace::s_traceLevel = 255;
int main (int argc, char *argv[])
{
	Gtk_Main        gtkMain (&argc, &argv);
	GuiDialogAboutDissolve *testDialog;

	testDialog = new GuiDialogAboutDissolve ();
	testDialog->show ();
	gtkMain.run ();
}
*/

