/* Terraform - (C) 1997-2000 Robert Gasch (r.gasch@chello.nl)
 *  - http://212.187.12.197/RNG/terraform/
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */


#ifndef _GLOBAL_TRACE_H
#define _GLOBAL_TRACE_H


#include <stream.h>


/*
 *  GlobalTrace: Provides a static (global) trace flag mechanism 
 */
class GlobalTrace
	{
	public: 

		static const int 	TRACE_OFF 		= 0;
		static const int	TRACE_STDOUT		= 1;
		static const int	TRACE_FILE		= 2;
		static const int 	TRACE_VERBOSE		= 4;
		static const int	TRACE_FLOW		= 8;
		static const int	TRACE_INPUT		= 16;
		static const int	TRACE_OUTPUT		= 32;
		static const int	TRACE_DEBUG		= 64;
		static const int	TRACE_NEVER		= 128;
		static const int	MAX_TRACELEVEL		= 255;

		static bool		trace (int traceLevel, char *s);
		static void 		setTraceLevel (int traceLevel);
		static int 		getTraceLevel ();
		static bool 		isSet (int traceLevel);

	private:
		static int		s_traceLevel;
	};

#endif // _GLOBAL_TRACE_H
