
import Sketch.Scripting
from Sketch import SimpleText, Translation, SolidPattern, StandardColors, \
     GetFont


def create_text(context):
    # Create the text 'xyzzy' at 100,100. The first parameter to the
    # constructor is an affine transformation.
    text = SimpleText(Translation(100, 100), "xyzzy")
    
    # Set the font to 36pt Times-Bold and fill with solid green.
    # The text object is modified by this method, but the text object is
    # not yet part of the document, so we don't have to deal with undo
    # here.
    text.SetProperties(fill_pattern = SolidPattern(StandardColors.green),
                       font = GetFont('Times-Bold'),
                       font_size = 36)
    # Finally, insert the text object at the top of the current layer
    # and select it. Like all public document methods that modify the
    # document, the Insert method takes care of undo information itself.
    context.document.Insert(text)

Sketch.Scripting.AddFunction('create_text', 'Create Text', create_text,
                             script_type = Sketch.Scripting.AdvancedScript)

