/***************************************************************************
                          rpainter.cpp  -  description
                             -------------------
    begin                : Mon Sep 27 1999
    copyright            : (C) 1999 by Andreas Mustun
    email                : andrew@ribbonsoft.com
 ***************************************************************************/


/****************************************************************************
** rpainter.cpp 1998/08/27 A. Mustun RibbonSoft
**
** Copyright (C) 1998 RibbonSoft.  All rights reserved.
**
*****************************************************************************/

#include "rpainter.h"
#include "rmath.h"

// Constructor:
//
RPainter::RPainter()
:QPainter()
{

}



// Constructor:
//
RPainter::RPainter(const QPaintDevice* _pDev)
:QPainter(_pDev)
{
  
}



// Destructor:
//
RPainter::~RPainter()
{

}



// Draw a more exact arc:
//
void
RPainter::drawExactArc(float _cx, float _cy, 
                       float _cr,
                       float _a1, float _a2,
                       int   _x1, int   _y1,
                       int   _x2, int   _y2,
                       bool _reversed)
{
  if(_cr<=0.5) {
    drawPoint((int)_cx, (int)_cy);
  }
  else {
    int   cix;            // Next point on circle
    int   ciy;            //
    float aStep;          // Angle Step (rad)
    float aStep2;         // Angle Step (rad)
    float a;              // Current Angle (rad)

    if(2.0/_cr<=1.0)
      aStep=asin(2.0/_cr);
    else
      aStep=1.0;

    aStep2=aStep*0.50;
      
    if(aStep<0.05) aStep = 0.05;

    if(!_reversed) {
    
      // Arc Counterclockwise:
      //
      if(_a1>_a2-0.01) _a2+=360.0;
      moveTo(_x1, _y1);
      for(a=(_a1/ARAD)+aStep; a<=(_a2/ARAD); a+=aStep) {
        cix = (int)(_cx+cos(a)*_cr);
        ciy = (int)(_cy-sin(a)*_cr);
        lineTo(cix, ciy);

        /*
        a+=aStep2;
        cix = (int)(_cx+cos(a)*_cr);
        ciy = (int)(_cy-sin(a)*_cr);
        moveTo(cix, ciy);
        */
      }
      lineTo(_x2, _y2);
    }
    else {
      // Arc Clockwise:
      if(_a1<_a2+0.01) _a2-=360.0;
      moveTo(_x1, _y1);
      for(a=(_a1/ARAD)-aStep; a>=(_a2/ARAD); a-=aStep) {
        cix = (int)(_cx+cos(a)*_cr);
        ciy = (int)(_cy-sin(a)*_cr);
        lineTo(cix, ciy);

        /*
        a-=aStep2;
        cix = (int)(_cx+cos(a)*_cr);
        ciy = (int)(_cy-sin(a)*_cr);
        moveTo(cix, ciy);
        */
      }
      lineTo(_x2, _y2);
    }
  }
}


// EOF

