/***************************************************************************
                          rinfowidget.cpp  -  description
                             -------------------
    begin                : Mon Sep 27 1999
    copyright            : (C) 1999 by Andreas Mustun
    email                : andrew@ribbonsoft.com
 ***************************************************************************/


/****************************************************************************
** rinfowidget.cpp 1998/09/23 A. Mustun RibbonSoft
**
** Copyright (C) 1998 RibbonSoft.  All rights reserved.
**
        Last change:  A    10 Dec 1998   10:06 am
*****************************************************************************/

#include "rinfowidget.h"

#include <qdatetime.h>
#include <qfileinfo.h>
#include <qtooltip.h>

#include "rgraphic.h"
#include "rconfig.h"
#include "rlabel.h"
#include "rlog.h"

// Constructor:
//
RInfoWidget::RInfoWidget(QWidget* _parent, 
                         const char* _name, 
                         WFlags _f)
:RWidget(_parent, _name, _f)
{
  graphic=0;

  valid=false;

  //setFrameStyle(WinPanel|Raised);
  //setFrameStyle(Panel|Sunken);
  setFrameStyle(WinPanel|Sunken);
  setLineWidth(1);

  lPath = new RLabel(RMES(179), this, "lpath");
  QToolTip::add(lPath, RMES(180));
  path  = new RLabel("", this, "path");

  lCreation = new RLabel(RMES(181), this, "lcreation");
  QToolTip::add(lCreation, RMES(182));
  creation  = new RLabel("", this, "creation");

  lSize = new RLabel(RMES(183), this, "lsize");
  QToolTip::add(lSize, RMES(184));
  size  = new RLabel("", this, "size");

  lObjects = new RLabel(RMES(185), this, "lobjects");
  QToolTip::add(lObjects, RMES(186));
  objects  = new RLabel("", this, "objects");

  lTotalWay = new RLabel(RMES(187), this, "ltotalway");
  QToolTip::add(lTotalWay, RMES(188));
  totalWay  = new RLabel("", this, "totalway");

  lCuttingWay = new RLabel(RMES(189), this, "lcuttingway");
  QToolTip::add(lCuttingWay, RMES(190));
  cuttingWay  = new RLabel("", this, "cuttingway");
                             
}



// Destructor:
//
RInfoWidget::~RInfoWidget()
{

}



// Show info widget:
//
void 
RInfoWidget::show()
{
  RWidget::show();
  
  if(!valid) updateInfo();
}



// Resize event:
//
void 
RInfoWidget::resizeEvent(QResizeEvent* _ev)
{
  RWidget::resizeEvent(_ev);
  resizeChildren();
}



// Resize the children:
//
void
RInfoWidget::resizeChildren()
{
  int y=5;
  
  if(lPath)       lPath->setGeometry(10, y, 65, 14);
  if(path)        path-> setGeometry(105, y, width()-115, 14);
  y+=16;
  if(lCreation)   lCreation->setGeometry(10, y, 65, 14);
  if(creation)    creation-> setGeometry(105, y, width()-115, 14);
  y+=16;
  if(lSize)       lSize->setGeometry(10, y, 65, 14);
  if(size)        size-> setGeometry(105, y, width()-115, 14);
  y+=16;
  if(lObjects)    lObjects->setGeometry(10, y, 65, 14);
  if(objects)     objects-> setGeometry(105, y, width()-115, 14);
  y+=16;
  if(lTotalWay)   lTotalWay->setGeometry(10, y, 65, 14);
  if(totalWay)    totalWay-> setGeometry(105, y, width()-115, 14);
  y+=16;
  if(lCuttingWay) lCuttingWay->setGeometry(10, y, 65, 14);
  if(cuttingWay)  cuttingWay-> setGeometry(105, y, width()-115, 14);

  updateInfo(false);
  
}



// Set the pointer to a graphic and update the layers:
//
void 
RInfoWidget::setGraphic(RGraphic* _graphic) 
{ 
  graphic=_graphic;
  valid=false;
  if(graphic) updateInfo();
}



// Update the graphic info:
//   only if the info widget is visible
//
// _values: true:  update also values
//          false: update only layout
//
void 
RInfoWidget::updateInfo(bool _values)
{
  // Update only if visible:
  //
  if(isVisible() && graphic) {
    
    QFileInfo fi(graphic->getFileName().data());
    QDate     fd(fi.lastModified().date());
    QTime     ft(fi.lastModified().time());
    QCString   str;
    
    if(path) {
      if(fi.exists()) {
        str=fi.absFilePath();
        path->setText(str);
        while(str.length()>3 && path->sizeHint().width()>path->width()) {
          str.remove(0, 1);
          str[0]='.';
          str[1]='.';
          path->setText(str);
        }
      }
      else {
        path->setText("-");
      }
    }
    if(creation && _values) {
      if(fi.exists()) {
        str.sprintf("%s / %s", 
                    fd.toString().data(), ft.toString().data());
        creation->setText(str.data());
      }
      else {
        creation->setText("-");
      }
    }
    if(size && _values) {
      if(fi.exists()) {
        str.sprintf("%d Bytes", fi.size());
        size->setText(str.data());
      }
      else {
        size->setText("-");
      }
    }
    if(objects && _values) {
      str.sprintf("%d", graphic->count());
      objects->setText(str.data());
    }
    if(totalWay && _values) {
      str.sprintf("%.3f mm", graphic->getTotalWay());
      totalWay->setText(str.data());
    }
    if(cuttingWay && _values) {
      str.sprintf("%.3f mm", graphic->getCuttingWay());
      cuttingWay->setText(str.data());
    }

    repaint();
    if(_values) valid=true;
  }

  // It's not visible / update later:
  //
  else {
    valid=false;
  }
}

// EOF

