#!/bin/sh
# \
exec wish8.0 "$0" "$@"

#####################################################################

set test 0

if { $test } {
	source "tclpp.tcl"
}

#####################################################################

class TabButton {
		variable scalar fg
		variable scalar bg
		variable scalar outline
		variable scalar fill
		variable scalar txt
		variable scalar widg
		variable scalar txtId
		variable scalar outId
		variable scalar state
		variable scalar font
		variable scalar stateId
		variable scalar command

	proc TabButton { path args } {
		
		set fg ""
		set bg ""
# 		set outline "-outline #000000"
		set outline ""
		set space ""
		set txt ""
		set font ""
		set fill "-fill #dedede"
		set state 0
		set command ""
		set dbg 0
				
		foreach { opt arg } $args {
			switch -- $opt {
				-dbg {
					set dbg $arg
				}
				-text {
					set txt "-text \"$arg\""
				}
				-fg {
					set fg "-fill $arg"
				}
				-font {
					set font "-font $arg"
				}
				-fill {
					set bg "-bg $arg"
				}
				-bg {
					set fill "-fill $arg"
				}
				-outline {
# 					set outline "-outline $arg"
				}
				-command {
					set command "$arg"
				}
				default {
					if { $dbg } {
						error "unknown option $opt"
					}
				}
			}
		}
		
		set widg [eval canvas $path -bd 0 -highlightthickness 0 $bg]
		set txtId [eval $widg create text 0 0 $fg $txt $font -anchor nw]

		set bnds [$widg bbox all]

		set width [expr [lindex $bnds 2] - [lindex $bnds 0] ]
		set height [expr [lindex $bnds 3] - [lindex $bnds 1] ]

		set xmod 14
		set ymod 8

		set width [expr $width + $xmod]
		set height [expr $height + $ymod]

		$widg configure -width $width -height $height

		# for the tab polygon
		set opts "1 -0 1 3 3 1 -3 1 -1 3 -1 -0"

		set outId [eval $widg create polygon \
			[$this makePts $width $height $opts] \
			$fill $outline -smooth 0]

		set opts "0 -0 0 3 3 0 -3 0"
		set sh1Id [eval $widg create line \
			[$this makePts $width $height $opts] \
			-fill #ffffff]

		set opts "-3 1 -1 3 -1 -0"
		set sh2Id [eval $widg create line \
			[$this makePts $width $height $opts] \
			-fill #848484]

		set opts "0 -1 -0 -1"
		set stateId [eval $widg create line \
			[$this makePts $width $height $opts] \
			-fill #ffffff]
			
		$this setState 0		

		$widg move $txtId [expr $xmod * .5 + 1] [expr $ymod * .625]
		$widg raise $txtId
		$widg lower $sh1Id
# 		$widg lower $sh2Id
		
		bind $widg <1> "$this doCommand"
	}
	
	proc makePts { width height opts } {
		set pts {}
		
		foreach { xx yy } $opts {
			if { [string index $xx 0] == "-" } {
				set xx [expr $width + $xx]
			}

			if { [string index $yy 0] == "-" } {
				set yy [expr $height + $yy]
			}		

			lappend pts $xx
			lappend pts $yy
		}
		return $pts
	}
	
	proc ~TabButton {} {
		destroy $widg
	}
	
	proc getText {} {
		return [lindex $txt 1]
	}
	
	proc getWidg {} {
		return $widg
	}
	
	proc setState { val } {
		if { $val != $state } {
			if { $val } {
				$widg lower $stateId $outId
			} else {
				$widg raise $stateId
			}
			
			set state $val
		}
	}
	
	proc doCommand {} {
		if { $command != "" } {
			regsub "%o" $command $this tmp
			uplevel #0 eval $command
		}
	}
}

class TabPage {
		variable scalar butt 
		variable scalar frame 
		variable scalar command 
		variable scalar page 
		variable scalar state

	proc TabPage { { path . } { frameIn . } args } {		
		set command ""
		set frame $frameIn
		set state 0
		set dbg 0
		set width ""
		set height ""
		set bg ""
		
		set butt ${this}_butt
		eval TabButton $butt $path $args -command \"$this doCommand\"
		
		pack [$butt getWidg] -side left
		
		foreach { opt arg } $args {
			switch -- $opt {
				-command {
					set command "$arg"
				}
				-bg {
					set bg "-bg $arg"
				}
				-dgb {
					set dbg $arg
				}
				-width {
					set width "-width $arg"
				}
				-height {
					set height "-height $arg"
				}
				default {
					if { $dbg } {
						error "unknown option $opt"
					}
				}
			}
		}

		set page [eval frame ${frame}.$this $width $height $bg -highlightthickness 0 -bd 0]
		
		$this setState 0
	}
	
	proc ~TabPage {} {
		$butt delete
		destroy $page
	}
	
	proc setState { val } {
		if { $state != $val } {
			if { $val } {
				$butt setState 1
				pack $page -expand 1 -fill both
			} else {
				$butt setState 0
				pack forget $page
			}
			
			set state $val
		}
	}
	
	proc doCommand {} {
		if { $command != "" } {
			regsub "%o" $command $this tmp
			uplevel #0 eval $tmp
		}
	}
	
	proc getWidg {} {
		return $page
	}

	proc getObj {} {
		return $butt
	}	
}

class Tabs {
		variable scalar pages
		variable scalar cur
		variable scalar command
		variable scalar frame
		variable scalar num
		variable scalar dbg
		variable scalar extend
		variable scalar leftc
		variable scalar rightc

	proc Tabs { path args } {
		set cur ""
		set pages ""
		set command ""
		set frame [frame $path -highlightthickness 0]
		set num 0
		set dbg 0
		set extend ""

		foreach { opt arg } $args {
			switch -- $opt {
				-dbg {
					set dbg "$arg"
				}
				-command {
					set command "$arg"
				}
				-extend {
					set extend "$arg"
				}
				default {
					if { $dbg } {
						error "unknown option $opt"
					}
				}
			}
		}
		
		if { $extend != "" } {
# 			set leftc [canvas $extend.leftc -bd 3 -relief raised -height 1]
			set rightc [canvas $extend.rightc -bd 0 -relief raised -height 1 -width 1000]
			
			$rightc create line 0 0 1000 0 -fill #ffffff
		}
	}
	
	proc ~Tabs {} {
		foreach page $pages {
			$page delete
		}
		
		destroy $frame
	}
	
	proc getWidg {} {
		return $frame
	}

	proc add { path args } {

		set what [eval new TabPage $path $frame $args -command \"$this doCommand %o\"]
		
		if { $pages == {} } {
			set cur $what
			$what setState 1
		} else {
			$what setState 0
		}
		
		lappend pages $what
		
		if { $extend != "" } {
# 			pack forget $leftc
			pack forget $rightc
			
			set parent [winfo parent $rightc]
			set kin [pack slaves $parent]
			
# 			pack $leftc -before [lindex $kin 0] -side left -anchor s -fill x
			pack $rightc -after [lindex $kin end] -side left -anchor s -fill x
		}
		
		return $what
	}
	
	proc rem { which } {
		set ind [lsearch $pages $which]
		set pages [lreplace $pages $ind $ind]
		
# 		puts $pages
		
		if { $cur == $which } {
			set cur [lindex $pages 0]
			if { $cur != "" } {
				$this doCommand $cur
			}
		}
		
		return $which
	}
	
	proc doCommand { which } {
		if { $cur != "" } {
			$cur setState 0
		}
				
		set cur $which

		if { $command != "" } {
			regsub "%o" $command $cur tmp
			uplevel #0 eval $tmp
		}
		
		$cur setState 1
	}
	
	proc getAll {} {
		return $pages
	}
	
	proc getCur {} {
		return $cur
	}
}

if { $test } {
	. configure -bg #000000
	wm geometry . 200x200

	set ts tabs
	Tabs $ts .ftabs -command "puts %o"
	pack [$ts getWidg] -side bottom -fill both -expand 1
	
	set page [$ts add .p3 -text hello -bg #99ff99 -fill #000000]
	set b [button [$page getWidg].b1 -text wuh]
	pack $b

	# test delete of the active tab... worst case
# 	$ts rem $page
# 	delete $page
	
	set page [$ts add .p4 -text goodbye -bg #9999ff -fill #000000]
	set b [button [$page getWidg].b1 -text gluh]
	pack $b

	set page [$ts add .p5 -text "What The" -bg #ff9999 -fill #000000]
	set b [button [$page getWidg].b1 -text aloha]
	pack $b
}



