// copyright (c) 1997,1998 stephen f. white
// 
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2, or (at your option)
// any later version.
// 
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with this program; see the file COPYING.  If not, write to
// the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.

import java.util.*;
import java.applet.*;
import java.awt.*;

public class TextSceneInterface extends Applet implements SceneInterface
{
    TalkerPanel		chat;
    Dispatcher		dispatcher;
    ClientThread	thread;

    // VID of the player object
    int			userVid;

    String		status;

    public void init() {
	String hostname = getCodeBase().getHost();
	int port = Integer.parseInt(getParameter("PORT"));
	StringTokenizer t1 = new StringTokenizer(getParameter(
					   "AVATAR_NAMES"), ",");
	StringTokenizer t2 = new StringTokenizer(getParameter(
					   "AVATAR_URLS"), ",");

	String[] avatarNames = new String[t1.countTokens()];
	int count = 0;
	for (int i = 0; t1.hasMoreTokens(); i++) {
	    avatarNames[i] = t1.nextToken();
	}

	String[] avatarURLs = new String[t2.countTokens()];
	for (int i = 0; t2.hasMoreTokens(); i++) {
	    avatarURLs[i] = t2.nextToken();
	}
	    
	dispatcher = new Dispatcher(this);
	chat = new TalkerPanel(dispatcher, hostname, port,
				 avatarNames, avatarURLs);
	dispatcher.setTalker(chat);
	setLayout(new BorderLayout());
	add("Center", chat);
    }

    public boolean mouseEnter(Event evt, int x, int y) {
        showStatus(status);
        return true;
    }

    public void onError(String str) {
        onStatus(str);
    }

    public void onStatus(String str) {
        status = str;
        showStatus(status);
    }

    public VRMLObject createObject(int vid, String url,
                                   VRMLObjectObserver observer) {
	return new VRMLObject(vid, url, observer);
    }

    public void addObject(VRMLObject obj) {
    }

    public void removeObject(VRMLObject obj) {
    }

    public void removeAllObjects() {
    }

    public void setViewpointPosition(VSFVec3f position) {
    }

    public void setViewpointOrientation(VSFRotation orientation) {
    }

    public void onConnect() {
    }
    public void onDisconnect() {
    }
}
