/* cqcam - Color Quickcam capture programs
 * Copyright (C) 1996-1998 by Patrick Reynolds
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of
 * the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
 * 02111-1307, USA.
 */

#include <gtk/gtkmain.h>
#include <gtk/gtkwidget.h>

#include <stdio.h>
#include <unistd.h>
#include <signal.h>

#include "main.h"
#include "gcam.h"
#include "options.h"
#include "dimensions.h"
#include <cqcsrv.h>
#include <port.h>

int in_fd, out_fd;

int main(int argc, char **argv) {
  GtkWidget *main;
  int child;

  if ((child = init_server(&in_fd, &out_fd)) < 0)
    return -1;
#ifndef LYNX
  setgid(getgid());
  setuid(getuid());
#endif

  gtk_init(&argc, &argv);

  options_init();
  dimensions_init();
  main = create_main_window();
  
  gtk_widget_show_all(main);
  gtk_main();

  kill(child, 15);

#ifdef DEBUG
  fprintf(stderr, "Clean shutdown.\n");
#endif
  
  return 0;
}
