/*
 *	mkpalette.cc
 *	Generate palette files from lump PLAYPAL.
 *	AYM 1998-12-29
 */


/*
This file is part of Yadex.

Yadex incorporates code from DEU 5.21 that was put in the public
domain in 1994 by Raphal Quinet and Brendon Wyber.

The rest of Yadex is Copyright  1997-1999 Andr Majorel.

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU Library General Public
License along with this library; if not, write to the Free
Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA
02111-1307, USA.
*/


#include "yadex.h"
#include <errno.h>
#include "mkpalette.h"
#include "gfx.h"
#include "rgb.h"


/*
 *	make_gimp_palette
 */
void make_gimp_palette (int playpalnum, const char *filename)
{
MDirPtr dir;
u8	*dpal;
FILE	*output_fd;

dir = FindMasterDir (MasterDir, "PLAYPAL");
if (dir == NULL)
   {
   printf ("Warning: PLAYPAL lump not found.\n");
   return;
   }

int playpal_count = dir->dir.size / (3 * DOOM_COLOURS);
if (playpalnum < 0 || playpalnum >= playpal_count)
   {
   printf ("Warning: playpalnum %d out of range (0-%d). Using #0 instead.\n",
      playpalnum, playpal_count - 1);
   playpalnum = 0;
   }

output_fd = fopen (filename, "w");
if (output_fd == NULL)
   {
   printf ("Error: Can't open \"%s\" (%s)\n", filename, strerror (errno));
   return;
   }
fprintf (output_fd,
   "GIMP Palette\n"
   "# Generated by Yadex %s\n", yadex_version);

dpal = (u8 *) GetFarMemory (3 * DOOM_COLOURS);
wad_seek (dir->wadfile, dir->dir.start + (long) playpalnum * 3 * DOOM_COLOURS);
wad_read_bytes (dir->wadfile, dpal, 3 * DOOM_COLOURS);
for (size_t n = 0; n < DOOM_COLOURS; n++)
   fprintf (output_fd, "%3d %3d %3d  # %3d %02Xh\n",
      dpal[3 * n],
      dpal[3 * n + 1],
      dpal[3 * n + 2],
      n,
      n);
FreeFarMemory (dpal);

fclose (output_fd);
}


