/* Tile properties */
#define TILE_W 64
#define TILE_H 64

/* Layers */
#define BASE 0
#define OBJECT 1

/* What clip level you want to check collisions against */
enum BASE_CLIP_LEVELS {
  BCL_ALL,
  BCL_SPECIAL,
  BCL_WALL,
  BCL_NONE
};

/* Clip level for objects */
enum OBJECT_CLIP_LEVELS {
  OCL_ALL,
  OCL_CLIP,
  OCL_NONE
};

enum GLOBAL_BASE_TILES {
  T_BLANK,
  T_WHITE,
  NUM_GLOBAL_BASE_TILES
};

enum GLOBAL_OBJECT_TILES {
  O_NULL,
  O_MSG0,
  O_MSG1,
  O_MSG2,
  O_MSG3,
  O_MSG4,
  O_MSG5,
  O_MSG6,
  O_MSG7,
  O_MSG8,
  O_MSG9,
  NUM_GLOBAL_OBJECT_TILES
};

/* BASE LAYER */
enum REAL_BASE_TILES {
  RB_GRASS = NUM_GLOBAL_BASE_TILES, /* BASE_FLOOR */
  RB_GRASS1,
  RB_CONC,
  RB_PLANK,
  RB_CARPET,
  RB_MARBLE,
  RB_MARBLE1,
  RB_SLATE,
  RB_CRATER,
  RB_ASH,
  RB_ICE,
  RB_ROCKICE,
  RB_SNOW,
  RB_SNOWF,
  RB_H2O, /* BASE_SPECIAL */
  RB_H2O1,
  RB_BRICK, /* BASE_WALL */
  RB_BRICK1,
  RB_IWALLNW,
  RB_IWALLNE,
  RB_IWALLSW,
  RB_IWALLSE,
  RB_IWALLV,
  RB_IWALLH,
  RB_IWALLTN,
  RB_IWALLTS,
  RB_IWALLTE,
  RB_IWALLTW,
  RB_KBENCH
};

/* 1st tiles in each segment */
#define REAL_BASE_FLOOR RB_GRASS
#define REAL_BASE_SPECIAL RB_H2O
#define REAL_BASE_WALL RB_BRICK
#define NUM_REAL_BASE_TILES 29

enum REAL_OBJECT_TILES {
  RO_PIC = NUM_GLOBAL_OBJECT_TILES, /* OBJECT_NOCLIP */
  RO_PIC1,
  RO_PIC2,
  RO_RED,
  RO_RUM,
  RO_MSN,
  RO_BMARK,
  RO_RUBBLE,
  RO_GPATHV,
  RO_GPATHH,
  RO_MESSAGE,
  RO_KEND, /* OBJECT_CLIP */
  RO_SINK,
  RO_TOASTER,
  RO_WINDOW,
  RO_NOFEED,
  RO_BATH, /* OBJECT_DESTROY */
  RO_BATH1,
  RO_BED,
  RO_BED1,
  RO_CHAIR,
  RO_COUCH,
  RO_COUCH1,
  RO_DRAWERS,
  RO_FRIDGE,
  RO_FRIDGE1,
  RO_PC,
  RO_SINK1,
  RO_TABLE,
  RO_TOILET,
  RO_TOWELS,
  RO_TREE,
  RO_TREE1,
  RO_TV,
  RO_DESK,
  RO_BATH_B, /* OBJECT_BROKEN */
  RO_BATH1_B,
  RO_BED_B,
  RO_BED1_B,
  RO_CHAIR_B,
  RO_COUCH_B,
  RO_COUCH1_B,
  RO_DRAWERS_B,
  RO_FRIDGE_B,
  RO_FRIDGE1_B,
  RO_PC_B,
  RO_SINK1_B,
  RO_TABLE_B,
  RO_TOILET_B,
  RO_TOWELS_B,
  RO_TREE_B,
  RO_TREE1_B,
  RO_TV_B,
  RO_DESK_B
};

#define REAL_OBJECT_NOCLIP RO_PIC
#define REAL_OBJECT_CLIP RO_KEND
#define REAL_OBJECT_DESTROY RO_BATH
#define REAL_OBJECT_BROKEN RO_BATH_B
#define NUM_REAL_OBJECT_TILES 54

/* TECH TILESET Walkables */
enum TECH_BASE_TILES {
  TB_LIGHTGREY = NUM_GLOBAL_BASE_TILES, /* BASE_FLOOR */
  TB_GREEN, /* BASE_WALL */
  TB_GREENBASE,
  TB_SD_CORNER,
  TB_SD_TOPICBSD,
  TB_SD_TOPICCRYPT,
  TB_SD_TOPICGAMES,
  TB_SD_TOPICGNU,
  TB_SD_TOPICLINUX,
  TB_SD_TOPICMS,
  TB_SD_TOPICNET,
  TB_SD_TOPICQUAKE,
  TB_SD_TOPICSCIENCE,
  TB_SD_TOPICSPAM
};

#define TECH_BASE_FLOOR TB_LIGHTGREY
#define TECH_BASE_SPECIAL TB_GREEN
#define TECH_BASE_WALL TB_GREEN
#define NUM_TECH_BASE_TILES 14

enum TECH_OBJECT_TILES {
  TO_GY_TXT = NUM_GLOBAL_OBJECT_TILES, /* OBJECT_NOCLIP */
  TO_GY_TXT_LN,
  TO_GRN_TXT,
  TO_GB_TOP,
  TO_GB_BOTT,
  TO_SD_TITLE,
  TO_SD_TITLE1
};

#define TECH_OBJECT_NOCLIP TO_GY_TXT
#define TECH_OBJECT_CLIP NUM_GLOBAL_OBJECT_TILES + 7 /* None yet */
#define NUM_TECH_OBJECT_TILES 7
