/*
 * XSOLDIER, a video-oriented game
 * Copyright (C) 1997, Yuusuke HASHIMOTO
 *                     s945750@educ.info.kanagawa-u.ac.jp
 *
 * ܥץˤ copyleft ŬѤƤޤCONDITION ե򻲾Ȥ
 * Ƥ
 */

#if !defined _XSOLDIER_H_
#define _XSOLDIER_H_

#include <stdio.h>
#include <X11/Xlib.h>
#include <X11/Xutil.h>

#if ! defined(_XtIntrinsic_h) && ! defined(PIXEL_ALREADY_TYPEDEFED)
typedef unsigned long Pixel;
#define PIXEL_ALREADY_TYPEDEFED
#endif

#if defined(SYSV)
# define srandom(s) srand48((long)s)
# define random() lrand48()
#endif

#define MaxStage 8
#define ShotTiming 100
#define MaxLevel 100

#define FIRST1UP 100000
#define EVERY1UP 100000

/*** °ޥ ***/
#define MPlayer (1L<<0)
#define MPShot  (1L<<1)
#define MEnemy  (1L<<2)
#define MEShot  (1L<<3)
#define MItem   (1L<<4)

/*** ˴ե饰 ***/
typedef enum {NoneDel,NullDel,ZakoDel,BossDel} DelAtt;

typedef struct
{/*** ֥ȴܥǡ ***/
    Bool used; /*** ? ***/

    int hitAtt;
    int hitMask;
    int Width,Height;
    int HarfW,HarfH;
    /*** ޤǤä ***/

    int startTime;
    int shotTime;
    /*** ƤǤĥ ShotTiming ˤʤäǤĤ褦 ***/

    Bool kill;  /*** ? ***/
    int HP;
    int Attack;
    int Point;
    DelAtt EnemyAtt;

    int X,Y;
    int oldX,oldY;
    int inertX,inertY;
    int Angle;
    int Speed;
    int Cnt[16];

    int image;
} ObjData;

typedef struct
{/*** ֥ȥեåǡ ***/
    Image **image;

    int Width,Height;
    int HarfW,HarfH;
} GrpData;

typedef struct
{/*** ѥ饯֥ ***/
    ObjData Data;
    GrpData Grp;

    DelAtt (*Action)(ObjData *my);
    DelAtt (*Hit)(ObjData *my, ObjData *your);
    void (*Realize)(ObjData *my, GrpData *grp);
} CharObj;

typedef struct
{/*** ֥Ȥδơ֥ ***/
    CharObj **player;
    CharObj **enemy;

    CharObj New;

    int PlayerMax;
    int PlayerNum;
    int EnemyMax;
    int EnemyNum;

    CharObj EnemyShot;
    CharObj Bomb;
    CharObj LargeBomb;
    /*** ɤȤ륪֥ ***/

    int Level;
    int Stage;
    int Loop;
    int Appear;

    int StageEnemy;
    int StageShotDown;
    Bool ZakoApp;
    Bool BossApp;
    Bool BossKill;
} CharManage;
/*** ɤơ֥ʤưĤʤΤǥХ˻Ѥޤ ***/

typedef struct
{
    char name[16];
    int score;
    int stage;
    int loop;
} Record;

typedef struct
{
    Record Rec[11];
    int Ships;
    int Percent;
    int Next;
} PlayerData;

#endif
