/*
            Universe Editor Window: Properties Pane

 */




#ifndef UEWPROPS_H
#define UEWPROPS_H


#define UEW_PROP_PROMPT_HEIGHT	30


/*
 *	Property parameter names.
 */
static char *prop_name[] = {
	"Name",				/* 0 */
	"Password",
	"Empire",
	"LastUpdated",
	"Type",
	"LocType",
	"ImageSet",
	"Owner",
	"Size",
	"LockedOn",
	"InterceptingObject",		/* 10 */
	"ScannerRange",
	"SectX",
	"SectY",
	"SectZ",
	"X",
	"Y",
	"Z",
	"Heading",
	"Pitch",
	"Bank",				/* 20 */
	"Velocity",
	"VelocityMax",
	"VelocityHeading",
	"VelocityPitch",
	"VelocityBank",
	"ThrustDir",
	"Thrust",
	"ThrustPower",
	"Throttle",
	"EngineState",			/* 30 */
	"TurnRate",
	"Lighting",
	"Hp",
	"HpMax",
	"Power",
	"PowerMax",
	"PowerPurity",
	"CoreEfficency",
	"Antimatter",
	"AntimatterMax",		/* 40 */
	"ShieldState",
	"ShieldFrequency",
	"SelectedWeapon",
	"TotalWeapons",
	"BirthTime",
	"LifeSpan",
	"CloakState",
	"CloakStrength",
	"Visibility",
	"CurVisibility",		/* 50 */
	"ShieldVisibility",
	"DamageControl",
	"ComChannel",
	"AIFlags",
/* Skip tractored objects. */
	"PermissionUID",
	"PermissionGID",
	"AnimationInterval",
	"AnimationLastInterval",
	"AnimationCurrentFrame",
	"AnimationTotalFrames",		/* 60 */
	"AnimationCycleCount",
	"AnimationCycleTimes",
	"ScoreCredits",
	"ScoreRMU",
	"ScoreRMUMax",
	"ScoreDamageGiven",
	"ScoreDamageRecieved",
	"ScoreKills"			/* 68 */
};


/*
 *	Total property prompts, this value must be one greater than
 *	the highest prompt code.
 */
#define TOTAL_PROP_PROMPTS	(sizeof(prop_name) / sizeof(char *))









#endif	/* UEWPROPS_H */
