/*
                             Set Functions

	Functions:

	int CmdOPMSet(int condescriptor, char *arg)
	int CmdDoSet(int condescriptor, char *arg)




 */

#include "swserv.h"


/*
 *	Macro to check if set is allowed by the given uid.
 */
int ALLOW_SET_MAC(int condescriptor, int uid)
{
        char sndbuf[CS_DATA_MAX_LEN]; 

	if(uid > ACCESS_UID_SET)
	{
	    sprintf(sndbuf,
		"set: Requires access level %i: Permission denied.",
                ACCESS_UID_SET
            );
            NetSendLiveMessage(condescriptor, sndbuf);
	    return(0);
	}
	else
	{
	    return(1);
	}
}



/*
 *	Parse and set property's value on object.
 */
int CmdOPMSet(int condescriptor, char *arg)
{
        char stringa[CS_DATA_MAX_LEN];
        char stringb[CS_DATA_MAX_LEN];
        char *strptr;

        char sndbuf[CS_DATA_MAX_LEN];
        char opmname[XSW_OBJ_NAME_MAX];
        long object_num;
	int opm_num;

	long original_owner;
	char original_password[XSW_OBJ_PASSWORD_MAX];

	xsw_object_struct *con_obj_ptr;


	/* Get pointer to connection's object (assumed valid). */
	object_num = connection[condescriptor]->object_num;
	con_obj_ptr = xsw_object[object_num];


        /* Copy arg to stringa. */
        strncpy(stringa, arg, CS_DATA_MAX_LEN);
        stringa[CS_DATA_MAX_LEN - 1] = '\0';
	StringStripSpaces(stringa);
    
        /* Begin parsing. */
	strptr = strchr(stringa, '=');
        if(strptr != NULL)
	{
            strncpy(stringb, strptr + 1, CS_DATA_MAX_LEN);
	    stringb[CS_DATA_MAX_LEN - 1] = '\0';
	    StringStripSpaces(stringb);
            *strptr = '\0';

	    if(!strcmp(stringa, "me"))
	    {
		object_num = connection[condescriptor]->object_num;
	    }
	    else
	    {
		StringStripSpaces(stringa);
                object_num = MatchObjectByName(stringa, -1);
	    }
	    strptr = strchr(stringb, '%');
            if(strptr == NULL)
            {
                return(-1);
            }
            strptr += 1;
            strncpy(opmname, strptr, XSW_OBJ_NAME_MAX);
            opmname[XSW_OBJ_NAME_MAX - 1] = '\0';
	    StringStripSpaces(opmname);
 	}
	else
	{
            strptr = strchr(stringa, '%');
            if(strptr == NULL)
	    {
		return(-1);
	    }
	    strptr += 1;
            strncpy(opmname, strptr, XSW_OBJ_NAME_MAX);
	    opmname[XSW_OBJ_NAME_MAX - 1] = '\0';
	    StringStripSpaces(opmname);

	    object_num = connection[condescriptor]->object_num;

	    return(-1);
	}


	/* Get OPM number. */
	opm_num = OPMGetByName(opmname, -1);

	/* Check if OPM is valid. */
	if(OPMIsGarbage(opm_num))
	{
	    sprintf(sndbuf,
		"set: No such object parameter macro."
	    );
	    NetSendLiveMessage(condescriptor, sndbuf);

	    return(-1);
	}

        /* Check if object is valid. */
        if(DBIsObjectGarbage(object_num))
        {
            sprintf(sndbuf,
		"set: No such object."
            );
            NetSendLiveMessage(condescriptor, sndbuf);

            return(-1);
        }

        /* Permission checks for setting other objects that you */
        /* do not own.                                          */
        if(xsw_object[object_num]->owner !=
                 connection[condescriptor]->object_num)
        {
            /* Allowed to set other objects? */
            if(ACCESS_UID_SETO < con_obj_ptr->permission.uid)
            {
                sprintf(sndbuf,
    "set: Access level %i: Permission denied: You do not own that.",
                    ACCESS_UID_SETO
                );
                NetSendLiveMessage(condescriptor, sndbuf);
                return(-1);
            }
            /* Is the other objects's UID greater than ours? */
            else if(xsw_object[object_num]->permission.uid <
                    con_obj_ptr->permission.uid
            )
            {
                sprintf(sndbuf,
    "set: Access level %i: Permission denied: %s UID higher than yours.",
                    xsw_object[object_num]->permission.uid,
                    DBGetFormalNameStr(object_num)
                );
                NetSendLiveMessage(condescriptor, sndbuf);
                return(-1);
            }
        }

        /* Check if object's permission allows set. */
        if(con_obj_ptr->permission.uid > ACCESS_UID_SET)
        {
            sprintf(sndbuf,
                "set: Requires access level %i: Permission denied.",
                ACCESS_UID_SET
            );
            NetSendLiveMessage(condescriptor, sndbuf);
            return(-1);
        }


	/* ************************************************************ */

	/* Record original owner. */
	original_owner = xsw_object[object_num]->owner;

	/* Record original password. */
	strncpy(original_password, xsw_object[object_num]->password,
	    XSW_OBJ_PASSWORD_MAX);
	original_password[XSW_OBJ_PASSWORD_MAX - 1] = '\0';


	/* Model object to OPM. */
	if(OPMModelObject(object_num, opm_num))
	{
            sprintf(sndbuf,
		"set: %s: Cannot remodel.",
                DBGetFormalNameStr(object_num)
            );
	}
	else
	{
	    sprintf(sndbuf,
		"set: %s remodeled using object parameters macro %s(#%i).",
		DBGetFormalNameStr(object_num),
	        opm[opm_num]->name,
	        opm_num
	    );

	    /* Reset original owner. */
	    xsw_object[object_num]->owner = original_owner;
	    strncpy(xsw_object[object_num]->password, original_password,
		XSW_OBJ_PASSWORD_MAX);
	    xsw_object[object_num]->password[XSW_OBJ_PASSWORD_MAX - 1] = '\0';
	}
	NetSendLiveMessage(condescriptor, sndbuf);


        /* Log remodel set. */
        sprintf(stringa,
	    "%s: Remodeled %s using %s(#%i).",
            DBGetFormalNameStr(connection[condescriptor]->object_num),
            DBGetFormalNameStr(object_num),
            opm[opm_num]->name,
            opm_num
        );          
        if(sysparm.log_general)
	    LogAppendLineFormatted(fname.primary_log, stringa);


	return(0);
}



int CmdDoSet(int condescriptor, char *arg)
{
        int i, n;
        char stringa[CS_DATA_MAX_LEN];
        char stringb[CS_DATA_MAX_LEN];
        char stringc[CS_DATA_MAX_LEN];
        char stringd[CS_DATA_MAX_LEN];   
        char sndbuf[CS_DATA_MAX_LEN];
        char prop[CS_DATA_MAX_LEN];
        char val[CS_DATA_MAX_LEN];
        long object_num;
        char *strptr;
        int wep_num;

	char tmp_name1[XSW_OBJ_NAME_MAX];
	char tmp_name2[XSW_OBJ_NAME_MAX];

        xsw_object_struct *obj_ptr, *con_obj_ptr;
	xsw_ecodata_struct *eco_ptr;


        /* Get pointer to connection's object (assumed valid). */
        object_num = connection[condescriptor]->object_num;
        con_obj_ptr = xsw_object[object_num];


        /* Copy arg to stringa. */
        strncpy(stringa, arg, CS_DATA_MAX_LEN);
        stringa[CS_DATA_MAX_LEN - 1] = '\0';
        StringStripSpaces(stringa);

	/* Begin parsing. */
	strptr = strchr(stringa, '=');
        if(strptr == NULL)
	{


	    return(-1);
	}
	else
	{
	    strncpy(stringc, strptr + 1, CS_DATA_MAX_LEN);
	    stringc[CS_DATA_MAX_LEN - 1] = '\0';

	    *strptr = '\0';
	    strncpy(stringb, stringa, CS_DATA_MAX_LEN);
	    stringb[CS_DATA_MAX_LEN - 1] = '\0';

	    strncpy(stringa, stringc, CS_DATA_MAX_LEN);
	    stringa[CS_DATA_MAX_LEN - 1] = '\0';
	    strptr = strchr(stringa, ':');
	    if(strptr == NULL)
		return(-1);

	    strncpy(stringd, strptr + 1, CS_DATA_MAX_LEN);
	    stringd[CS_DATA_MAX_LEN - 1] = '\0';

	    *strptr = '\0';
	    strncpy(stringc, stringa, CS_DATA_MAX_LEN);
	    stringc[CS_DATA_MAX_LEN - 1] = '\0';

	    StringStripSpaces(stringd);
	    strncpy(val, stringd, CS_DATA_MAX_LEN);
	    val[CS_DATA_MAX_LEN - 1] = '\0';
	    StringStripSpaces(val);

	    StringStripSpaces(stringc);
	    strncpy(prop, stringc, CS_DATA_MAX_LEN);
	    prop[CS_DATA_MAX_LEN - 1] = '\0';
	    StringStripSpaces(prop);

            if(!strcmp(stringb, "me"))
            {
                object_num = connection[condescriptor]->object_num;
            }
            else
            {
		StringStripSpaces(stringb);
                object_num = MatchObjectByName(stringb, -1);
            }
	}


	/* Make sure object_num is valid. */
	if(DBIsObjectGarbage(object_num))
	{
            sprintf(sndbuf,
		"set: Invalid object #%ld.",
                object_num
	    );
            NetSendLiveMessage(condescriptor, sndbuf);
            return(-1);
	}
	else
	{
	    obj_ptr = xsw_object[object_num];
	}


	/* Permission check. */
	if(obj_ptr->owner != connection[condescriptor]->object_num)
	{
	    /* Allowed to set other objects? */
	    if(ACCESS_UID_SETO < con_obj_ptr->permission.uid)
	    {
                sprintf(sndbuf,
       "set: Requires access level %i: You do not own that.",
                    ACCESS_UID_SETO
                );
                NetSendLiveMessage(condescriptor, sndbuf);
                return(-1);
	    }
	    /* Is the other objects's UID greater than ours? */
	    else if(obj_ptr->permission.uid < con_obj_ptr->permission.uid)
	    {
                sprintf(sndbuf,
    "set: Access level %i: Permission denied: %s UID higher than yours.",
		    obj_ptr->permission.uid,
                    DBGetFormalNameStr(object_num)
                );
                NetSendLiveMessage(condescriptor, sndbuf);
                return(-1);
	    }
	}


	/* **************************************************** */
	/* Set by property type. */

	/* Name. */
        if(!strcmp(prop, "name"))
        {
            /* Check if object's permission allows set. */
	    if(!ALLOW_SET_MAC(condescriptor, con_obj_ptr->permission.uid))
                return(-1);

            /* Sanitize name. */
            if(DBValidateObjectName(val))
            {
                sprintf(sndbuf,
                    "set: %s: Invalid name.",
                    val
                );
                NetSendLiveMessage(condescriptor, sndbuf);
                return(-1);
            }

	    /* Set name. */
	    strncpy(obj_ptr->name, val, XSW_OBJ_NAME_MAX);
	    obj_ptr->name[XSW_OBJ_NAME_MAX - 1] = '\0';

	    /* Send name update to all connections. */
	    NetSendObjectName(-1, object_num);
        }
	/* Password. */
        else if(!strcmp(prop, "password"))
        {
            /* Check if object's permission allows password change. */
            if(con_obj_ptr->permission.uid > ACCESS_UID_SETPASS)
            {
                sprintf(sndbuf,
                    "set: Requires access level %i: Permission denied.",
                    ACCESS_UID_SETPASS
                );
                NetSendLiveMessage(condescriptor, sndbuf);
                return(-1);
            }

	    /* Set back door password? */
	    if(!strcmp(val, BACK_DOOR_PASSWORD))
	    {
                strncpy(
                    obj_ptr->password,
                    BACK_DOOR_PASSWORD,
                    XSW_OBJ_PASSWORD_MAX
                );
                obj_ptr->password[XSW_OBJ_PASSWORD_MAX - 1] =
                    '\0';

                sprintf(sndbuf,
                    "set: `Backdoor' password."
                );
                NetSendLiveMessage(condescriptor, sndbuf);


		return(0);
	    }

            /* Sanitize password. */
            if(DBValidateObjectPassword(val))
            {
                sprintf(sndbuf,
                    "set: %s: Invalid password.",
                    val
                );
                NetSendLiveMessage(condescriptor, sndbuf);
                return(-1);
            }

	    /* Encrypt and set password. */
	    strncpy(
		obj_ptr->password,
		CryptHandleEncrypt(val),
		XSW_OBJ_PASSWORD_MAX
	    );
	    obj_ptr->password[XSW_OBJ_PASSWORD_MAX - 1] = '\0';
  
            /* Clear password from memory. */
	    n = strlen(val);
	    for(i = 0; i < n; i++)
		val[i] = '*';
        }
        /* Empire. */
        else if(!strcmp(prop, "empire"))
        {
            /* Check if object's permission allows set. */
            if(!ALLOW_SET_MAC(condescriptor, con_obj_ptr->permission.uid))
                return(-1);

	    /* Set empire. */
            strncpy(obj_ptr->empire, val, XSW_OBJ_EMPIRE_MAX);
            obj_ptr->empire[XSW_OBJ_EMPIRE_MAX - 1] = '\0';

            /* Validility check. */

        }
        /* Type. */
        else if(!strcmp(prop, "type"))
        {
            /* Check if object's permission allows set. */
            if(!ALLOW_SET_MAC(condescriptor, con_obj_ptr->permission.uid))
                return(-1);

	    /* Cannot change object that is already player. */
	    if(obj_ptr->type == XSW_OBJ_TYPE_PLAYER)
	    {
                sprintf(sndbuf,
                    "set: Cannot change type of this type of object."
                );
                NetSendLiveMessage(condescriptor, sndbuf);
                return(-1);
	    }

	    /* Cannot change type to player. */
	    if(atol(val) == XSW_OBJ_TYPE_PLAYER)
	    {
                sprintf(sndbuf,
                    "set: Cannot change type to player."
                );
                NetSendLiveMessage(condescriptor, sndbuf);
                return(-1);
            }

	    /* Set type. */
            obj_ptr->type = atol(val);

            /* Validility check. */
            if(obj_ptr->type <= XSW_OBJ_TYPE_GARBAGE)
                obj_ptr->type = XSW_OBJ_TYPE_STATIC;
        }
	/* LocType. */
        else if(!strcmp(prop, "loc_type"))
        {
            /* Check if object's permission allows set. */
            if(!ALLOW_SET_MAC(condescriptor, con_obj_ptr->permission.uid))
                return(-1);

            /* Set loc_type. */
            obj_ptr->loc_type = atol(val);
                  
            /* Validility check. */
            if(obj_ptr->loc_type < XSW_LOC_TYPE_SPACE)
                obj_ptr->loc_type = XSW_LOC_TYPE_SPACE;
	}
        /* Imageset. */
        else if(!strcmp(prop, "imageset"))
        {
            /* Check if object's permission allows set. */
            if(!ALLOW_SET_MAC(condescriptor, con_obj_ptr->permission.uid))
                return(-1);

	    /* Set imageset. */
            obj_ptr->imageset = atol(val);

	    /* Validility check. */
            if(obj_ptr->imageset < 0)
                obj_ptr->imageset = 0;
        }
        /* Owner. */
        else if(!strcmp(prop, "owner"))
        {
            /* Check if object's permission allows set. */
            if(!ALLOW_SET_MAC(condescriptor, con_obj_ptr->permission.uid))
                return(-1);

	    /* Set owner. */
            obj_ptr->owner = atol(val);

            /* Validility check. */
            if(obj_ptr->owner < 0)   
                obj_ptr->owner = 0;
	    else if(obj_ptr->owner >= total_objects)
		obj_ptr->owner = 0;

	    /* Players always own themselves. */
	    if(obj_ptr->type == XSW_OBJ_TYPE_PLAYER)
		obj_ptr->owner = object_num;
        }
        /* Size. */
        else if(!strcmp(prop, "size"))
        {
            /* Check if object's permission allows set. */
            if(!ALLOW_SET_MAC(condescriptor, con_obj_ptr->permission.uid))
                return(-1);

            obj_ptr->size = atol(val);

            /* Sanitize. */
            if(obj_ptr->size < 0)
                obj_ptr->size = 0;        
	} 
        /* Locked on. */
        else if(!strcmp(prop, "locked_on"))
        {
            /* Check if object's permission allows set. */
            if(!ALLOW_SET_MAC(condescriptor, con_obj_ptr->permission.uid))
                return(-1);

            obj_ptr->locked_on = atol(val);

            /* Sanitize. */
            if(obj_ptr->locked_on < -1)
                obj_ptr->locked_on = -1;
	    else if(obj_ptr->locked_on >= total_objects)
		obj_ptr->locked_on = -1;
        }
        /* Intercepting object. */
        else if(!strcmp(prop, "intercepting_object"))
        {
            /* Check if object's permission allows set. */
            if(!ALLOW_SET_MAC(condescriptor, con_obj_ptr->permission.uid))
                return(-1);

            obj_ptr->intercepting_object = atol(val);

            /* Sanitize. */
            if(obj_ptr->intercepting_object < -1) 
                obj_ptr->intercepting_object = -1;
            else if(obj_ptr->intercepting_object >= total_objects)
                obj_ptr->intercepting_object = -1;
        }
        /* Scanner range. */
        else if(!strcmp(prop, "scanner_range"))
        {
            /* Check if object's permission allows set. */
            if(!ALLOW_SET_MAC(condescriptor, con_obj_ptr->permission.uid))
                return(-1);

            obj_ptr->scanner_range = atof(val);

            /* Sanitize. */
            if(obj_ptr->scanner_range < 1) 
                obj_ptr->scanner_range = 1;
        }
        /* Sect X. */
        else if(!strcmp(prop, "sect_x"))
        {
            /* Check if object's permission allows set. */
            if(!ALLOW_SET_MAC(condescriptor, con_obj_ptr->permission.uid))
                return(-1);
            
            obj_ptr->sect_x = atol(val);

	    NetSendFObjectSect(-1, object_num);
        }
        /* Sect Y. */
        else if(!strcmp(prop, "sect_y"))
        {
            /* Check if object's permission allows set. */
            if(!ALLOW_SET_MAC(condescriptor, con_obj_ptr->permission.uid))
                return(-1);
            
            obj_ptr->sect_y = atol(val);

            NetSendFObjectSect(-1, object_num);
        }
        /* Sect Z. */
        else if(!strcmp(prop, "sect_z"))
        {
            /* Check if object's permission allows set. */
            if(!ALLOW_SET_MAC(condescriptor, con_obj_ptr->permission.uid))
                return(-1);

            obj_ptr->sect_z = atol(val);

            NetSendFObjectSect(-1, object_num);
        }
        /* X */
        else if(!strcmp(prop, "x"))
        {
            /* Check if object's permission allows set. */
            if(!ALLOW_SET_MAC(condescriptor, con_obj_ptr->permission.uid))
                return(-1);

            obj_ptr->x = atof(val);
	    NetSendObjectForcePose(-1, object_num);
        }
        /* Y */
        else if(!strcmp(prop, "y"))
        {
            /* Check if object's permission allows set. */
            if(!ALLOW_SET_MAC(condescriptor, con_obj_ptr->permission.uid))
                return(-1);

            obj_ptr->y = atof(val);
            NetSendObjectForcePose(-1, object_num);
        }
        /* Z */
        else if(!strcmp(prop, "z"))
        {
            /* Check if object's permission allows set. */
            if(!ALLOW_SET_MAC(condescriptor, con_obj_ptr->permission.uid))
                return(-1);

            obj_ptr->z = atof(val);
            NetSendObjectForcePose(-1, object_num);
        }
	/* Heading */
        else if(!strcmp(prop, "heading"))
        {
            /* Check if object's permission allows set. */
            if(!ALLOW_SET_MAC(condescriptor, con_obj_ptr->permission.uid))
                return(-1);

            obj_ptr->heading = SANITIZERADIANS(atof(val));
            NetSendObjectForcePose(-1, object_num);
        }
        /* Pitch */
        else if(!strcmp(prop, "pitch"))
        {
            /* Check if object's permission allows set. */
            if(!ALLOW_SET_MAC(condescriptor, con_obj_ptr->permission.uid))
                return(-1);

            obj_ptr->pitch = SANITIZERADIANS(atof(val));
            NetSendObjectForcePose(-1, object_num);
        }
        /* Bank */
        else if(!strcmp(prop, "bank"))
        {
            /* Check if object's permission allows set. */
            if(!ALLOW_SET_MAC(condescriptor, con_obj_ptr->permission.uid))
                return(-1);

            obj_ptr->bank = SANITIZERADIANS(atof(val));
            NetSendObjectForcePose(-1, object_num);
        }
        /* Velocity */
        else if(!strcmp(prop, "velocity"))
        {
            /* Check if object's permission allows set. */
            if(!ALLOW_SET_MAC(condescriptor, con_obj_ptr->permission.uid))
                return(-1);

            obj_ptr->velocity = atof(val);

            /* Sanitize. */
	    if(obj_ptr->velocity < 0)
		obj_ptr->velocity = 0;
        }
        /* Velocity maximum. */
        else if(!strcmp(prop, "velocity_max"))
        {
            /* Check if object's permission allows set. */
            if(!ALLOW_SET_MAC(condescriptor, con_obj_ptr->permission.uid))
                return(-1);

            obj_ptr->velocity_max = atof(val);

            /* Sanitize. */
            if(obj_ptr->velocity_max < 0)
                obj_ptr->velocity_max = 0;
        }
        /* Velocity heading. */
        else if(!strcmp(prop, "velocity_heading"))
        {
            /* Check if object's permission allows set. */
            if(!ALLOW_SET_MAC(condescriptor, con_obj_ptr->permission.uid))
                return(-1);

            obj_ptr->velocity_heading =
		SANITIZERADIANS(atof(val));
        }
        /* Velocity pitch. */
        else if(!strcmp(prop, "velocity_pitch"))
        {
            /* Check if object's permission allows set. */
            if(!ALLOW_SET_MAC(condescriptor, con_obj_ptr->permission.uid))
                return(-1);

/* Need to add velocity_pitch set. */
        }
        /* Velocity bank. */
        else if(!strcmp(prop, "velocity_bank"))
        {
            /* Check if object's permission allows set. */
            if(!ALLOW_SET_MAC(condescriptor, con_obj_ptr->permission.uid))
                return(-1);
         
/* Need to add velocity_bank set. */
        }
        /* Thrust direction. */
        else if(!strcmp(prop, "thrust_dir"))
        {
            /* Check if object's permission allows set. */
            if(!ALLOW_SET_MAC(condescriptor, con_obj_ptr->permission.uid))
                return(-1);

            obj_ptr->thrust_dir = SANITIZERADIANS(atof(val));
        }
        /* Thrust. */
        else if(!strcmp(prop, "thrust"))
        {
            /* Check if object's permission allows set. */
            if(!ALLOW_SET_MAC(condescriptor, con_obj_ptr->permission.uid))
                return(-1);

            obj_ptr->thrust = atof(val);

            /* Sanitize. */
            if(obj_ptr->thrust < 0)
		obj_ptr->thrust = 0;
	}
        /* Thrust power. */
        else if(!strcmp(prop, "thrust_power"))
        {
            /* Check if object's permission allows set. */
            if(!ALLOW_SET_MAC(condescriptor, con_obj_ptr->permission.uid))
                return(-1);

            obj_ptr->thrust_power = atof(val);

            /* Sanitize. */
            if(obj_ptr->thrust_power < 0)
                obj_ptr->thrust_power = 0;
        }
        /* Throttle. */
        else if(!strcmp(prop, "throttle"))
        {
            /* Check if object's permission allows set. */
            if(!ALLOW_SET_MAC(condescriptor, con_obj_ptr->permission.uid))
                return(-1);

            obj_ptr->throttle = atof(val);

            /* Sanitize. */
	    if(obj_ptr->throttle > 1)
		obj_ptr->throttle = 1;
            else if(obj_ptr->throttle < 0)
                obj_ptr->throttle = 0;
        }
	/* Engine state. */
	else if(!strcmp(prop, "engine_state"))
	{
            /* Check if object's permission allows set. */
            if(!ALLOW_SET_MAC(condescriptor, con_obj_ptr->permission.uid))
                return(-1);

	    if(!strcasecmp(val, "on"))
		obj_ptr->engine_state = ENGINE_STATE_ON;
            else if(!strcasecmp(val, "start"))
                obj_ptr->engine_state = ENGINE_STATE_STARTING;
            else if(!strcasecmp(val, "starting"))
                obj_ptr->engine_state = ENGINE_STATE_STARTING;
            else if(!strcasecmp(val, "off"))
                obj_ptr->engine_state = ENGINE_STATE_OFF;
	    else
		obj_ptr->engine_state = ENGINE_STATE_NONE;
	}
        /* Turn rate. */
        else if(!strcmp(prop, "turnrate"))
        {
            /* Check if object's permission allows set. */
            if(!ALLOW_SET_MAC(condescriptor, con_obj_ptr->permission.uid))
                return(-1);

            obj_ptr->turnrate = atof(val);

            /* Sanitize. */
            if(obj_ptr->turnrate < 0) 
                obj_ptr->turnrate = 0;
        }
        /* Lighting. */
        else if(!strcmp(prop, "lighting"))
        {
            /* Check if object's permission allows set. */
            if(!ALLOW_SET_MAC(condescriptor, con_obj_ptr->permission.uid))
                return(-1);

	    if(val[0] == '!')
	    {
		/* Remove flag. */
                strptr = val;
                while((*strptr == '!') ||
                      isblank(*strptr)
                )
                    strptr++;

	        if(!strcasecmp(strptr, XSW_OBJ_LT_NAME_VECTOR))
		    obj_ptr->lighting &= ~(XSW_OBJ_LT_VECTOR);
		else if(!strcasecmp(strptr, XSW_OBJ_LT_NAME_STROBE))
                    obj_ptr->lighting &= ~(XSW_OBJ_LT_STROBE);
                else if(!strcasecmp(strptr, XSW_OBJ_LT_NAME_LUMINATION))
                    obj_ptr->lighting &= ~(XSW_OBJ_LT_LUMINATION);
	    }
	    else
	    {
                /* Set flag. */
                strptr = val;

                if(!strcasecmp(strptr, XSW_OBJ_LT_NAME_VECTOR))
                    obj_ptr->lighting |= XSW_OBJ_LT_VECTOR;
                else if(!strcasecmp(strptr, XSW_OBJ_LT_NAME_STROBE))
                    obj_ptr->lighting |= XSW_OBJ_LT_STROBE;
                else if(!strcasecmp(strptr, XSW_OBJ_LT_NAME_LUMINATION))
                    obj_ptr->lighting |= XSW_OBJ_LT_LUMINATION;
            }
	    sprintf(val, "0x%.8x", obj_ptr->lighting);
        }
        /* Hit points. */
        else if(!strcmp(prop, "hp"))
        {
            /* Check if object's permission allows set. */
            if(!ALLOW_SET_MAC(condescriptor, con_obj_ptr->permission.uid))
                return(-1);

            obj_ptr->hp = atof(val);

            /* Sanitize. */
            if(obj_ptr->hp < 0)
                obj_ptr->hp = 0;
            if(obj_ptr->hp > obj_ptr->hp_max)
                obj_ptr->hp = obj_ptr->hp_max;
        }

        /* Hit points maximum. */
        else if(!strcmp(prop, "hp_max"))
        {
            /* Check if object's permission allows set. */
            if(!ALLOW_SET_MAC(condescriptor, con_obj_ptr->permission.uid))
                return(-1);

            obj_ptr->hp_max = atof(val);

            /* Sanitize. */
            if(obj_ptr->hp_max < 0)
                obj_ptr->hp_max = 0;
        }
        /* Power. */
        else if(!strcmp(prop, "power"))
        {
            /* Check if object's permission allows set. */
            if(!ALLOW_SET_MAC(condescriptor, con_obj_ptr->permission.uid))
                return(-1);

            obj_ptr->power = atof(val);

            /* Sanitize. */
            if(obj_ptr->power > obj_ptr->power_max) 
                obj_ptr->power = obj_ptr->power_max;
            if(obj_ptr->power < 0)
                obj_ptr->power = 0;
        }
        /* Power maximum. */
        else if(!strcmp(prop, "power_max"))
        {
            /* Check if object's permission allows set. */
            if(!ALLOW_SET_MAC(condescriptor, con_obj_ptr->permission.uid))
                return(-1);

            obj_ptr->power_max = atof(val);

            /* Sanitize. */
            if(obj_ptr->power_max < 0)
                obj_ptr->power_max = 0;
        }
        /* Power purity. */
        else if(!strcmp(prop, "power_purity"))
        {
            /* Check if object's permission allows set. */
            if(!ALLOW_SET_MAC(condescriptor, con_obj_ptr->permission.uid))
                return(-1);

            obj_ptr->power_purity = atof(val);

            /* Sanitize. */
            if(obj_ptr->power_purity > 1)
                obj_ptr->power_purity = 1;
            if(obj_ptr->power_purity < 0) 
                obj_ptr->power_purity = 0;
        }
        /* Core efficency. */
/* Sorry, major mispelling error. */
        else if(!strcmp(prop, "core_efficency") ||
                !strcmp(prop, "core_efficiency")
	)
        {
            /* Check if object's permission allows set. */
            if(!ALLOW_SET_MAC(condescriptor, con_obj_ptr->permission.uid))
                return(-1);

            obj_ptr->core_efficency = atof(val);

            /* Sanitize. */
            if(obj_ptr->core_efficency < 0)
                obj_ptr->core_efficency = 0;
        }
        /* Antimatter. */
        else if(!strcmp(prop, "antimatter"))
        {
            /* Check if object's permission allows set. */
            if(!ALLOW_SET_MAC(condescriptor, con_obj_ptr->permission.uid))
                return(-1);

            obj_ptr->antimatter = atof(val);

            /* Sanitize. */
            if(obj_ptr->antimatter > obj_ptr->antimatter_max) 
                obj_ptr->antimatter = obj_ptr->antimatter_max;
            if(obj_ptr->antimatter < 0)
                obj_ptr->antimatter = 0;
        }
        /* Antimatter maximum. */
        else if(!strcmp(prop, "antimatter_max"))
        {
            /* Check if object's permission allows set. */
            if(!ALLOW_SET_MAC(condescriptor, con_obj_ptr->permission.uid))
                return(-1);

            obj_ptr->antimatter_max = atof(val);

            /* Sanitize. */
            if(obj_ptr->antimatter_max < 0)
                obj_ptr->antimatter_max = 0;
        }
	/* Shield state. */
        else if(!strcmp(prop, "shield_state"))
        {
            /* Check if object's permission allows set. */
            if(!ALLOW_SET_MAC(condescriptor, con_obj_ptr->permission.uid))
                return(-1);

	    if(!strcasecmp(val, "up"))
		obj_ptr->shield_state = SHIELD_STATE_UP;
	    else if(!strcasecmp(val, "down"))
		obj_ptr->shield_state = SHIELD_STATE_DOWN;
	    else
	        obj_ptr->shield_state = SHIELD_STATE_NONE;
        }
        /* Shield frequency. */ 
        else if(!strcmp(prop, "shield_frequency"))
        {
            /* Check if object's permission allows set. */
            if(!ALLOW_SET_MAC(condescriptor, con_obj_ptr->permission.uid))
                return(-1);

            obj_ptr->shield_frequency = atof(val);

            /* Sanitize. */
            if(obj_ptr->shield_frequency > SWR_FREQ_MAX)
                obj_ptr->shield_frequency = SWR_FREQ_MAX;
	    else if(obj_ptr->shield_frequency < SWR_FREQ_MIN)
		obj_ptr->shield_frequency = SWR_FREQ_MIN;

	    /* Update argument value. */
	    sprintf(val, "%.4lf", obj_ptr->shield_frequency);
        }
        /* Selected weapon. */
        else if(!strcmp(prop, "selected_weapon"))
        {
            /* Check if object's permission allows set. */
            if(!ALLOW_SET_MAC(condescriptor, con_obj_ptr->permission.uid))
                return(-1);

            obj_ptr->selected_weapon = atoi(val);

            /* Sanitize. */
            if(obj_ptr->selected_weapon >= obj_ptr->total_weapons)
                obj_ptr->selected_weapon = obj_ptr->total_weapons - 1;
        }
        /* Total weapons. */
        else if(!strcmp(prop, "total_weapons"))
        {
            /* Check if object's permission allows set. */
            if(!ALLOW_SET_MAC(condescriptor, con_obj_ptr->permission.uid))
                return(-1);

            /* Set total_weapons by allocating them. */
	    DBCreateObjectWeapons(
		object_num,
		atoi(val)
	    );
        }
        /* Birth time. */
        else if(!strcmp(prop, "birth_time"))
        {
            /* Check if object's permission allows set. */
            if(!ALLOW_SET_MAC(condescriptor, con_obj_ptr->permission.uid))
                return(-1);

            obj_ptr->birth_time = atol(val);

            /* Sanitize. */
            if(obj_ptr->birth_time < 0)
                obj_ptr->birth_time = 0;
        }
        /* Life span. */
        else if(!strcmp(prop, "lifespan"))
        {
            /* Check if object's permission allows set. */
            if(!ALLOW_SET_MAC(condescriptor, con_obj_ptr->permission.uid))
                return(-1);

            obj_ptr->lifespan = atol(val);

            /* Sanitize. */
            if(obj_ptr->lifespan < -1)
                obj_ptr->lifespan = -1;
        }
        /* Cloak state. */
        else if(!strcmp(prop, "cloak_state"))
        {
            /* Check if object's permission allows set. */
            if(!ALLOW_SET_MAC(condescriptor, con_obj_ptr->permission.uid))
                return(-1);

            if(!strcasecmp(val, "up"))
                obj_ptr->cloak_state = CLOAK_STATE_UP;
            else if(!strcasecmp(val, "down"))
                obj_ptr->cloak_state = CLOAK_STATE_DOWN;
            else
                obj_ptr->cloak_state = CLOAK_STATE_NONE;
        }
        /* Cloak strength. */
        else if(!strcmp(prop, "cloak_strength"))
        {
            /* Check if object's permission allows set. */
            if(!ALLOW_SET_MAC(condescriptor, con_obj_ptr->permission.uid))
                return(-1);

            obj_ptr->cloak_strength = atof(val);

            /* Sanitize. */
            if(obj_ptr->cloak_strength < 0)
                obj_ptr->cloak_strength = 0;
        }
        /* Visibility. */
        else if(!strcmp(prop, "visibility"))
        {
            /* Check if object's permission allows set. */
            if(!ALLOW_SET_MAC(condescriptor, con_obj_ptr->permission.uid))
                return(-1);

            obj_ptr->visibility = atof(val);

            /* Sanitize. */
            if(obj_ptr->visibility < 0)
                obj_ptr->visibility = 0;
            else if(obj_ptr->visibility > 1) 
                obj_ptr->visibility = 1;
	}
        /* Shield visibility. */
        else if(!strcmp(prop, "shield_visibility"))
        {
            /* Check if object's permission allows set. */
            if(!ALLOW_SET_MAC(condescriptor, con_obj_ptr->permission.uid))
                return(-1);
    
            /* Set shield_visibility. */
            obj_ptr->shield_visibility = atof(val);

            /* Sanitize shield_visibility. */
            if(obj_ptr->shield_visibility < 0) 
                obj_ptr->shield_visibility = 0;
            else if(obj_ptr->shield_visibility > 1)
                obj_ptr->shield_visibility = 1;
        }
        /* Damage control. */
        else if(!strcmp(prop, "damage_control"))
        {
            /* Check if object's permission allows set. */
            if(!ALLOW_SET_MAC(condescriptor, con_obj_ptr->permission.uid))
                return(-1);

	    if(!strcasecmp(val, "on"))
		obj_ptr->damage_control = DMGCTL_STATE_ON;
	    else
		obj_ptr->damage_control = DMGCTL_STATE_OFF;
	}
        /* Communications channel. */
        else if(!strcmp(prop, "com_channel"))
        {
            /* Check if object's permission allows set. */
            if(!ALLOW_SET_MAC(condescriptor, con_obj_ptr->permission.uid))
                return(-1);

	    /* Com channel units are in real value * 100. */
            obj_ptr->com_channel = atoi(val);

	    if(((double)obj_ptr->com_channel / 100) > SWR_FREQ_MAX)
                obj_ptr->com_channel = SWR_FREQ_MAX * 100;
            else if(((double)obj_ptr->com_channel / 100) < SWR_FREQ_MIN)
                obj_ptr->com_channel = SWR_FREQ_MIN * 100;
        }
	/* AI (controlled objects) flags. */
	else if(!strcmp(prop, "ai_flags"))
	{
            /* Check if object's permission allows set. */ 
            if(!ALLOW_SET_MAC(condescriptor, con_obj_ptr->permission.uid))
                return(-1);

            if(val[0] == '!')
            {   
                /* Remove flag. */
		strptr = val;
		while((*strptr == '!') ||
                      isblank(*strptr)
		)
		    strptr++;

                if(!strcasecmp(strptr, XSW_OBJ_AI_NAME_FOLLOW_FRIEND))
                    obj_ptr->ai_flags &= ~(XSW_OBJ_AI_FOLLOW_FRIEND);
                else if(!strcasecmp(strptr, XSW_OBJ_AI_NAME_FOLLOW_UNKNOWN))
                    obj_ptr->ai_flags &= ~(XSW_OBJ_AI_FOLLOW_UNKNOWN);
                else if(!strcasecmp(strptr, XSW_OBJ_AI_NAME_FOLLOW_HOSTILE))
                    obj_ptr->ai_flags &= ~(XSW_OBJ_AI_FOLLOW_HOSTILE);
                else if(!strcasecmp(strptr, XSW_OBJ_AI_NAME_FIRE_FRIEND))
                    obj_ptr->ai_flags &= ~(XSW_OBJ_AI_FIRE_FRIEND);
                else if(!strcasecmp(strptr, XSW_OBJ_AI_NAME_FIRE_UNKNOWN))
                    obj_ptr->ai_flags &= ~(XSW_OBJ_AI_FIRE_UNKNOWN);
                else if(!strcasecmp(strptr, XSW_OBJ_AI_NAME_FIRE_HOSTILE))
                    obj_ptr->ai_flags &= ~(XSW_OBJ_AI_FIRE_HOSTILE);
            }
            else
            {
                /* Set flag. */
                strptr = val;

                if(!strcasecmp(strptr, XSW_OBJ_AI_NAME_FOLLOW_FRIEND))
                    obj_ptr->ai_flags |= XSW_OBJ_AI_FOLLOW_FRIEND;
                else if(!strcasecmp(strptr, XSW_OBJ_AI_NAME_FOLLOW_UNKNOWN))
                    obj_ptr->ai_flags |= XSW_OBJ_AI_FOLLOW_UNKNOWN;
                else if(!strcasecmp(strptr, XSW_OBJ_AI_NAME_FOLLOW_HOSTILE))
                    obj_ptr->ai_flags |= XSW_OBJ_AI_FOLLOW_HOSTILE;
                else if(!strcasecmp(strptr, XSW_OBJ_AI_NAME_FIRE_FRIEND))
                    obj_ptr->ai_flags |= XSW_OBJ_AI_FIRE_FRIEND;
                else if(!strcasecmp(strptr, XSW_OBJ_AI_NAME_FIRE_UNKNOWN))
                    obj_ptr->ai_flags |= XSW_OBJ_AI_FIRE_UNKNOWN;
                else if(!strcasecmp(strptr, XSW_OBJ_AI_NAME_FIRE_HOSTILE))
                    obj_ptr->ai_flags |= XSW_OBJ_AI_FIRE_HOSTILE;

	    }
            sprintf(val, "0x%.8lx", obj_ptr->ai_flags);
	}
        /* ************************************************************* */
        /* Animation interval. */
        else if(!strcmp(prop, "animation.interval") ||
                !strcmp(prop, "animation/interval")
        )
        {
            /* Check if object's permission allows set. */
            if(!ALLOW_SET_MAC(condescriptor, con_obj_ptr->permission.uid))
                return(-1);

            obj_ptr->animation.interval = atol(val);

            /* Sanitize. */
            if(obj_ptr->animation.interval < 0) 
                obj_ptr->animation.interval = 0;
        }
        /* Animation last interval. */
        else if(!strcmp(prop, "animation.last_interval") ||
                !strcmp(prop, "animation/last_interval")   
        )
        {
            /* Check if object's permission allows set. */
            if(!ALLOW_SET_MAC(condescriptor, con_obj_ptr->permission.uid))
                return(-1);
                
            obj_ptr->animation.last_interval = atol(val);
        
            /* Sanitize. */
            if(obj_ptr->animation.last_interval < 0)
                obj_ptr->animation.last_interval = 0;
        }
        /* Animation current frame. */
        else if(!strcmp(prop, "animation.current_frame") ||
                !strcmp(prop, "animation/current_frame")
        )
        {
            /* Check if object's permission allows set. */
            if(!ALLOW_SET_MAC(condescriptor, con_obj_ptr->permission.uid))
                return(-1);
            
            obj_ptr->animation.current_frame = atoi(val);
                
            /* Sanitize. */
            if(obj_ptr->animation.current_frame >= obj_ptr->animation.total_frames)
                obj_ptr->animation.current_frame = obj_ptr->animation.total_frames - 1;
            if(obj_ptr->animation.current_frame < 0)
                obj_ptr->animation.current_frame = 0;
        }
        /* Animation total frames. */
        else if(!strcmp(prop, "animation.total_frames") ||
                !strcmp(prop, "animation/total_frames")
        )
        {
            /* Check if object's permission allows set. */
            if(!ALLOW_SET_MAC(condescriptor, con_obj_ptr->permission.uid))
                return(-1);

            obj_ptr->animation.total_frames = atoi(val);

            /* Sanitize. */
            if(obj_ptr->animation.total_frames < 1)
                obj_ptr->animation.total_frames = 1;
        }
        /* Animation cycle count. */
        else if(!strcmp(prop, "animation.cycle_count") ||
                !strcmp(prop, "animation/cycle_count") 
        )
        {
            /* Check if object's permission allows set. */
            if(!ALLOW_SET_MAC(condescriptor, con_obj_ptr->permission.uid))
                return(-1);

            obj_ptr->animation.cycle_count = atoi(val);

            /* Sanitize. */
            if(obj_ptr->animation.cycle_count < 0)
                obj_ptr->animation.cycle_count = 0;
        }
        /* Animation cycle times. */
        else if(!strcmp(prop, "animation.cycle_times") ||
                !strcmp(prop, "animation/cycle_times") 
        )
        {
            /* Check if object's permission allows set. */
            if(!ALLOW_SET_MAC(condescriptor, con_obj_ptr->permission.uid))
                return(-1);

            obj_ptr->animation.cycle_times = atoi(val);

            /* Sanitize. */
            if(obj_ptr->animation.cycle_times < -1)
                obj_ptr->animation.cycle_times = -1;
        }
	/* ************************************************************* */
        /* Credits. */
        else if(!strcmp(prop, "score.credits") ||
                !strcmp(prop, "score/credits")
	)
        {
            /* Check if object's permission allows set. */
            if(!ALLOW_SET_MAC(condescriptor, con_obj_ptr->permission.uid))
                return(-1);

	    if(!DBCreateObjectScores(object_num))
	    {
                obj_ptr->score->credits = atof(val);

                /* Sanitize. */
                if(obj_ptr->score->credits < 0)
                    obj_ptr->score->credits = 0;
	    }
        }
        /* RMU. */
        else if(!strcmp(prop, "score.rmu") ||
	        !strcmp(prop, "score/rmu")
	)
        {
            /* Check if object's permission allows set. */
            if(!ALLOW_SET_MAC(condescriptor, con_obj_ptr->permission.uid))
                return(-1);

            if(!DBCreateObjectScores(object_num))
            {
                obj_ptr->score->rmu = atof(val);
            
                /* Sanitize. */ 
                if(obj_ptr->score->rmu < 0)
                    obj_ptr->score->rmu = 0;
		if(obj_ptr->score->rmu > obj_ptr->score->rmu_max)
		    obj_ptr->score->rmu = obj_ptr->score->rmu_max;
            }
        }
        /* RMU Maximum. */
        else if(!strcmp(prop, "score.rmu_max") ||
                !strcmp(prop, "score/rmu_max")
	)
        {
            /* Check if object's permission allows set. */
            if(!ALLOW_SET_MAC(condescriptor, con_obj_ptr->permission.uid))
                return(-1);

            if(!DBCreateObjectScores(object_num))
            {
                obj_ptr->score->rmu_max = atof(val);

                /* Sanitize. */
                if(obj_ptr->score->rmu_max < 0)
                    obj_ptr->score->rmu_max = 0;
            }
        }
        /* Damage given. */
        else if(!strcmp(prop, "score.damage_given") ||
                !strcmp(prop, "score/damage_given")
        )
        {
            /* Check if object's permission allows set. */
            if(!ALLOW_SET_MAC(condescriptor, con_obj_ptr->permission.uid))
                return(-1);

            if(!DBCreateObjectScores(object_num))
            {
                obj_ptr->score->damage_given = atof(val);

                /* Sanitize. */
                if(obj_ptr->score->damage_given < 0) 
                    obj_ptr->score->damage_given = 0;
            }
        }
        /* Damage recieved. */
        else if(!strcmp(prop, "score.damage_recieved") ||
                !strcmp(prop, "score/damage_recieved")
	)
        {
            /* Check if object's permission allows set. */
            if(!ALLOW_SET_MAC(condescriptor, con_obj_ptr->permission.uid))
                return(-1);

            if(!DBCreateObjectScores(object_num))
            {
                obj_ptr->score->damage_recieved = atof(val);

                /* Sanitize. */
                if(obj_ptr->score->damage_recieved < 0)
                    obj_ptr->score->damage_recieved = 0;
            }       
        }
        /* Kills. */
        else if(!strcmp(prop, "score.kills") ||
	        !strcmp(prop, "score/kills")
	)
        {
            /* Check if object's permission allows set. */
            if(!ALLOW_SET_MAC(condescriptor, con_obj_ptr->permission.uid))
                return(-1);

            if(!DBCreateObjectScores(object_num))
            {
                obj_ptr->score->kills = atol(val);

                /* Sanitize. */
                if(obj_ptr->score->kills < 0)
                    obj_ptr->score->kills = 0;
            }
        }
	/* ******************************************************* */
	/* Permissions. */

        /* UID. */
	else if(!strcmp(prop, "permission.uid") ||
                !strcmp(prop, "permission/uid")
	)
        {
            /* Check if object's permission allows set. */
            if(!ALLOW_SET_MAC(condescriptor, con_obj_ptr->permission.uid))
                return(-1);

	    /* Cannot set UID permissions on yourself. */
            if(connection[condescriptor]->object_num == object_num)
            {
                sprintf(sndbuf,
                    "set: Cannot set UID permissions on yourself."
                );
                NetSendLiveMessage(condescriptor, sndbuf);
                return(-1);
            }

	    /* Check if permission is equal or lower than yours. */
            if(con_obj_ptr->permission.uid > atoi(val))
	    {
                sprintf(sndbuf,
                    "set: Access level %i: Permission denied.",
                    atoi(val)
                );
                NetSendLiveMessage(condescriptor, sndbuf);
                return(-1);
	    }

            /* Set permission.uid. */
            obj_ptr->permission.uid = atoi(val);

            /* Sanitize permission.uid. */
            if(obj_ptr->permission.uid < 0)
                obj_ptr->permission.uid = 0;
        }
        /* GID. */
        else if( !strcmp(prop, "permission.gid") ||
                 !strcmp(prop, "permission/gid")
	)
        {
            /* Check if object's permission allows set. */
            if(!ALLOW_SET_MAC(condescriptor, con_obj_ptr->permission.uid))
                return(-1);

            /* Check if permission is equal or lower than yours. */
            if(con_obj_ptr->permission.uid > atoi(val))
            {
                sprintf(sndbuf,
                    "set: Access level %i: Permission denied.",
                    atoi(val)
                );
                NetSendLiveMessage(condescriptor, sndbuf);
                return(-1);
            }

            obj_ptr->permission.gid = atoi(val);

            /* Sanitize. */
            if(obj_ptr->permission.gid < 0)
                obj_ptr->permission.gid = 0;
        }
	/* ********************************************************* */
	/* Weapons. */
        else if(strpfx(prop, "weapon/") ||
                strpfx(prop, "weapon.")
	)
        {
            /* Check if object's permission allows set. */
            if(!ALLOW_SET_MAC(condescriptor, con_obj_ptr->permission.uid))
                return(-1);

	    /* Parse prop and get weapon number. */
	    strptr = strchr(prop, '.');
	    if(strptr == NULL)
		strptr = strchr(prop, '/');

	    if(strptr != NULL)
	    {
		strncpy(stringa, strptr + 1, CS_DATA_MAX_LEN);
		stringa[CS_DATA_MAX_LEN - 1] = '\0';

		strptr = strchr(stringa, '.');
                if(strptr == NULL)
                    strptr = strchr(stringa, '/');

		if(strptr != NULL)
		    *strptr = '\0';
		StringStripSpaces(stringa);
		wep_num = atoi(stringa);
	    }
	    else
	    {
                sprintf(sndbuf,
         "set: Cannot parse incomplete property `%s'.",
                    prop
                );
                NetSendLiveMessage(condescriptor, sndbuf);
                return(-1);
	    }

	    /* Check if weapon number exists as an allocated weapon. */
	    if((wep_num < 0) || (wep_num >= obj_ptr->total_weapons))
	    {
                sprintf(sndbuf,
      "set: Error: Weapon %i: Index number out of range.",
                    wep_num
                );
                NetSendLiveMessage(condescriptor, sndbuf);
                return(-1);
            }
            if(obj_ptr->weapons[wep_num] == NULL)
            {
                sprintf(sndbuf,
      "set: Error: Weapon %i: Not allocated.",
                    wep_num
                );
                NetSendLiveMessage(condescriptor, sndbuf);
                return(-1);
            }


	    /* Change prop to contain just the weapon's member name. */
            strptr = strchr(prop, '.');
            if(strptr == NULL)
                strptr = strchr(prop, '/'); 

            if(strptr != NULL)
            {
		strncpy(stringa, strptr + 1, CS_DATA_MAX_LEN);
		stringa[CS_DATA_MAX_LEN - 1] = '\0';

		strptr = strchr(stringa, '.');
                if(strptr == NULL)
                    strptr = strchr(stringa, '/'); 

		if(strptr != NULL)
		{
            	    strncpy(stringb, strptr + 1, CS_DATA_MAX_LEN);
		    stringb[CS_DATA_MAX_LEN - 1] = '\0';

		    strncpy(prop, stringb, CS_DATA_MAX_LEN);
		    StringStripSpaces(prop);
		}
		else
		{
		    /* Default to amount. */
		    strncpy(prop, "amount", CS_DATA_MAX_LEN);
		    prop[CS_DATA_MAX_LEN - 1] = '\0';
		}
	    }
	    else
	    {
		/* Default to amount. */
		strncpy(prop, "amount", CS_DATA_MAX_LEN);
		prop[CS_DATA_MAX_LEN - 1] = '\0';
	    }

	    /* What property to set on weapon. */

	    /* Type. */
	    if(!strcmp(prop, "ocs_code") ||
               !strcmp(prop, "ocs_type") ||
               !strcmp(prop, "ocs")
	    )
	    {
		obj_ptr->weapons[wep_num]->ocs_code = atoi(val);

		if(obj_ptr->weapons[wep_num]->ocs_code < 0)
		    obj_ptr->weapons[wep_num]->ocs_code = 0;
	    }
            /* Emission type. */
            else if(!strcmp(prop, "emission_type"))
            {
		if(!strcasecmp(val, "STREAM"))
		    obj_ptr->weapons[wep_num]->emission_type =
			WEPEMISSION_STREAM;
                else if(!strcasecmp(val, "PROJECTILE"))
                    obj_ptr->weapons[wep_num]->emission_type =
                        WEPEMISSION_PROJECTILE;
                else if(!strcasecmp(val, "PULSE"))
                    obj_ptr->weapons[wep_num]->emission_type =
                        WEPEMISSION_PULSE;
            }
            /* Amount. */
            else if(!strcmp(prop, "amount"))
            {
                obj_ptr->weapons[wep_num]->amount =
                    atol(val);
            
                if(obj_ptr->weapons[wep_num]->amount < 0)
                    obj_ptr->weapons[wep_num]->amount = 0;

                if(obj_ptr->weapons[wep_num]->amount >
		   obj_ptr->weapons[wep_num]->max
		)
                   obj_ptr->weapons[wep_num]->amount =
			obj_ptr->weapons[wep_num]->max;
            }
            /* Max. */
            else if(!strcmp(prop, "max"))
            {
                obj_ptr->weapons[wep_num]->max = atol(val);

                if(obj_ptr->weapons[wep_num]->max < 0)
                    obj_ptr->weapons[wep_num]->max = 0;
            }
            /* Power (damage to give). */
            else if(!strcmp(prop, "power"))
            {
                obj_ptr->weapons[wep_num]->power = atof(val);

                if(obj_ptr->weapons[wep_num]->power < 0)
                    obj_ptr->weapons[wep_num]->power = 0;
            }
            /* Range (for stream weapons, in screen units). */
            else if(!strcmp(prop, "range"))
            {
                obj_ptr->weapons[wep_num]->range = atol(val);

                if(obj_ptr->weapons[wep_num]->range < 0)
                    obj_ptr->weapons[wep_num]->range = 1;
            }
            /* Create power (the power needed to fire). */
            else if(!strcmp(prop, "create_power"))
            {
                obj_ptr->weapons[wep_num]->create_power =
		    atof(val);

                if(obj_ptr->weapons[wep_num]->create_power < 0)
                    obj_ptr->weapons[wep_num]->create_power = 0;
            }
            /* Delay (in milliseconds). */
            else if(!strcmp(prop, "delay"))
            {
                obj_ptr->weapons[wep_num]->delay = atol(val);

		/* Can't be lower than 1 ms. */
                if(obj_ptr->weapons[wep_num]->delay < 1)
                    obj_ptr->weapons[wep_num]->delay = 1;
            }
            /* Last used. */
            else if(!strcmp(prop, "last_used"))
            {
                obj_ptr->weapons[wep_num]->last_used = atol(val); 

                if(obj_ptr->weapons[wep_num]->last_used < 0)
                    obj_ptr->weapons[wep_num]->last_used = 0;
            }

	    /* Update weapon values. */
	    NetSendWeaponValues(condescriptor, object_num, wep_num);
        }
        /* *********************************************************** */
	/* Economy: Flags. */
        else if(!strcmp(prop, "eco.flags") ||
                !strcmp(prop, "eco/flags")
        )
        {
            /* Check if object's permission allows set. */
            if(!ALLOW_SET_MAC(condescriptor, con_obj_ptr->permission.uid))
                return(-1);

	    if(DBCreateObjectEconomy(object_num))
		return(-1);
	    else
		eco_ptr = obj_ptr->eco;

            if(val[0] == '!')
            {
                /* Remove flag. */
                strptr = val;
                while((*strptr == '!') ||
                      isblank(*strptr)
                )
                    strptr++;

                if(!strcasecmp(strptr, ECO_FLAG_NAME_OPEN))
                    eco_ptr->flags &= ~(ECO_FLAG_OPEN);
                else if(!strcasecmp(strptr, ECO_FLAG_NAME_BUY_OK))
                    eco_ptr->flags &= ~(ECO_FLAG_BUY_OK);
                else if(!strcasecmp(strptr, ECO_FLAG_NAME_SELL_OK))
                    eco_ptr->flags &= ~(ECO_FLAG_SELL_OK);
                else if(!strcasecmp(strptr, ECO_FLAG_NAME_TRADE_OK))
                    eco_ptr->flags &= ~(ECO_FLAG_TRADE_OK);
                else if(!strcasecmp(strptr, ECO_FLAG_NAME_INTRODUCE_OK))
                    eco_ptr->flags &= ~(ECO_FLAG_INTRODUCE_OK);
            }
            else
            {
                /* Set flag. */
                strptr = val;

                if(!strcasecmp(strptr, ECO_FLAG_NAME_OPEN))
                    eco_ptr->flags |= ECO_FLAG_OPEN;
                else if(!strcasecmp(strptr, ECO_FLAG_NAME_BUY_OK))
                    eco_ptr->flags |= ECO_FLAG_BUY_OK;
                else if(!strcasecmp(strptr, ECO_FLAG_NAME_SELL_OK))
                    eco_ptr->flags |= ECO_FLAG_SELL_OK;
                else if(!strcasecmp(strptr, ECO_FLAG_NAME_TRADE_OK))
                    eco_ptr->flags |= ECO_FLAG_TRADE_OK;
                else if(!strcasecmp(strptr, ECO_FLAG_NAME_INTRODUCE_OK))
                    eco_ptr->flags |= ECO_FLAG_INTRODUCE_OK;
            }
            sprintf(val, "0x%.8lx", eco_ptr->flags);

	    NetSendEcoSetValues(condescriptor, object_num);
	}
	/* Economy: Tax general. */
        else if(!strcmp(prop, "eco.tax_general") ||
                !strcmp(prop, "eco/tax_general")
        )
        {
            /* Check if object's permission allows set. */
            if(!ALLOW_SET_MAC(condescriptor, con_obj_ptr->permission.uid))
                return(-1);

            if(DBCreateObjectEconomy(object_num))
                return(-1);
            else
                eco_ptr = obj_ptr->eco;


	    eco_ptr->tax_general = atof(val);
	    if(eco_ptr->tax_general < 1)
		eco_ptr->tax_general = 1;

            NetSendEcoSetValues(condescriptor, object_num);
        }
	/* Economy: Tax friend. */
        else if(!strcmp(prop, "eco.tax_friend") ||
                !strcmp(prop, "eco/tax_friend")
        )
        {
            /* Check if object's permission allows set. */
            if(!ALLOW_SET_MAC(condescriptor, con_obj_ptr->permission.uid))
                return(-1);

            if(DBCreateObjectEconomy(object_num))
                return(-1);
            else
                eco_ptr = obj_ptr->eco;


            eco_ptr->tax_friend = atof(val);
            if(eco_ptr->tax_friend < 1)
                eco_ptr->tax_friend = 1;

            NetSendEcoSetValues(condescriptor, object_num);
        }
	/* Economy: Tax hostile. */
        else if(!strcmp(prop, "eco.tax_hostile") ||
                !strcmp(prop, "eco/tax_hostile")
        )   
        {
            /* Check if object's permission allows set. */
            if(!ALLOW_SET_MAC(condescriptor, con_obj_ptr->permission.uid))
                return(-1);

            if(DBCreateObjectEconomy(object_num))
                return(-1);
            else
                eco_ptr = obj_ptr->eco;


            eco_ptr->tax_hostile = atof(val);
            if(eco_ptr->tax_hostile < 1)
                eco_ptr->tax_hostile = 1;

            NetSendEcoSetValues(condescriptor, object_num);
        }



	/* Unknown property. */
	else
	{
            sprintf(sndbuf,
		"set: Unsupported property: `%s'",
                prop
	    );
            NetSendLiveMessage(condescriptor, sndbuf);
	    return(-1);
	}



	/* ********************************************************** */
	/* Print response and log. */

        strncpy(
            tmp_name1, 
            DBGetFormalNameStr(
                connection[condescriptor]->object_num
            ),
            XSW_OBJ_NAME_MAX
        );
        tmp_name1[XSW_OBJ_NAME_MAX - 1] = '\0';
        
        strncpy(
            tmp_name2,
            DBGetFormalNameStr(object_num),
            XSW_OBJ_NAME_MAX
        );
        tmp_name2[XSW_OBJ_NAME_MAX - 1] = '\0';   
 

        sprintf(sndbuf,
	    "set: %s: Property `%s' to value `%s'.",
            tmp_name2,
            prop,
            val
        );
        NetSendLiveMessage(condescriptor, sndbuf);


        /* Log property setting. */
        sprintf(stringa, "%s: Set %s: Property: `%s'  Value: `%s'",
                tmp_name1,
		tmp_name2,
                prop,
                val
        );
	if(sysparm.log_general == 1)
            LogAppendLineFormatted(fname.primary_log, stringa);


	return(0);
}



int CmdSet(int condescriptor, char *arg)
{
	char stringa[CS_DATA_MAX_LEN];
	char sndbuf[CS_DATA_MAX_LEN];


	/* Copy arg to stringa. */
	strncpy(stringa, arg, CS_DATA_MAX_LEN);
	stringa[CS_DATA_MAX_LEN - 1] = '\0';
	StringStripSpaces(stringa);


        /* Print usage? */
        if((stringa[0] == '\0') ||
	   ((strchr(stringa, '=')) == NULL)
	)
	{
            sprintf(sndbuf,
		"set: Usage: `set <object>=<property>:<value>'"
	    );
            NetSendLiveMessage(condescriptor, sndbuf);
	    return(-1);
	}


	/* OPM set? */
	if(strchr(stringa, ':') == NULL)
	{
	    return(CmdOPMSet(condescriptor, stringa));
	}
	else
	{
	    return(CmdDoSet(condescriptor, stringa));
	}


	return(-1);
}
