#include "swserv.h"

 
/*
 *      Recycles a player object.
 */
int CmdRecyclePlayer(int condescriptor, char *arg)
{
        char name1[XSW_OBJ_NAME_MAX + 80];
        char name2[XSW_OBJ_NAME_MAX + 80];
        
        long object_num;
        long con_object_num;
        
        char sndbuf[CS_DATA_MAX_LEN];
        char stringa[CS_DATA_MAX_LEN];


        /* Error checks. */
        if(arg == NULL)
            return(-1);

        /* Get con_object_num, assumed valid. */
        con_object_num = connection[condescriptor]->object_num;


        /* Copy arg to stringa. */
        strncpy(stringa, arg, CS_DATA_MAX_LEN);
        stringa[CS_DATA_MAX_LEN - 1] = '\0';   
        StringStripSpaces(stringa);


        /* Print usage? */
        if(strlen(stringa) < 1)
        {
            NetSendLiveMessage(condescriptor,
                "Usage: `recycleplayer <player>'"
            );

            return(-1);
        }


        /* Get object_num. */
        object_num = MatchObjectByName(stringa, XSW_OBJ_TYPE_PLAYER);
        if(DBIsObjectGarbage(object_num))
        {
            sprintf(sndbuf,
                "%s: No such player.",
                stringa
            );
            NetSendLiveMessage(condescriptor, sndbuf);

            return(-1);
        }

        /* Cannot recycle player #0 or yourself. */
        if(object_num == 0)
        {
            sprintf(sndbuf,
           "recycleplayer: Permission denied: Cannot recycle %s.",
                DBGetFormalNameStr(object_num)
            );
            NetSendLiveMessage(condescriptor, sndbuf);

            return(-1);
        }
        if(object_num == con_object_num)
        {
            sprintf(sndbuf,
         "recycleplayer: Permission denied: Cannot recycle yourself."
            );
            NetSendLiveMessage(condescriptor, sndbuf);

            return(-1);
        }


        /* Check permissions, allowed to recycle? */
        if(xsw_object[con_object_num]->permission.uid >
           ACCESS_UID_RECYCLEPLAYER
	)
        {
            sprintf(sndbuf,
         "recycleplayer: Requires access level %i: Permission denied.",
                ACCESS_UID_RECYCLEPLAYER
            );
            NetSendLiveMessage(condescriptor, sndbuf);

            return(-1);
        }


        /* ************************************************************* */

        /* Print and log. */
        sprintf(sndbuf,
            "%s: Placed into recycle backup buffer.",
            DBGetFormalNameStr(object_num)
        );
        NetSendLiveMessage(condescriptor, sndbuf);

        strncpy(
	    name1,
	    DBGetFormalNameStr(con_object_num),
	    XSW_OBJ_NAME_MAX + 80
	);
        name1[XSW_OBJ_NAME_MAX + 80 - 1] = '\0';
        strncpy(
	    name2,
	    DBGetFormalNameStr(object_num),
	    XSW_OBJ_NAME_MAX + 80
	);
        name2[XSW_OBJ_NAME_MAX + 80 - 1] = '\0';

        sprintf(
	    stringa,
            "%s: Recycled %s and placed into recycle backup buffer.",
            name1, name2
        );
        if(sysparm.log_general == 1)
            LogAppendLineFormatted(fname.primary_log, stringa);


        /* Recycle object. */
        DBSaveRecycledObject(object_num);
        DBRecycleObject(object_num);
        NetSendRecycleObject(-1, object_num);


        return(0);
}
