#include "swserv.h"
 
 
int CmdExamine(int condescriptor, char *arg)
{
	int i;
        char name1[256];
        char name2[256];
	char *strptr, *strptr2;        
        long con_obj_num;
        long object_num;
        xsw_object_struct *obj_ptr, *con_obj_ptr;
        connection_struct *con_ptr;
	int wep_num;

        char sndbuf[CS_DATA_MAX_LEN];


	/* Get connection pointer and object. */
        if(ConIsLoggedIn(condescriptor))
            con_ptr = connection[condescriptor];
        else
            return(-1);

	con_obj_num = con_ptr->object_num;
        if(DBIsObjectGarbage(con_obj_num))
            return(-1);
        else
            con_obj_ptr = xsw_object[con_obj_num];


        /* If no argument, print usage. */
        if((arg == NULL) ? 1 : (arg[0] == '\0'))
        {
            sprintf(sndbuf,
                "Usage: `examine <object>'"
            );
            NetSendLiveMessage(condescriptor, sndbuf);

            return(-1);
        }


        /* Check if allowed to examine? */
        if(con_obj_ptr->permission.uid > ACCESS_UID_EXAMINE)
        {
            sprintf(sndbuf,
                "examine: Requires access level %i: Permission denied.",
                ACCESS_UID_EXAMINE
            );
            NetSendLiveMessage(condescriptor, sndbuf);
            return(-1);
        }
        
        
        /* Search and get object_num. */
        if(!strcmp(arg, "me"))
            object_num = con_obj_num;
        else
            object_num = MatchObjectByName(arg, -1);

        if(DBIsObjectGarbage(object_num))
        {
            sprintf(sndbuf,
                "%s: No such object.",
                arg
            );
            NetSendLiveMessage(condescriptor, sndbuf);
            
            return(-1);
        }
        else
        {
            obj_ptr = xsw_object[object_num];
        }

        /* Check if allowed to examine other? */
        if((obj_ptr->owner != con_obj_num) &&
           (con_obj_ptr->permission.uid > ACCESS_UID_EXAMINEO)
        )
        {
            if(DBIsObjectGarbage(obj_ptr->owner))
            {
                NetSendLiveMessage(condescriptor,
                    "examine: *No owner*"
                );

                return(-1);
            }
            else
            {
                sprintf(sndbuf,
                    "examine: Owner: %s",
                    xsw_object[obj_ptr->owner]->name
                );
                NetSendLiveMessage(condescriptor, sndbuf);

                return(-1);
            }
        }
        /* *********************************************** */
        /* Print information. */


        /* Line 1: Name, type, uid, and credits. */
        strncpy(name1, DBGetFormalNameStr(object_num), 256);
        name1[255] = '\0';
        strncpy(name2, DBGetFormalNameStr(obj_ptr->owner), 256);
        name2[255] = '\0';
                
        sprintf(sndbuf,
 "%s  Owner: %s  Type: %s  UID: %i  Credits: %0.2lf",
            name1,
            name2,
            DBGetTypeName(obj_ptr->type),
            obj_ptr->permission.uid,
            ((obj_ptr->score == NULL) ? 0 :
                obj_ptr->score->credits)
        );
        NetSendLiveMessage(condescriptor, sndbuf);

	/* Line 1.5: (optional for AI/Controlled). */
	if(obj_ptr->type == XSW_OBJ_TYPE_CONTROLLED)
	{
	    sprintf(sndbuf,
 "AI Controlled Flags: %s %s %s %s %s %s",
		((obj_ptr->ai_flags & XSW_OBJ_AI_FOLLOW_FRIEND) ?
		    XSW_OBJ_AI_NAME_FOLLOW_FRIEND : ""
		),
                ((obj_ptr->ai_flags & XSW_OBJ_AI_FOLLOW_UNKNOWN) ?
                    XSW_OBJ_AI_NAME_FOLLOW_UNKNOWN : ""
                ),
                ((obj_ptr->ai_flags & XSW_OBJ_AI_FOLLOW_HOSTILE) ?
                    XSW_OBJ_AI_NAME_FOLLOW_HOSTILE : ""
                ),
                ((obj_ptr->ai_flags & XSW_OBJ_AI_FIRE_FRIEND) ?
                    XSW_OBJ_AI_NAME_FIRE_FRIEND : ""
                ),
                ((obj_ptr->ai_flags & XSW_OBJ_AI_FIRE_UNKNOWN) ?
                    XSW_OBJ_AI_NAME_FIRE_UNKNOWN : ""
                ),
                ((obj_ptr->ai_flags & XSW_OBJ_AI_FIRE_HOSTILE) ?
                    XSW_OBJ_AI_NAME_FIRE_HOSTILE : ""
                )
	    );
	    NetSendLiveMessage(condescriptor, sndbuf);
	}

        /* Line 2: Sector, position, location type, and size. */
	switch(obj_ptr->loc_type)
	{
	  case XSW_LOC_TYPE_NEBULA:
	    strptr = XSW_LOC_TYPE_NAME_NEBULA;
	    break;

	  case XSW_LOC_TYPE_NOTIFY:
	    strptr = XSW_LOC_TYPE_NAME_NOTIFY;
	    break;

	  default:
	    strptr = XSW_LOC_TYPE_NAME_SPACE;
	    break;
	}

        sprintf(sndbuf,
  "Sector: %ld %ld %ld  Position: %.4lf %.4lf %.4lf  Location Type: %s\
  Size: %ld su",

            obj_ptr->sect_x,
            obj_ptr->sect_y,
            obj_ptr->sect_z,

            obj_ptr->x,
            obj_ptr->y,
            obj_ptr->z,

	    strptr,
            obj_ptr->size
        );
        NetSendLiveMessage(condescriptor, sndbuf);

        /* Line 3: Attitude, velocity vector. */
        sprintf(sndbuf,
 "Attitude: %.2lf' %.2lf' %.2lf'  Velocity vector: %.2lf' %.2lf' %.2lf'\
  Turn Rate: %.4lf",

            RADTODEG(obj_ptr->heading),
            RADTODEG(obj_ptr->pitch),
            RADTODEG(obj_ptr->bank),

            RADTODEG(obj_ptr->velocity_heading),
            (double)0,
            (double)0,

	    obj_ptr->turnrate
        );
        NetSendLiveMessage(condescriptor, sndbuf);

        /* Line 4: Velocity, thrust power, throttle, engine state. */
        sprintf(sndbuf,
 "Velocity: %.4lf(%.4lf)  Thrust power: %.4lf  Throttle: %.0lf%%\
  Engine state: %i",
            obj_ptr->velocity,
            obj_ptr->velocity_max,
            obj_ptr->thrust_power,
            obj_ptr->throttle * 100,
	    obj_ptr->engine_state
        );
        NetSendLiveMessage(condescriptor, sndbuf);

	/* Line 5: Isref, scanner range, and turn rate. */
        strncpy(name1, DBGetFormalNameStr(obj_ptr->locked_on), 256);
        name1[255] = '\0';
        strncpy(name2, DBGetFormalNameStr(obj_ptr->intercepting_object), 256);
        name2[255] = '\0';

        sprintf(sndbuf,
 "Imageset: %i  Scanner Range: %.2lf ru  Locked on: %s  Intercept: %s",
            obj_ptr->imageset,
            obj_ptr->scanner_range,
	    name1,
	    name2
        );
        NetSendLiveMessage(condescriptor, sndbuf);
                
        /* Line 6: Hull, power, purity, core efficiency. */
        sprintf(sndbuf,
 "Hull: %.2lf(%.2lf)  Power: %.2lf(%.2lf)  Purity: %.3lf%%\
  Core efficency: %.4lf",
            obj_ptr->hp,
            obj_ptr->hp_max,

            obj_ptr->power,
            obj_ptr->power_max,

	    obj_ptr->power_purity * 100,
            obj_ptr->core_efficency
        );
        NetSendLiveMessage(condescriptor, sndbuf);
            
        /* Line 7: Antimatter, shields, cloak and visibility. */
	switch(obj_ptr->shield_state)
	{
	  case SHIELD_STATE_UP:
	    strptr = "Up";
	    break;

          case SHIELD_STATE_DOWN:
            strptr = "Down";
            break;

          default:
            strptr = "None";
            break;
	}
        switch(obj_ptr->cloak_state)
        {
          case CLOAK_STATE_UP:
            strptr2 = "Up";
            break;

          case CLOAK_STATE_DOWN:
            strptr2 = "Down";
            break;

          default:
            strptr2 = "None";
            break;
        }
        sprintf(sndbuf,
 "AM: %.2lf(%.2lf)  Shields: %s  Cloak: %s  Cloak Strength: %.0lf%%\
  Vis: %.0lf%%",
            obj_ptr->antimatter,
            obj_ptr->antimatter_max,
	    strptr,
	    strptr2,
            obj_ptr->cloak_strength * 100,
            obj_ptr->visibility * 100
        );
        NetSendLiveMessage(condescriptor, sndbuf);
            
        /* Print weapons. */
        if(obj_ptr->weapons != NULL)
        {
            for(wep_num = 0; wep_num < obj_ptr->total_weapons; wep_num++)
            {
                if(obj_ptr->weapons[wep_num] == NULL)
                    continue;
        
                sprintf(sndbuf,
 "Weapon %i:  OCS: %i  Emission: %i  Amount: %ld(%ld)  Power: %.2lf\
  Range: %.2lf  CreatePower: %.2lf  Delay: %ld ms",
                    wep_num,
                    obj_ptr->weapons[wep_num]->ocs_code,
                    obj_ptr->weapons[wep_num]->emission_type,
                    obj_ptr->weapons[wep_num]->amount,
                    obj_ptr->weapons[wep_num]->max,
                    obj_ptr->weapons[wep_num]->power,
                    (double)obj_ptr->weapons[wep_num]->range / 1000,
                    obj_ptr->weapons[wep_num]->create_power,
		    obj_ptr->weapons[wep_num]->delay
                );
                NetSendLiveMessage(condescriptor, sndbuf);
            }
        }
 
        /* Scores. */
        if(obj_ptr->score != NULL)  
        {
            sprintf(sndbuf,
 "Credits: %.2lf  RMU: %.2lf(%.2lf)  DmgGiv: %.2lf  DmgRec: %.2lf  Kills: %ld",
                obj_ptr->score->credits,
                obj_ptr->score->rmu,
                obj_ptr->score->rmu_max,
                obj_ptr->score->damage_given,
                obj_ptr->score->damage_recieved,
                obj_ptr->score->kills
            );
            NetSendLiveMessage(condescriptor, sndbuf);
        }

        /* Economy. */
        if(obj_ptr->eco != NULL)
        {
            sprintf(sndbuf,
 "Economy flags: %s %s %s %s %s",
		(obj_ptr->eco->flags & ECO_FLAG_OPEN) ?
		    ECO_FLAG_NAME_OPEN : "",
                (obj_ptr->eco->flags & ECO_FLAG_BUY_OK) ?
		    ECO_FLAG_NAME_BUY_OK : "",
                (obj_ptr->eco->flags & ECO_FLAG_SELL_OK) ?
                    ECO_FLAG_NAME_SELL_OK : "",
                (obj_ptr->eco->flags & ECO_FLAG_TRADE_OK) ?
                    ECO_FLAG_NAME_TRADE_OK : "",
                (obj_ptr->eco->flags & ECO_FLAG_INTRODUCE_OK) ?
		    ECO_FLAG_NAME_INTRODUCE_OK : ""
            );
            NetSendLiveMessage(condescriptor, sndbuf);

            sprintf(sndbuf,
 "Economy: General Tax: %.2lf%%  Friendly Tax: %.2lf%%  Hostile Tax: %.2lf%%",
                obj_ptr->eco->tax_general - 1,
                obj_ptr->eco->tax_friend - 1,
                obj_ptr->eco->tax_hostile - 1
            );
            NetSendLiveMessage(condescriptor, sndbuf);

	    for(i = 0; i < obj_ptr->eco->total_products; i++)
	    {
		if(obj_ptr->eco->product[i] == NULL)
		    continue;

                sprintf(sndbuf,
 "Economy product `%s':  Buy Price: %.2lf  Sell Price: %.2lf  Amount: %.2lf(%.2lf)",
                    obj_ptr->eco->product[i]->name,
                    obj_ptr->eco->product[i]->buy_price,
                    obj_ptr->eco->product[i]->sell_price,
                    obj_ptr->eco->product[i]->amount,
                    obj_ptr->eco->product[i]->amount_max
                );
                NetSendLiveMessage(condescriptor, sndbuf);
	    }
        }


        return(0);
}
