#include <pwd.h>

#define _MAIN
#include "xev.h"

PRIVATE int start_stage , use_dcmap , bonus;
PRIVATE int muteki , nokori_no = 1 , nokori_init[3] = {2,4,6};

struct _top10 {
      char name[64];
      int score;
} top10[5][10];

void FreePixmap()
{
      ZosyFree();
      BacuFree();
      BackFree();
      EnemyFree();
      EnemyMissileFree();
      BombFree();
      RogramFree();
      ZakartFree();
      SolFree();
      TalkenFree();
      KapiFree();
      TerajiFree();
      GrobdFree();
      SPFlagFree();
      AndoFree();
      GidoFree();
      GZakartFree();
      GBZakartFree();
      DomogramFree();
      DelotaFree();
      JaraFree();
      SioFree();
      AuthorFree();
      BragFree();
}

void Title(flag)
     int flag;
{
      char *fn[] = {
	    "aaaK1.img",
	    "aaaK2.img",
	    "heart.img",
	    "zeK.img",
            "biK.img",
	    "zeK.img",
	    "biK.img"
      };
      char img[CSIZE*CSIZE];
      int i,j,x,y;
      char *meg[5] = {
	    "          easy",
	    "        normal",
	    "     difficult",
	    "more difficult",
	    "      abnormal"
      };
      
      XSetForeground(d,font_gc,pixel[0]);
      XFillRectangle(d,w,font_gc,XSIZE,0,256,128);
      
      for(i = 0; i < 7 ; i++) {
	    sprintf(tpath , "%s/%s",IMAGE_DIR,fn[i]);
	    LoadChar(tpath,img , sizeof(img));
	    for(y = 0 ; y < CSIZE ; y++) {
		  for(x = 0 ; x < CSIZE ; x++) {
			if(img[y*CSIZE+x] != 100) {
			      XSetForeground(d,font_gc,pixel[img[y*CSIZE+x]]);
			      XDrawPoint(d,w,font_gc,20+XSIZE+x+i*33,20+y);
			}
		  }
	    }
      }
      
      XSetForeground(d,font_gc,pixel[0]);
      XFillRectangle(d,w,font_gc,XSIZE+10,280,246,270);

      XSetForeground(d,font_gc,pixel[16]);

      if(flag)
	XDrawString(d,w,font_gc,XSIZE+16,500,"'s':pause",9);
      else
	XDrawString(d,w,font_gc,XSIZE+16,500,"'s':start",9);

      XDrawString(d,w,font_gc,XSIZE+16,516,"'q':quit",8);
      if(!flag)
	XDrawString(d,w,font_gc,XSIZE+16,532,"'c':set up",10);

      XDrawString(d,w,font_gc,XSIZE+16,548,"game level",10);
      XSetForeground(d,font_gc,pixel[20]);
      XDrawString(d,w,font_gc,XSIZE+110,548,meg[game_level],14);
      XDrawString(d,w,font_gc,XSIZE+110,300,meg[game_level],14);

      
      XSetForeground(d,font_gc,pixel[16]);
      XDrawString(d,w,font_gc,XSIZE+10,300,"scores",6);
      
      
      for(i = 0 ; i < 10 ; i++) {
	    XDrawString(d,w,font_gc,XSIZE+30,316+i*16,
			top10[game_level][i].name,strlen(top10[game_level][i].name));
	    sprintf(tpath,"%d",top10[game_level][i].score);
	    XDrawString(d,w,font_gc,XSIZE+180,316+i*16,
			tpath,strlen(tpath));
	    
      }
      
      Redraw();
      XFlush(d);
      
}

void Score(nokori)
     int nokori;
{
      char str[128];

      XSetForeground(d,font_gc,pixel[0]);
      XFillRectangle(d,w,font_gc,XSIZE+16,128,100,48);
      XSetForeground(d,font_gc,pixel[16]);
      sprintf(str,"score %06d",score);
      XDrawString(d,w,font_gc,XSIZE+16,144,str,strlen(str));
      sprintf(str,"ships %1d",nokori);
      XDrawString(d,w,font_gc,XSIZE+16,176,str,strlen(str));
      XFlush(d);
}

void SetChar()
{
      JikiSetChar();
      ToloidoSetChar();
      TalkenSetChar();
      ZakartSetChar();
      ZosySetChar();
      BacuSetChar();
      BombSetChar();
      EnemyMissileSet();
      RogramSetChar();
      SetChiChar();
      SolSetChar();
      KapiSetChar();
      TerajiSetChar();
      GrobdSetChar();
      SPFlagSetChar();
      AndoSetChar();
      GidoSetChar();
      GZakartSetChar();
      GBZakartSetChar();
      DomogramSetChar();
      DelotaSetChar();
      JaraSetChar();
      SioSetChar();
      AuthorSetChar();
      BragSetChar();
}

void ReadScore()
{
      FILE *fp;
      int i , g_level;
      
      for(g_level = 0 ; g_level < 5 ; g_level++) {
	    sprintf(tpath , "%s/top10-%d.txt",SCORE_DIR,g_level);
	    
	    if((fp = fopen(tpath,"r")) != NULL) {
		  for(i = 0 ; i < 10 ; i++) {
			fscanf(fp,"%s %d",top10[g_level][i].name,&top10[g_level][i].score);
		  }
		  
		  fclose(fp);
	    }
      }
}

void HiScore(name , score)
     char *name;
     int score;
{
      FILE *fp;
      int i,juni = 10;

      for(i = 9 ; i >= 0 ; i--) 
	if(score  > top10[game_level][i].score) {
	      juni = i;
	}	      
      
      if(juni < 10) {
	    
	    for(i = 9 ; i > juni ; i--) {
		  strcpy(top10[game_level][i].name , top10[game_level][i-1].name);
		  top10[game_level][i].score = top10[game_level][i-1].score;
	    }
	    strcpy(top10[game_level][juni].name,name);
	
	    top10[game_level][juni].score = score;
	    sprintf(tpath , "%s/top10-%d.txt",SCORE_DIR,game_level);
	    
	    if((fp = fopen(tpath,"w")) != NULL) {
		  for(i = 0 ; i < 10 ; i++) {
			fprintf(fp,"%s %d\n",top10[game_level][i].name,top10[game_level][i].score);
		  }
		  
		  fclose(fp);
	    }
      }
}

void Usage()
{
      fprintf(stderr,"Usage : xbat [options]\n options\n");
      fprintf(stderr,"\t-hs           : high speed mode\n\t-dc           : use default colormap\n");
      fprintf(stderr,"\t-g            : rapid fire\n\t-r            : exchange keys[z][x]\n");
      fprintf(stderr,"\t-h -help      : print usage\n");
      fprintf(stderr,"\t-mode [0-4]   : set game level\n");
      fprintf(stderr,"\t       0:easy, 1:normal, 2:difficult, 3:more difficult, 4:abnoraml\n");
      fprintf(stderr,"\t-wait [0-10]  : set wait(default 2)\n");
      exit(0);
}

void Explosion(nokori)
     int nokori;
{
      int i;
      
      for(i = 45 ; i > 0 ; i--) {
	    Chijou();
	    EMissile();
	    Enemy();
	    JikiBomb(i%6);
	    Score(nokori);
	    Scroll(0);
	    u_sleep(wait_tbl[wait_val]);
      }
}

void CheckOpt(argc,argv)
     int argc;
     char *argv[];
{
      char opt_str[8][10] = {
	    "-hs",
	    "-r",
	    "-g",
	    "-dc",
	    "-h",
	    "-help",
	    "-mode",
	    "-wait"
      };
      int i , argn;
      
      for(argn = 1 ; argn < argc ; argn++) {
	    for(i = 0 ; i < 8 ; i++)
	      if(strcmp(argv[argn] , opt_str[i]) == 0)
		break;
	    
	    switch(i) {
		case 0 :
		  DRAWSTEP = 2;
		  break;
		case 1:
		  rev_key = 1;
		  break;
		case 2:
		  rensha = 3;
		  break;
		case 3:
		  use_dcmap = 1;
		  break;
		case 4:
		case 5:
		  Usage();
		  break;
		case 6:
		  if((game_level = atoi(argv[argn+1])) < 0 
		     || game_level > 4)
		    Usage();
		  else
		    argn++;
		  
		  break;
		  
		case 7:
		  wait_val = atoi(argv[argn+1]);
		  if(wait_val > 10 )
		    Usage();
                  else
                    argn++;

		  break;
		default:
		  Usage();
		  
		  break;
	    }
      }
}

void Init(argc,argv)
     int argc;
     char *argv[];
{
      int i;

      DRAWSTEP = 1;
      rensha = 15;
      rev_key = 0;
      use_dcmap = 0;
      start_stage = 1;
      game_level = 0;

      CheckOpt(argc,argv);

      InitWin(use_dcmap);
      SetChar();
      InputImage();
      FuncInit();
      for(i = 0 ; i<11 ;i++) {
	    wait_tbl[i] = i*5000;
      }      
}

void Init2(ln)
     char *ln;
{
      andoa_flag = 0;
      level = 0;
      ReadScore();
      HiScore(ln , score);
      score = 0;
}

void Start(stage)
     int stage;
{
      char_set_no = 0;

      StartScroll();
      InitEnemyMissile();
      InitChijouEnemy(stage);
      InitKuuchuuEnemy(stage);
      MakeMap(stage);
      scrl_ptr = 201;	    
      InitEnemy();
}

void Demo()
{
      int i = 1;

      while(i){
	    switch (CheckEvent()){
		case (1<<Exp):
		  Title(0);
		  break;
		case (1<<Ks):
		  i = 0;
		  break;
		case (1<<Kq):
		  FreePixmap();
		  exit(0);
		  break;
		case (1<<Kc):
		  nokori_no = Config(&muteki , &start_stage,
				     rensha);
		  break;
	    }
	    
	    if(scrl_ptr == 0) {
		  scrl_ptr = 201;
		  domo_no = 0;
	    }
	    
	    Chijou();
	    Enemy();
	    EMissile();
	    Jiki(1);
	    Title2();
	    Scroll(1);
      }
}

void Play()
{
      int stage,i,quit_flag;
      unsigned int state;

      for(stage = start_stage ; stage < 17 ; stage++) {
	    int yarare_flag = 0;
	    
	    Start(stage);
	    while(1) {
		  InitEnemyMissile();
		  char_set_no = 0;
		  state = 0;
		  domo_no = 0;
		  
		  while(1) {
			int p_score;
			p_score = score;
			
			Chijou();
			yarare_flag |= Enemy();
			yarare_flag |= EMissile();
			
			if(muteki)
			  yarare_flag = 0;
			
			quit_flag = Jiki(0);
			Scroll(0);
			
			if(p_score != score) {
			      if(p_score < (20000+60000*bonus) && 
				 score >= (20000+60000*bonus)) {
				    nokori++;
				    bonus++;
			      }
			      
			      Score(nokori);
			}
			
			if(yarare_flag) {
			      state = YARARETA;
			      break;
			}
			
			if(scrl_ptr == 0)	{
				    state = CLEAR_AREA;
				    break;
			      }
			
			if(quit_flag){
			      state = QUIT;
			      break;
			}
			u_sleep(wait_tbl[wait_val]);
		  }/*while(1) playing */
		  
		  switch(state) {
		      case YARARETA:
			nokori--;
			
			if(nokori >= 0) {
			      Explosion(nokori);
			      
			      jx.dummy = XSIZE/2*65536;
			      jy.dummy = (YSIZE-52)*65536;
			      yarare_flag = 0;
			      InitEnemy();
			      
			      if(scrl_ptr>66) { /* less than 70% */
				    StartScroll();
				    scrl_ptr = 201;
				    Redraw();
			      } else {
				    state = CLEAR_AREA;
				    if(stage == 16) {
					  stage = 6;
					  start_stage = 7;
					  level ++;
					  if(level == 3) {
						level = 0;
						game_level += (game_level < 4);
					  }
				    }
				    goto clear_label;
			      }
			      
			} else { /*game over*/
			      Explosion(nokori+1);
			      for(i = 100 ; i > 0 ; i--) {
				    Chijou();
				    EMissile();
					  Enemy();
				    Score(nokori+1);
				    Scroll(0);
				    GameOver();
				    u_sleep(wait_tbl[wait_val]);
			      }
				    
			      return;
			}
			break;
			
		      case QUIT:
			return;
			break;
			
		      case CLEAR_AREA:
			goto clear_label;
			break;
		  }
		  
	    }/*nokori*/
	    
	  clear_label:
	    if(stage == 16) {
		  stage = 6;
		  start_stage = 7;
		  level ++;
		  if(level == 3) {
			level = 0;
			game_level += (game_level < 4);
		  }
	    }
	    
      }/*for(stage)...*/
      
}

main(argc,argv)
     int argc;
     char *argv[];
{
      int sy,i,id;
      int stage , quit_flag;
      unsigned char state;
      char login_name[64];
      struct passwd *pw = getpwuid(getuid());
      
      wait_val = 2;

      if (pw == NULL)
	sprintf(login_name, "%d", getuid());
      else
	strcpy(login_name, pw->pw_name);
      
      Init(argc,argv);

      while(1) {
	    Init2(login_name);
	    stage = rand() % 6 + 1;
	    Title(0);

	    Start(stage);

	    i = 1;
	    KEClear();
	    InitJiki();
	    
	    Demo();
	    nokori = nokori_init[nokori_no];

	    Title(1);
	    Score(nokori);
	    XFlush(d);
	    scrl_cntr1 = CSIZE;
	    InitJiki();
	    InitEnemy();	    
	    
	    bonus = 0;
	    score = 0;
	    Score(nokori);
	    
	    Play();
	    
      }/*while(1)*/
}
          




