## vim:ts=4:et:nowrap
##
##---------------------------------------------------------------------------##
##
## PySol -- a Python Solitaire game
##
## Copyright (C) 1999 Markus Franz Xaver Johannes Oberhumer
## Copyright (C) 1998 Markus Franz Xaver Johannes Oberhumer
##
## This program is free software; you can redistribute it and/or modify
## it under the terms of the GNU General Public License as published by
## the Free Software Foundation; either version 2 of the License, or
## (at your option) any later version.
##
## This program is distributed in the hope that it will be useful,
## but WITHOUT ANY WARRANTY; without even the implied warranty of
## MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
## GNU General Public License for more details.
##
## You should have received a copy of the GNU General Public License
## along with this program; see the file COPYING.
## If not, write to the Free Software Foundation, Inc.,
## 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
##
## Markus F.X.J. Oberhumer
## <markus.oberhumer@jk.uni-linz.ac.at>
## http://wildsau.idv.uni-linz.ac.at/mfx/pysol.html
##
##---------------------------------------------------------------------------##


# imports
import os, sys, time, types
import Tkinter
from Tkinter import TclError

# PySol imports
from mfxutil import destruct, Struct                                #bundle#
from util import Images                                             #bundle#


# /***********************************************************************
# // menubar
# ************************************************************************/

class MfxCheckMenuItem(Tkinter.BooleanVar):
    def __init__(self, menubar, path=None):
        Tkinter.BooleanVar.__init__(self)
    def set(self, value):
        if not value or value == "false": value = 0
        ##print value, type(value)
        assert type(value) == types.IntType and 0 <= value <= 1
        Tkinter.BooleanVar.set(self, value)


class MfxRadioMenuItem(Tkinter.IntVar):
    def __init__(self, menubar, path=None):
        Tkinter.IntVar.__init__(self)
    def set(self, value):
        assert type(value) == types.IntType and 0 <= value
        Tkinter.IntVar.set(self, value)


# /***********************************************************************
# // Wrapper class for Tk.
# // Required so that a Game will get properly destroyed.
# ************************************************************************/

class MfxRoot(Tkinter.Tk):
    def __init__(self, **kw):
        apply(Tkinter.Tk.__init__, (self,), kw)
        self.app = None

    def connectApp(self, app):
        self.app = app

    # sometimes an update() is needed under Windows, whereas
    # under Unix an update_idletask() would be enough...
    def busyUpdate(self):
        game = None
        if self.app: game = self.app.game
        if not game:
            self.update()
        else:
            old_busy = game.busy
            game.busy = 1
            self.update()
            game.busy = old_busy

    def mainquit(self):
        self.after_idle(self.quit)

    def setCursor(self, cursor):
        if 0:
            ## FIXME: this causes ugly resizes !
            Tkinter.Tk.config(self, cursor=cursor)
        elif 0:
            ## and this is even worse
            ##print self.children
            for v in self.children.values():
                v.config(cursor=cursor)
        else:
            pass

    # FIXME - make sleep interruptible
    def sleep(self, seconds):
        time.sleep(seconds)

    def update(self):
        if 0: traceback.print_stack()                               #bundle#
        Tkinter.Tk.update(self)

    def wmDeleteWindow(self):
        if self.app and self.app.menubar:
            self.app.menubar.mQuit()
        else:
            ##self.after_idle(self.quit)
            pass


# /***********************************************************************
# //
# ************************************************************************/

class MfxImages(Images):
    def loadImage(self, file):
        return Tkinter.PhotoImage(file=file)


