## vim:ts=4:et:nowrap
##
##---------------------------------------------------------------------------##
##
## PySol -- a Python Solitaire game
##
## Copyright (C) 1999 Markus Franz Xaver Johannes Oberhumer
## Copyright (C) 1998 Markus Franz Xaver Johannes Oberhumer
##
## This program is free software; you can redistribute it and/or modify
## it under the terms of the GNU General Public License as published by
## the Free Software Foundation; either version 2 of the License, or
## (at your option) any later version.
##
## This program is distributed in the hope that it will be useful,
## but WITHOUT ANY WARRANTY; without even the implied warranty of
## MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
## GNU General Public License for more details.
##
## You should have received a copy of the GNU General Public License
## along with this program; see the file COPYING.
## If not, write to the Free Software Foundation, Inc.,
## 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
##
## Markus F.X.J. Oberhumer
## <markus.oberhumer@jk.uni-linz.ac.at>
## http://wildsau.idv.uni-linz.ac.at/mfx/pysol.html
##
##---------------------------------------------------------------------------##


# imports
import sys

# PySol imports
if sys.modules.has_key("pysoltk"):                                  #bundle#
    from gamedb import registerGame, GameInfo, GI                   #bundle#
    from util import *                                              #bundle#
    from stack import *                                             #bundle#
    from game import Game                                           #bundle#
    from layout import Layout                                       #bundle#
    from hint import AbstractHint, DefaultHint, CautiousDefaultHint #bundle#


# /***********************************************************************
# //
# ************************************************************************/

class AcesUp_Foundation(AbstractFoundationStack):
    def acceptsPile(self, from_stack, cards):
        if not AbstractFoundationStack.acceptsPile(self, from_stack, cards):
            return 0
        n, c0 = 0, cards[0]
        for s in self.game.s.rows:
            if s is not from_stack and s.cards and s.cards[-1].suit == c0.suit:
                n = n + 1
                if s.cards[-1].rank < c0.rank and s.cards[-1].rank != ACE:
                    return 0
        return n > 0 and c0.rank != ACE


class AcesUp_RowStack(BasicRowStack):
    def acceptsPile(self, from_stack, cards):
        if not BasicRowStack.acceptsPile(self, from_stack, cards):
            return 0
        return len(self.cards) == 0

    def clickHandler(self, event):
        return self.doubleclickHandler(event)


# /***********************************************************************
# // Aces Up
# ************************************************************************/

class AcesUp(Game):
    def createGame(self, **layout):
        # create layout
        l, s = Layout(self), self.s

        # set window
        self.setSize(l.XM + 7*l.XS, l.YM + 4*l.YS)

        # create stacks
        x, y, = l.XM, l.YM
        s.talon = DealRowTalonStack(x, y, self, max_rounds=1)
        l.createText(s.talon, "ss")
        x = x + 3*l.XS/2
        for i in range(4):
            s.rows.append(AcesUp_RowStack(x, y, self, max_accept=1))
            x = x + l.XS
        x = l.XM + 6*l.XS
        stack = AcesUp_Foundation(x, y, self, ANY_SUIT, max_move=0,
                                  dir=0, base_rank=ANY_RANK, max_cards=48)
        l.createText(stack, "ss")
        s.foundations.append(stack)

        # define stack-groups
        l.defaultStackGroups()

    #
    # game overrides
    #

    def startGame(self):
        self.s.talon.dealRow()

    def isGameWon(self):
        if len(self.s.foundations[0].cards) != 48:
            return 0
        for s in self.s.rows:
            if len(s.cards) != 1 or s.cards[0].rank != ACE:
                return 0
        return 1

    def getAutoStacks(self, event=None):
        if event is None:
            # disable auto drop - this would ruin the whole gameplay
            return (self.sg.dropstacks, (), self.sg.dropstacks)
        else:
            # rightclickHandler
            return (self.sg.dropstacks, self.sg.dropstacks, self.sg.dropstacks)


# register the game
registerGame(GameInfo(52, AcesUp, "Aces Up",
                      GI.GT_1DECK_TYPE, 1, 0))

