/*
 *  Linux snipes, a text-based maze-oriented game for linux.
 *  Copyright (C) 1997 Jeremy Boulton.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 *  Jeremy Boulton is reachable via electronic mail at
 *  boultonj@ugcs.caltech.edu.
 */

#ifndef SNIPES_PLAYER

#define SNIPES_PLAYER

#include "snipes.h"
#include "coords.h"

void init_players( screen_coords *sc, int count, int a[], int wall_danger );
coordinate get_player_pos( int index );
int get_player_lives( int index );
void hide_player( int index, screen_coords *sc );
void show_player( int index, screen_coords *sc );
void show_players( screen_coords *sc );
void all_player_collision_check( screen_coords *sc );
void player_move( screen_coords *sc, int index, coordinate delta );
void player_fire( screen_coords *sc, int index, coordinate direction,
		  int elapsed_time );

void find_nearest_player( screen_coords *sc, coordinate pos, coordinate *player_delta );

void eyechange( void );

#endif // SNIPES_PLAYER
