/*
 *  Copyright (C) 1999 Peter Amstutz
 *
 *  This program is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU General Public License as
 *  published by the Free Software Foundation; either version 2 of *the
 *  License, or (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA
 *  02111-1307 USA 
 */

#ifndef _WEAPON_H_
#define _WEAPON_H_

struct Weapon_wep;

#include "../ballistics.h"

/* This weapon implementation is sort of an ad-hoc object-oriented system... */

typedef struct Weapon_wep
{
    char* name;
    
    Shellstat_bal (*initguidance)(struct Projectilepos_bal *prjpos, void** guideshotinfo,
								  Shellstat_bal (*initexplosion)(struct Projectilepos_bal *prjpos, 
																 void** explosioninfo), 
								  void** explosioninfo);
    Shellstat_bal(*doguidance)(void* info, struct Projectilepos_bal *prjpos, 
							   Shellstat_bal (*initexplosion)(struct Projectilepos_bal *prjpos, 
															  void** explosioninfo), 
							   void** explosioninfo);
    void (*drawshot)(struct Projectilepos_bal *prjpos, void* info); /* handles drawing/erasing of the shell */
    Shellstat_bal (*initexplosion)(struct Projectilepos_bal *prjpos, 
								   void** explosioninfo);
    Shellstat_bal (*doexplosion)(void* info);
    void (*drawexplosion)(void* info); /* handles drawing/erasing of the explosion */

    struct Weapon_wep *next;
    struct Weapon_wep *prev;

	int cost;
	int count;
} Weapon_wep;


struct SimpleExplosion_wep
{
	int id;
    int x, y, r;
    int dx;
    int max_radius;    
};

struct BurningNapalmExplosion_wep
{
 	int id;
	int x, y, width;
	int duration;   
};
 

extern Weapon_wep *wep_WeaponList;

void wepInit();
Weapon_wep *wepLookupWeapon(char *name);
void wepAddWeapon(char* name, int cost, int count,
				  Shellstat_bal (*initguidance)(struct Projectilepos_bal *prjpos, void** guideshotinfo,
												Shellstat_bal (*initexplosion)(struct Projectilepos_bal *prjpos, 
																			   void** explosioninfo), 
												void** explosioninfo),
				  Shellstat_bal (*doguidance)(void* info, struct Projectilepos_bal *prjpos, 
											  Shellstat_bal (*initexplosion)(struct Projectilepos_bal *prjpos, 
																			 void** explosioninfo), 
											  void **explosioninfo),
				  Shellstat_bal (*initexplosion)(struct Projectilepos_bal *prjpos,
												 void** explosioninfo),
				  Shellstat_bal (*doexplosion)(void* info));

#endif
