/*
 *  Copyright (C) 1999 Peter Amstutz
 *
 *  This program is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU General Public License as
 *  published by the Free Software Foundation; either version 2 of *the
 *  License, or (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA
 *  02111-1307 USA 
 */

#include "../ballistics.h"
#include "../terrain.h"
#include "simple.h"

Shellstat_bal wepSimpleExplosion(void* info)
{
    struct SimpleExplosion_wep *prj = (struct SimpleExplosion_wep *)info;
	Player_pl *pcur;
	
    prj->r+=prj->dx;
    if(prj->r > prj->max_radius)
    {
		return FREEING;
    }
    else /* amazing how much the word "else" looks like the face of Yoda at 4:16 in the morning */
    {
		terClearCircle(prj->x, prj->y, prj->r);
		for(pcur=pl_begin; pcur; pcur=pcur->next) 
		{
			if(pcur->ready==READY && plPlayerInCircleArea(pcur, prj->x, prj->y, prj->r))
			{
				plDamageTank(pcur, EXPLOSIVE, prj->id, 1);
			}
		}
		return EXPLODING;
    }    
}
