/* I'm changing this so that only the actual SEARCH routines are in here. 
 * widget creation has been moved to "searchwidgets.c"
 */

#include <stdio.h>

#include <Xos.h>
#include <Intrinsic.h>
#include <StringDefs.h>

#include <Shell.h>



#include "defs.h"
#include "externs.h"
#include "game.h"
#include "widgets.h"
#include "search.h"
#include "convert.h"
#include "multikanji.h"
#include "strokesearch.h"
#include "readfile.h"

#include "searchwidgets.h"


TRANSLATION lastsearch=NULL;	/* holds index of last kanji searched */

/* called from DoStrokeSearch()
 * Go look for all kanji with this strokecount.
 * 
 */
void dostrokefind(BYTE strokecount, BITS16 skipval)
{
	short skipmask=skipfromthree(3,0,0);
	TRANSLATION searchtarget = NULL;
	TRANSLATION firstmatch = NULL;

	if(strokecount==0)
		return;

	setstatus("Searching...");
	printf("searching for strokecount %d\n",strokecount);

	searchtarget=translations[lowestkanji];
	ClearAllMulti();
	while(searchtarget!=NULL){
		if(searchtarget->Strokecount != strokecount)
		{
			searchtarget = searchtarget->nextk;
			continue;
		}

		if(skipval!=0)
			if((searchtarget->Sindex & skipmask) != skipval)
			{
				searchtarget = searchtarget->nextk;
				continue;
			}

		AddTranslation(searchtarget);
		if(firstmatch==NULL)
			firstmatch=searchtarget;

		searchtarget = searchtarget->nextk;
	}

	if(firstmatch!=NULL){
		ShowMulti();
	} else{
		setstatus("No match found");
		Beep();
	}
	
}

/* doenglishfind:
 *	Assume what we want to look for is in the search ENGLISH INPUT widget.
 *	First, read in that value from the widget
 *	(okay, this is not modular :-)
 *
 *	Then go through the whole dictionary looking for matches,
 *	and adding any matches to the multi window.
 *	We show the multiwindow, if appropriate
 *	We return the first match, if any.
 *	But we do not set the main search window, for some reason.
 */
TRANSLATION doenglishfind()
{
	String str;
	TRANSLATION searchtarget = NULL;
	TRANSLATION firstmatch = NULL;

	setstatus("Searching...");

	XtVaGetValues(searchwidgets[SEARCH_ENG_W],XtNstring,&str,NULL);

	if((str[0] == '\0') || (str[0] == '\n')){
		return NULL;
	}

	searchtarget=translations[lowestkanji];
	ClearAllMulti();
	while(searchtarget!=NULL){
		if(strstr(searchtarget->english,str) != NULL){
			AddTranslation(searchtarget);
			if(firstmatch==NULL)
				firstmatch=searchtarget;
			
		}
		searchtarget = searchtarget->nextk;
	}

	if(firstmatch!=NULL){
		ShowMulti();
	} else{
		setstatus("No match found");
		Beep();
	}

	return firstmatch;
	
}

/* DoFind
 *   (do-find)accelerator hook
 *   This handles callbacks for multiple widgets.
 *
 *	Farms out english search to doenglishearch().
 *	Also handles <return> press for numerical input windows
 *	on the search popup. eg "F:",
 */
void 
DoFind(Widget w,XEvent *event,String *params,Cardinal *num_parags){
	TRANSLATION findtarget = NULL;

	setstatus("Searching...");

	if(w == searchwidgets[SEARCH_ENG_W]){
		findtarget = doenglishfind();

		if(findtarget == NULL){
			setstatus("No match found");
			Beep();
			printsearch(lastsearch);
		} else {
			printsearch(findtarget);
		}
		return;
		
	}

	if (w == searchnumbers[POUND_INPUT])
	{
		int number;
		/* want closest index match */
		number = GetWidgetNumberval(w);

		if((number <lowestkanji) || (number> highestkanji)){
			setstatus("input out of dict. range");
			Beep();
			printsearch(lastsearch);
			return;
		} 

		if(number > highestkanji){
			number = highestkanji;
		} else if (number <lowestkanji){
			number = lowestkanji;
		} else {
			/* find closest non-blank */
			while(translations[number] == NULL){
				number++;
				/* this should never be triggered, but... */
				if(number >highestkanji)
					number = lowestkanji;
			}
		}

		findtarget = translations[number];

		printsearch(findtarget);
	} else 	if (w == searchnumbers[F_INPUT])
	{
		/* want closest frequency match */
		/* "F:" input widget */
		int findfreq=-1;
		TRANSLATION cur_target = translations[lowestkanji];
		

		findfreq = GetWidgetNumberval(w);

		if(findfreq <1){
			setstatus("frequencies must be greater than 0");
			Beep();
			printsearch(lastsearch);
			return;			
		}

		cur_target = translations[lowestkanji];
		findtarget = cur_target;

		while(cur_target != NULL){
			if(cur_target->frequency == findfreq){
				findtarget = cur_target;
				break;
			}
			if((findfreq - (cur_target->frequency)) <
			   (findfreq - (findtarget->frequency)) ){
				findtarget = cur_target;
			}
			cur_target = cur_target->nextk;
			   
		}
		
		printsearch(findtarget);

	} else {
		/* find exact match for special index */
		char append='\0';
		char findstring[100];
		String str;

		
		if(w == searchnumbers[H_INPUT]){
			append = 'H';
		} else if(w == searchnumbers[N_INPUT]){
			append = 'N';
		} else if(w == searchnumbers[U_INPUT]){
			append = 'U';
		} else {
			puts("Where did that input come from??");
			return;
		}
		
		XtVaGetValues(w,XtNstring,&str,NULL);

		sprintf(findstring,"%c%.99s",append,str);

		/* FindIndex sets status appropriately on error */

		findtarget = translations[FindIndex(findstring)];
		printsearch(findtarget);
		
	}
	

}


/* if fragment matches FIRST chars of fullstring, return 1.
 * Otherwise, return  0
 *   Allow hiragana/kanakana folding.
 */
int matchkanafirst(XChar2b *fullstring, XChar2b *fragment)
{
	while(1)
	{
		if(fragment->byte1==0)
			return 1;

		/* no need to test for fullstring->byte1==0,
		 * it will just fail match :-)
		 * Although if we were nice, we could return a value
		 * saying the thing is too short
		 */

		/* theres almost no point to this. sigh.*/
		if(fullstring->byte1 != fragment->byte1)
		{
			if((fullstring->byte1 != 0x24) &&
			   (fullstring->byte1 != 0x25))
				return 0;
			if((fragment->byte1 != 0x24) &&
			   (fragment->byte1 != 0x25))
				return 0;
		}

		if(fullstring->byte2 != fragment->byte2)
			return 0;

		fragment++;
		fullstring++;
	}
}

/* match XChar2b
 *	Attempt to find occurence of fragment in xchar2b string
 *	return 1 on match, 0 on fail.
 *
 *	Note that we try to allow match of kanagana, by hiragana.
 *	If kana_onlyatstart!=0, only match if start of a kana phrase
 *	matches fragment
 */
int matchkana(XChar2b *fullstring, XChar2b *fragment)
{

	if(kana_onlyatstart)
	{
		while(fullstring->byte1 != 0)
		{
			if(matchkanafirst(fullstring,fragment))
				return 1;

			/* Oh well.... Find start of next "word".
			 * First skip over "current" word, then
			 * then look for valid kanji char.
			 * Remember, we need to skip space, AND things
			 * like parenthesis
			 */

			/* Look for space, explicitly */
			while(fullstring->byte1 != 0){
				if((fullstring->byte1==0x21) &&
				   (fullstring->byte2==0x21)){
					break;
				}
				fullstring++;
			}
			/* now have either space, or end-of-string */
			/* so look for begining of word */
			while(fullstring->byte1 < 0x24){
				if(fullstring->byte1 ==0)
					break;
				fullstring++;
			}
			
			if(fullstring->byte1 ==0){
				/* oh well, end of string hit */
				break;
			}

			/* We must be in the kana-and-above range now.
			 * just loop and search again!
			 */
		}

		return 0;
	}

	/* else */

	while(fullstring->byte1 != 0)
	{
		if(matchkanafirst(fullstring,fragment))
			return 1;
		fullstring++;

	}
	return 0;

}


/*
 *	Equivalent to matchkana!
 *	return 1 if match, 0 if no match
 *
 *	Note that this takes intoaccount 'kana_onlyatstart'
 *	Which will presumably only match the kanji if at beginning
 *	of the phrase. Hmmm.
 */
int matchkanji(XChar2b *fullstring, XChar2b *fragment)
{
	return matchkana(fullstring,fragment);
}


/* dokanafind()
 *	find match to XChar2b string in kana translations
 */

void dokanafind(XChar2b *target)
{
	TRANSLATION firstmatch = NULL;
	TRANSLATION searchtarget = NULL;

	setstatus("Searching...");

	searchtarget=translations[lowestkanji];
	ClearAllMulti();

	while(searchtarget != NULL){
		if(matchkana(searchtarget->pronunciation, target)){
			AddTranslation(searchtarget);
			if(firstmatch==NULL)
				firstmatch=searchtarget;
		}
		searchtarget = searchtarget->nextk;
	}

	if(firstmatch!=NULL){
		printsearch(firstmatch);
		ShowMulti();
	} else{
		setstatus("No match found");
		Beep();
	}

	return;
}

/* dokanjifind()
 *	find match to "Four Corner" encoding in kanjidic translations
 */

void dokanjifind(int target)
{
	TRANSLATION firstmatch = NULL;
	TRANSLATION searchtarget = NULL;

	setstatus("Searching...");

	searchtarget=translations[lowestkanji];
	ClearAllMulti();

	while(searchtarget != NULL){
		if(searchtarget->Qindex == target){
			AddTranslation(searchtarget);
			if(firstmatch==NULL)
				firstmatch=searchtarget;
		}

		searchtarget = searchtarget->nextk;

	}

	if(firstmatch!=NULL){
		printsearch(firstmatch);
		ShowMulti();
	} else{
		setstatus("No match found");
		Beep();
	}

	return;
}

/* doskipfind()
 *	find match to "SKIP" encoding in kanjidic translations
 *	Indentical to dokanjifind, except look at Qindex instead of Sindex
 */

void doskipfind(int target)
{
	TRANSLATION firstmatch = NULL;
	TRANSLATION searchtarget = NULL;

	setstatus("Searching...");

	searchtarget=translations[lowestkanji];
	ClearAllMulti();

	while(searchtarget != NULL){
		if(searchtarget->Sindex == target){
			AddTranslation(searchtarget);
			if(firstmatch==NULL)
				firstmatch=searchtarget;
		}

		searchtarget = searchtarget->nextk;

	}

	if(firstmatch!=NULL){
		printsearch(firstmatch);
		ShowMulti();
	} else{
		setstatus("No match found");
		Beep();
	}

	return;
}


/* process_kinput
 *	Accepts a single 2-byte char as input.
 *	We assume this is hiragana, katakana, or special-directive char.
 *
 *	Adjusts the SEARCH_KANA_W widget labelstring appropriately
 *	(allowing backspacing)
 *	Also handles the mirrored labelwidget on the popup window itself
 *
 *	We call the convert routine "romajitokana" on our internal
 *	string, to handle romaji-to-kana stuffs.
 *	Note that we get called by both the point-n-click-kana window,
 *	AND by the kepress-event handler for the window.
 */
void process_kinput(XChar2b in_char)
{
	XChar2b *kparse = kanastring;
	int kanalength;

	for(kanalength=0; kparse->byte1 != 0; kanalength++)
	{
		kparse++;
	}
	
	/* handle backspace */
	if((in_char.byte1 == 0x22) && (in_char.byte2 == 0x2b) )
	{
		if(kanalength==0)
			return;
		kanalength--;
		kanastring[kanalength].byte1 = 0;
		kanastring[kanalength].byte2 = 0;

		XtVaSetValues(searchwidgets[SEARCH_KANA_W],
		      XtNlabel, kanastring, NULL);
		XtVaSetValues(romajiinput,
		      XtNlabel, kanastring, NULL);

		return;
	
	}

	/* check for special "return" char */
	/* which means "go do search now" */
	if((in_char.byte1 == paragraphglyph[0].byte1) &&
	   (in_char.byte2 == paragraphglyph[0].byte2))
	{
		if(kanalength == 0)
			return;
		/* accept.. search! */
		dokanafind(kanastring);
		return;
	}

	/* otherwise.. add to end! */

	if(kanalength<MAXKANALENGTH-1)
	{
		kanastring[kanalength].byte1 = in_char.byte1;
		kanastring[kanalength].byte2 = in_char.byte2;

		kanalength++;
		kanastring[kanalength].byte1 = 0;
		kanastring[kanalength].byte1 = 0;
	}
	romajitokana(kanastring);

	XtVaSetValues(searchwidgets[SEARCH_KANA_W],
		      XtNlabel, kanastring, NULL);
	XtVaSetValues(romajiinput,
		      XtNlabel, kanastring, NULL);
	
}

/****************************************************************\
 * Quickie to find edict matches for a kanji string             *
 * Will also find assumed original match in kanjidic,		*
 *   if a single char, and exists there				*
 * If match found, will take care of calling ShowMulti()	*
\****************************************************************/
void findkanjiall(XChar2b *Schars)
{
	int init=0;

	TRANSLATION searchparse=translations[lowestkanji];

	while(searchparse!=NULL)
	{
		if(matchkanji(searchparse->kanji,Schars))
		{
			if(init==0)
			{
				ClearAllMulti();
				init=1;
				printsearch(searchparse);
			}
			AddTranslation(searchparse);
		}
		searchparse=searchparse->nextk;
	}

	if(init>0)
	{
		ShowMulti();
	} else {
		setstatus("no match found");
	}
	
}
