/* -*- mode: fundamental -*- */

%option prefix="tp"

%{

#include "trilby-parser-tp.h"

#include "trilby-parser.h"
#include <string.h>

%}

%option noyywrap

%%

[[:space:]] 	/* nothing */

[#;][^\n]*\n	/* nothing */

"paragraph" 	{ return S_PARAGRAPH; }

[[:digit:]]	{ tplval.integer = strtol(tptext, NULL, 0); return NUMBER; }

"left"		{ tplval.character = 'l'; return ALIGN; }
"right" 	{ tplval.character = 'r'; return ALIGN; }
"center" |
"centre"	{ tplval.character = 'c'; return ALIGN; }

\|[^\|]*\|	{ 
		 tplval.string = strndup(tptext+1, strlen(tptext)-2); 
		 return STRING; 
		}

.		{ return tptext[0]; }

%%
 
void viewparserNewFile(FILE* fp)
{
  yyrestart(fp);
  BEGIN(INITIAL);
}

static void nothing()
{
 (void)yyunput;
 (void)nothing;
}
