/*C*
 *
 * Hatman - The Game of Kings
 * Copyright (C) 1997 James Pharaoh & Timothy Fisken
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *
 *C*/

#include "Data.h"
#include "files.h"
#include "../gl/Aset.h"
#include "../gl/Animation.h"
#include "../gl/Sprite.h"
#include "../gl/Sset.h"
#include "../util/debug.h"
#include "../util/error.h"
#include "../util/File.h"
#include <errno.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

//-----------------------------------------------------------------------------
/*
 * The data declerations
 */
Aset* asetHatman = NULL;
Aset* asetGhost = NULL;
Animation* animPlayer = NULL;
Animation* animHat = NULL;
bool spritesLoaded = false;
Sset* ssetBlocks = NULL;
Sprite* sprExtra = NULL;

//-----------------------------------------------------------------------------
template <class T> bool loadGeneric(T*& object, const char* name)
{
 if(object) delete object;
 object = new T;
 if(!object->load(libFileName(name)))
  {
   delete object;
   object = NULL;
   return false;
  }
 return true;
}

//-----------------------------------------------------------------------------
bool loadSpriteSets()
{
 return true;
}

//-----------------------------------------------------------------------------
bool autoLoad(Object** obj, const char* _fname, objectCreateFunc create)
{
 String fname = libFileName(_fname);
 printf(" %s\n", (const char*) fname);
 File* f = gzFilename(fname)? new GzipPipe(fname, "r") : new File(fname, "r");
 if(!*f) return false;
 *obj = create(*f);
 if(!*obj) return false;
 f->close();
 return true;
}

//-----------------------------------------------------------------------------
bool loadData()
{
 printf("Loading:\n"); 
 if(!autoLoad((Object**) &asetHatman, fileAsetHatman, (objectCreateFunc) Aset::create)) goto error;
 if(!autoLoad((Object**) &asetGhost, fileAsetGhosts, (objectCreateFunc) Aset::create)) goto error;
 if(!autoLoad((Object**) &ssetBlocks, fileSsetBlocks, (objectCreateFunc) Sset::create)) goto error;
 if(!autoLoad((Object**) &sprExtra, "graphics/extra.spr", (objectCreateFunc) Sprite::create)) goto error;
 return true;

error:
 nonFatal("error loading data: %s\n", errStr);
 return false;
}

//-----------------------------------------------------------------------------
void killData()
{
 if(animHat) delete animHat;
}
