/* 
 * Copyright (C) 1999 JP Rosevear
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA
 */

#include "gnome_chess.h"

/* Menu callback functions */
static void engine_null_menu_init(struct engine *e);

struct engine * engine_null_new(char *cmd, char *arg) {
	struct engine *e;
	char *argv[3];
	GtkWidget *dialog;

	argv[0]=cmd;
	argv[1]=arg;
	argv[2]=NULL;

	e = engine_new(cmd, argv);
	engine_null_menu_init(e);

	dialog = gnome_ok_dialog(_("Unable to find a chess program on this machine.\nChoose a menu option or specify a program on the command line."));

	return e;
}

static void engine_null_menu_init(struct engine *e) {
	e->menudata->menu_init = engine_null_menu_init;
	e->menudata->menu_new_cb = NULL;
	e->menudata->menu_flag_cb = NULL;
	e->menudata->menu_draw_cb = NULL;
	e->menudata->menu_resign_cb = NULL;
	e->menudata->menu_start_cb = NULL;
	e->menudata->menu_previous_cb = NULL;
	e->menudata->menu_next_cb = NULL;
	e->menudata->menu_end_cb = NULL;
	e->menudata->menu_takeback_cb = NULL;
	e->menudata->menu_go_cb = NULL;
	e->menudata->menu_now_cb = NULL;
	e->menudata->menu_cwhite_cb = NULL;
	e->menudata->menu_cblack_cb = NULL;

	disable_all_menus();
	uncheck_all_menus();
	enable_menu(MENU_SERVERS);
	enable_menu(MENU_LOAD);
	enable_menu(MENU_SAVE);
}
 
