/* gEDA - GNU Electronic Design Automation
 * gschem - GNU Schematic Capture
 * Copyright (C) 1998 Ales V. Hvezda
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111 USA
 */

#include <config.h>
#include <stdio.h>
#include <math.h>
#ifdef HAVE_UNISTD_H
#include <unistd.h>
#endif

#include <gtk/gtk.h>
#include <gdk/gdk.h>
#include <gdk/gdkx.h>

#include <guile/gh.h>

#include <libgeda/defines.h>
#include <libgeda/struct.h>
#include <libgeda/globals.h>
#include <libgeda/o_types.h>
#include <libgeda/colors.h>
#include <libgeda/prototype.h>

#include "../include/prototype.h"

void
o_complex_draw(TOPLEVEL *w_current, OBJECT *o_current)
{
	int left, right, top, bottom;

	o_redraw(w_current, o_current->complex);

	get_complex_bounds(w_current, o_current->complex,
			   &left, &top, &right, &bottom);
	o_current->left   = left;
	o_current->top    = top;
	o_current->right  = right;
	o_current->bottom = bottom;

	WORLDtoSCREEN(w_current,
		      o_current->x,
		      o_current->y,
		      &o_current->screen_x,
		      &o_current->screen_y);
}

void
o_complex_draw_xor(TOPLEVEL *w_current, int dx, int dy, OBJECT *complex)
{
	OBJECT *o_current = complex;

	while(o_current != NULL) {
		switch(o_current->type) {
		case(OBJ_LINE):
			o_line_draw_xor(w_current, dx, dy, o_current);
			break;

		case(OBJ_NET):
			o_net_draw_xor(w_current, dx, dy, o_current);
			break;

		case(OBJ_BUS):
			o_bus_draw_xor(w_current, dx, dy, o_current);
			break;

		case(OBJ_BOX):
			o_box_draw_xor(w_current, dx, dy, o_current);
			break;

		case(OBJ_CIRCLE):
			o_circle_draw_xor(w_current, dx, dy, o_current);
			break;

		case(OBJ_COMPLEX):
				/* TODO: complex inside a complex? -
                                 * not supported yet */
#if 0
			o_complex_draw_xor(w_current, dx, dy,
					   o_current->complex);
#endif
			break;

		case(OBJ_TEXT):
			o_text_draw_xor(w_current, dx, dy, o_current);
			break;

		case(OBJ_PIN):
			o_pin_draw_xor(w_current, dx, dy, o_current);
			break;

		case(OBJ_ARC):
			o_arc_draw_xor(w_current, dx, dy, o_current);
			break;
		}
		o_current = o_current->next;
	}
}

void
o_complex_start(TOPLEVEL *w_current, int screen_x, int screen_y)
{
	int x, y;

	w_current->last_x = w_current->start_x = fix_x(w_current, screen_x);
	w_current->last_y = w_current->start_y = fix_y(w_current, screen_y);

	w_current->last_drawb_mode = -1;

	/* make sure list is null first, so that you don't have a mem
	 * leak */
        SCREENtoWORLD(w_current,
		      w_current->start_x,
		      w_current->start_y,
		      &x,
		      &y);

	w_current->ADDING_SEL = 1; /* reuse this flag, rename later hack */
	w_current->DONT_DRAW_CONN = 1;
	w_current->page_current->complex_place_tail =
		(OBJECT *) o_complex_add(
			w_current,
			w_current->page_current->complex_place_head,
			OBJ_COMPLEX, WHITE, x, y, 0, 0,
			w_current->internal_clib,
			w_current->internal_basename, 1);
	w_current->ADDING_SEL = 0;
	w_current->DONT_DRAW_CONN = 0;

	o_drawbounding(w_current,
		       w_current->page_current->complex_place_head->next,
		       x_get_color(w_current->bb_color));
}

void
o_complex_end(TOPLEVEL *w_current, int screen_x, int screen_y)
{
	int diff_x, diff_y;
	int x, y;
	int rleft, rtop, rbottom, rright;
	OBJECT *selection_list = NULL;
	OBJECT *o_current;
	OBJECT *o_start;
	char *include_filename;

	diff_x = w_current->last_x - w_current->start_x;
        diff_y = w_current->last_y - w_current->start_y;

	SCREENtoWORLD(w_current, screen_x, screen_y, &x, &y);

#if 0
	x = snap_grid(w_current, x);
	y = snap_grid(w_current, y);
#endif

#if DEBUG
	printf("place_basename: %s\n",internal_basename);
	printf("place_clib: %s\n",internal_clib);
#endif

	if (w_current->include_complex) {
		include_filename = u_basic_strdup_multiple(
			w_current->internal_clib,
			"/",
			w_current->internal_basename,
			NULL);

		o_start = w_current->page_current->object_tail;
		w_current->page_current->object_tail =
			o_read(w_current,
			       w_current->page_current->object_tail,
			       include_filename);
		o_start = o_start->next;

		o_complex_world_translate(w_current, x, y, o_start);

		free(include_filename);

		if (w_current->actionfeedback_mode == OUTLINE) {
#if 0
			printf("inside draw outline here\n");
#endif
			/* erase outline */
			o_complex_translate_display(
				w_current,
				diff_x, diff_y,
				w_current->page_current->
				complex_place_head->next);
        	} else {
#if 0
			printf("inside draw bounding here\n");
#endif
			get_complex_bounds(
				w_current,
				w_current->page_current->
				complex_place_head->next,
				&rleft, &rtop, &rright, &rbottom);
        		gdk_gc_set_foreground(
				w_current->gc,
				x_get_color(w_current->background_color));
                	gdk_draw_rectangle(w_current->window, w_current->gc,
					   FALSE,
					   rleft   + diff_x,
					   rtop    + diff_y,
					   rright  - rleft,
					   rbottom - rtop);
		}

		o_redraw(w_current, o_start);
		w_current->page_current->CHANGED = 1;
		return;
	}

	w_current->page_current->object_tail = o_complex_add(
		w_current,
		w_current->page_current->object_tail,
		OBJ_COMPLEX, WHITE, x, y, 0, 0,
		w_current->internal_clib,
		w_current->internal_basename, 1);

	/* 1 should be define fix everywhere hack */

	o_current = w_current->page_current->object_tail;
	/* put code here to deal with emebedded stuff */
	if (w_current->embed_complex) {
		char* new_basename;

		free(o_current->complex_clib);

		o_current->complex_clib = u_basic_strdup("EMBEDDED");

		new_basename = u_basic_strdup_multiple(
			"EMBEDDED",
			o_current->complex_basename,
			NULL);

		free(o_current->complex_basename);

		o_current->complex_basename = u_basic_strdup(new_basename);

		free(new_basename);
	}

	/* check for nulls in all this hack */
	if (w_current->actionfeedback_mode == OUTLINE) {
#if 0
		printf("inside draw outline here\n");
#endif
		/* erase outline */
		o_complex_translate_display(
			w_current,
			diff_x, diff_y,
			w_current->page_current->complex_place_head->next);
        } else {
#if 0
		printf("inside draw bounding here\n");
#endif
		get_complex_bounds(
			w_current,
			w_current->page_current->complex_place_head->next,
			&rleft, &rtop,
			&rright, &rbottom);
        	gdk_gc_set_foreground(
			w_current->gc,
			x_get_color(w_current->background_color));
                gdk_draw_rectangle(w_current->window, w_current->gc, FALSE,
				   rleft   + diff_x,
				   rtop    + diff_y,
				   rright  - rleft,
				   rbottom - rtop);
	}

	/* TODO: redraw has to happen at the end of all this hack or
	 * maybe not? */
	o_list_delete_rest(w_current,
			   w_current->page_current->complex_place_head);

	/* This doesn't allow anything else to be in the selection
	 * list when you add a component */

	selection_list = (OBJECT *) o_list_copy_to(
		w_current,
		selection_list,
		w_current->page_current->object_tail, SELECTION);

	/* addon maybe later... press shift when adding an object to
	 * add it to the current selection list? */
	o_unredraw_selected(w_current);
	o_list_delete_rest(w_current, w_current->page_current->selection_head);
	w_current->page_current->selection_head->next = selection_list;
	selection_list->prev = w_current->page_current->selection_head;
	w_current->page_current->selection_tail = return_tail(
		w_current->page_current->selection_head);
	/* the o_redraw_selected is in x_events.c after this call
	 * returns */

	o_conn_disconnect_update(w_current->page_current);
	o_conn_erase_all(w_current, w_current->page_current->object_tail);
#if 0
        o_conn_draw_all(w_current, w_current->page_current->object_head);
#endif
	o_redraw(w_current, w_current->page_current->object_head);

        o_redraw_real(w_current, w_current->page_current->selection_head);

	w_current->page_current->CHANGED = 1;
}

void
o_complex_rubbercomplex(TOPLEVEL *w_current)
{
	o_drawbounding(w_current,
		       w_current->page_current->complex_place_head->next,
		       x_get_color(w_current->bb_color));
}

void
o_complex_translate_display(TOPLEVEL *w_current,
			    int x1, int y1, OBJECT *complex)
{
	OBJECT *o_current = complex;

	while (o_current != NULL) {
		switch(o_current->type) {
		case(OBJ_LINE):
			o_line_draw_xor(w_current, x1, y1, o_current);
			break;

		case(OBJ_NET):
			o_net_draw_xor(w_current, x1, y1, o_current);
			break;

		case(OBJ_BUS):
			o_bus_draw_xor(w_current, x1, y1, o_current);
			break;

		case(OBJ_BOX):
			o_box_draw_xor(w_current, x1, y1, o_current);
			break;

		case(OBJ_CIRCLE):
			o_circle_draw_xor(w_current, x1, y1, o_current);
			break;

		case(OBJ_COMPLEX):
			o_complex_draw_xor(w_current,
					   x1, y1, o_current->complex);
			break;

		case(OBJ_TEXT):
			o_text_draw_xor(w_current, x1, y1, o_current);
			break;

		case(OBJ_PIN):
			o_pin_draw_xor(w_current, x1, y1, o_current);
			break;

		case(OBJ_ARC):
			o_arc_draw_xor(w_current, x1, y1, o_current);
			break;
		}
		o_current = o_current->next;
	}
}

/* don't know if this belongs yet */
void
o_complex_translate_all(TOPLEVEL *w_current, int offset)
{
	int rleft, rtop, rright, rbottom;
	int x, y;

#if 0
	/* these warnings have been moved into
         * i_callback_edit_translate */
	if (w_current->snap == 0) {
		s_log_message("WARNING: Do not translate with snap off!\n");
		s_log_message(
			"WARNING: Turning snap on and "
			"continuing with translate.\n");
		w_current->snap = 1;
	}

	if (w_current->snap_size != 100) {
		s_log_message(
			"WARNING: Snap grid size is not equal to 100!\n");
		s_log_message(
			"WARNING: If you are translating a symbol "
			"to the origin, the snap grid size should be "
			"set to 100\n");
	}
#endif

	get_complex_bounds(w_current, w_current->page_current->object_head,
			   &rleft,
			   &rtop,
			   &rright,
			   &rbottom);

	/* TODO: do we want snap grid here? */
	SCREENtoWORLD(w_current,
		      fix_x(w_current, rleft  ),
		      fix_y(w_current, rbottom),
		      &x,
		      &y);

	if (offset == 0) {
		s_log_message("Translating schematic [%d %d]\n", -x, -y);
		o_complex_world_translate(
			w_current,
			-x, -y,
			w_current->page_current->object_head);
	} else {
		s_log_message("Translating schematic [%d %d]\n",
			      offset, offset);
		o_complex_world_translate(
			w_current,
			offset, offset,
			w_current->page_current->object_head);
	}

	/* this is an experimental mod, to be able to translate to all
	 * places */
#if 0
	o_complex_world_translate(1000, 1000, object_head);
	printf("symbol -%d -%d\n", x, y);
	o_complex_world_translate(-x, -y, object_head); /* to zero, zero */
#endif

	o_unselect_all(w_current);
	o_redraw_all(w_current);
	w_current->page_current->CHANGED=1;
}

/* experimental */
void
o_complex_translate2(TOPLEVEL *w_current, int dx, int dy, OBJECT *object)
{
	if (object == NULL)  {
		printf("cmt2 NO!\n");
		return;
	}

	o_complex_translate_display(w_current, dx, dy, object);
}

void
o_complex_rotate(TOPLEVEL *w_current, int centerx, int centery,
		 int angle, int angle_change, OBJECT *object)
{
	int x, y;
	int newx, newy;
	int world_centerx, world_centery;

	SCREENtoWORLD(w_current,
		      centerx,
		      centery,
		      &world_centerx,
		      &world_centery);

	x = object->x + (-world_centerx);
	y = object->y + (-world_centery);

	rotate_point_90(x, y, 90, &newx, &newy);

	x = newx + (world_centerx);
	y = newy + (world_centery);

	o_complex_world_translate_toplevel(w_current,
					   -object->x, -object->y, object);
	o_complex_rotate_lowlevel(w_current,
				  0, 0, angle, angle_change, object);

	object->x = 0;
	object->y = 0;

	o_complex_world_translate_toplevel(w_current, x, y, object);

	object->angle = angle;

#if DEBUG
	printf("setting final rotated angle to: %d\n\n", object->angle);
#endif
}

int
o_complex_mirror(TOPLEVEL *w_current, int centerx, int centery,
		 OBJECT *object)
{
	int x, y;
	int newx, newy;
	int origx, origy;
	int world_centerx, world_centery;
	int change = 0;

	SCREENtoWORLD(w_current,
		      centerx,
		      centery,
		      &world_centerx,
		      &world_centery);

	origx = object->x;
	origy = object->y;

	x = object->x + (-world_centerx);
	y = object->y + (-world_centery);

	newx = -x;
	newy = y;

	x = newx + (world_centerx);
	y = newy + (world_centery);

	o_complex_world_translate_toplevel(w_current,
					   -object->x, -object->y, object);

	o_complex_mirror_lowlevel(w_current, 0, 0, object);

	switch(object->angle) {
	case(90):
		object->angle = 270;
#if 0
		o_text_change_angle(w_current, object->complex,
				     object->angle);
#endif

		change = 1;
		break;

	case(270):
		object->angle = 90;
#if 0
		o_text_change_angle(w_current, object->complex,
				     object->angle);
#endif
		change = 1;
		break;

	}
#if 0
	object->angle = (object->angle + 180) % 360;
#endif

	object->mirror = !object->mirror;
#if 0
	object->x = 0;
	object->y = 0;
#endif

	o_complex_world_translate_toplevel(w_current, x, y, object);

#if DEBUG
	printf("final res %d %d\n", object->x,  object->y);
#endif
#if 0
	object->x = x;
	object->y = y;
#endif
	return(change);
}

/* this is a special mirror which doesn't mirror the object in memory,
 * but read the new "correctly mirrored/rotated" object from disk */
/* TODO: yes this is aweful, and I will eventually fix it, but for now
 * it has to do hack */
OBJECT *
o_complex_mirror2(TOPLEVEL *w_current, OBJECT *list, int centerx, int centery,
		  OBJECT *object)
{
	OBJECT *new_obj = NULL;
	int x, y;
	int newx, newy;
	int origx, origy;
	int world_centerx, world_centery;
	int change=0;

	SCREENtoWORLD(w_current,
		      centerx,
		      centery,
		      &world_centerx,
		      &world_centery);

	origx = object->x;
	origy = object->y;

	x = object->x + (-world_centerx);
	y = object->y + (-world_centery);

	newx = -x;
	newy = y;

	x = newx + (world_centerx);
	y = newy + (world_centery);

	switch(object->angle) {
	case(90):
		object->angle = 270;
#if 0
		o_text_change_angle(w_current, object->complex,
				     object->angle);
#endif
		change = 1;
		break;

	case(270):
		object->angle = 90;
#if 0
		o_text_change_angle(w_current, object->complex,
				     object->angle);
#endif
		change=1;
		break;

	}

	object->mirror = !object->mirror;

	new_obj = o_complex_add(w_current,
				list, OBJ_COMPLEX,
				object->color,
				x, y,
				object->angle, object->mirror,
				object->complex_clib, object->complex_basename,
				1);

	/* TODO: fix up name sometime ... */
	new_obj->sid = object->sid;

	new_obj->attribs = o_attrib_copy_all(
		w_current, new_obj, object->attribs);

	o_attrib_slot_update(w_current, new_obj);

	o_complex_delete(w_current, object);

	/* need to do the following, because delete severs links */
	o_attrib_reattach(new_obj->attribs);
 	o_attrib_set_color(w_current, new_obj->attribs);

#if 0
 	w_current->page_current->object_tail = (OBJECT *)
		return_tail(w_current->page_current->object_head);
#endif

	return(new_obj);
}

