/*$Id: u_opt2.cc,v 15.3 1999/09/17 17:27:00 al Exp $ -*- C++ -*-
 * command and functions to access OPT class
 */
#include "s__.h"
#include "constant.h"
#include "ap.h"
#include "u_opt.h"
/*--------------------------------------------------------------------------*/
//	void	OPT::command(CS& cmd);
//	bool	OPT::set(CS& cmd);
//	void	OPT::print(OMSTREAM where)
/*--------------------------------------------------------------------------*/
void OPT::command(CS& cmd)
{
  bool changed = set(cmd);
  if (!changed || opts){
    print(IO::mstdout);
  }
}
/*--------------------------------------------------------------------------*/
/* set:  set options from a string
 */
bool OPT::set(CS& cmd)
{
  bool changed = false;
  cmd.stuck();
  do{
    cmd.get("ACCT",	   &acct);
    cmd.get("LIST",	   &list);
    cmd.get("MOD",	   &nomod,	mINVERT);
    cmd.get("PAGE",	   &page);
    cmd.get("NODE",	   &node);
    cmd.get("OPTS",	   &opts);
    cmd.get("GMIN",	   &gmin,	mPOSITIVE);
    cmd.get("RELTOL",	   &reltol,	mPOSITIVE);
    cmd.get("ABSTOL",	   &abstol,	mPOSITIVE);
    cmd.get("VNTOL",	   &vntol,	mPOSITIVE);
    cmd.get("TRTOL",	   &trtol,	mPOSITIVE);
    cmd.get("CHGTOL",	   &chgtol,	mPOSITIVE);
    cmd.get("PIVTOL",	   &pivtol,	mPOSITIVE);
    cmd.get("PIVREL",	   &pivrel,	mPOSITIVE);
    cmd.get("NUMDGT",	   &numdgt);
    cmd.get("TNOM",	   &tnom,	mOFFSET, -ABS_ZERO);
    cmd.get("CPTIME",	   &cptime);
    cmd.get("LIMTIM",	   &limtim);
    cmd.get("LIMPTS",	   &limpts);
    cmd.get("LVLCOD",	   &lvlcod);
    cmd.get("LVLTIM",	   &lvltim);
    cmd.pmatch("METHOD") &&
      (  ::set(cmd, "Euler",	  &method, meEULER)
       ||::set(cmd, "EULEROnly",  &method, meEULERONLY)
       ||::set(cmd, "Trapezoidal",&method, meTRAP)
       ||::set(cmd, "TRAPOnly",	  &method, meTRAPONLY)
       ||::set(cmd, "Gear2",	  &method, meGEAR2)
       ||::set(cmd, "GEAR2Only",  &method, meGEAR2ONLY)
       ||::set(cmd, "TRAPGear",   &method, meTRAPGEAR)
       ||::set(cmd, "TG",	  &method, meTRAPGEAR)
       ||::set(cmd, "TRAPEuler",  &method, meTRAPEULER)
       ||::set(cmd, "TE",	  &method, meTRAPEULER)
       ||  cmd.warn(bWARNING, "illegal method"));
    cmd.get("MAXORD",	   &maxord);
    cmd.get("DEFL", 	   &defl,	mPOSITIVE);
    cmd.get("DEFW", 	   &defw,	mPOSITIVE);
    cmd.get("DEFAD",	   &defad,	mPOSITIVE);
    cmd.get("DEFAS",	   &defas,	mPOSITIVE);
    cmd.get("Seed",	   &seed);
    cmd.get("WCZero",	   &wczero,	mPOSITIVE);
    cmd.get("DAMPMAX",	   &dampmax,	mPOSITIVE);
    cmd.get("DAMPMIN",	   &dampmin,	mPOSITIVE);
    cmd.get("DAMPStrategy",&dampstrategy, mOCTAL);
    cmd.get("ROUndofftol", &roundofftol,mPOSITIVE);
    cmd.get("Tempamb",	   &tempamb,	mOFFSET, -ABS_ZERO);
    cmd.get("Short",	   &shortckt,	mPOSITIVE);
    cmd.get("TRansits",	   &transits);
    cmd.get("INwidth",	   &inwidth);
    cmd.get("OUTwidth",	   &outwidth);
    cmd.get("XDivisions",  &xdivisions,	mPOSITIVE);
    cmd.get("YDivisions",  &ydivisions,	mPOSITIVE);
    /**/::set(cmd, "NAG",     &picky,	bNOERROR)
      ||::set(cmd, "NONAG",   &picky,	bTRACE)
      ||::set(cmd, "TRACE",   &picky,	bTRACE)
      ||::set(cmd, "NOTRACE", &picky,	bLOG)
      ||::set(cmd, "LOG",     &picky,	bLOG)
      ||::set(cmd, "NOLOG",   &picky,	bDEBUG)
      ||::set(cmd, "DEBUG",   &picky,	bDEBUG)
      ||::set(cmd, "NODEBUG", &picky,	bPICKY)
      ||::set(cmd, "PICKY",   &picky,	bPICKY)
      ||::set(cmd, "NOPICKY", &picky,	bWARNING)
      ||::set(cmd, "WARNing", &picky,	bWARNING)
      ||::set(cmd, "NOWARN",  &picky,	bDANGER)
      ||::set(cmd, "ERRor",   &picky,	bERROR)
      ||::set(cmd, "NOERRor", &picky,	bDISASTER)
      ||::set(cmd, "DISASTER",&picky,	bDISASTER);
    cmd.pmatch("ORder") &&
      ( ::set(cmd, "Reverse", &order,	oREVERSE)
      ||::set(cmd, "Forward", &order,	oFORWARD)
      ||::set(cmd, "Auto",    &order,	oAUTO)
      ||  cmd.warn(bWARNING, "need reverse, forward, or auto"));
    cmd.pmatch("MODe") &&
      ( ::set(cmd, "Analog",  &mode,	moANALOG)
      ||::set(cmd, "Digital", &mode,	moDIGITAL)
      ||::set(cmd, "Mixed",   &mode,	moMIXED)
      ||  cmd.warn(bWARNING, "need analog, digital, or mixed"));
    cmd.get("DUPcheck",	   &dupcheck);
    (   ::set(cmd, "BYPass",  &bypass,	bYES)
      ||::set(cmd, "NOBYPass",&bypass,	bNO)
      ||::set(cmd, "VBYPass", &bypass,	bVOLT));
    cmd.get("INCmode",	   &incmode);
    cmd.get("LUBypasss",   &lubypass);
    cmd.get("FBBypasss",   &fbbypass);
    cmd.get("TRACELoad",   &traceload);
    cmd.get("ITERMIN",	   &itermin);
    cmd.get("LIMIT",	   &limit,	mPOSITIVE);
    cmd.get("VMAX",	   &vmax);
    cmd.get("VMIN",	   &vmin);
    cmd.get("MRT",	   &dtmin,	mPOSITIVE);
    cmd.get("DTMIn",	   &dtmin,	mPOSITIVE);
    cmd.get("DTRatio",	   &dtratio,	mPOSITIVE);
    cmd.get("RSTray",	   &rstray);
    cmd.get("CSTray",	   &cstray);
    cmd.get("Harmonics",   &harmonics);
    cmd.get("TRSTEPGrow",  &trstepgrow,	mPOSITIVE);
    cmd.get("TRSTEPShrink",&trstepshrink, mPOSITIVE);
    cmd.get("TRReject",	   &trreject,	mPOSITIVE);
    cmd.get("SHOWALL",	   &showall);
    cmd.get("FOOOO",	   &foooo);
    cmd.get("DIODEflags",  &diodeflags,	mOCTAL);
    cmd.get("MOSflags",	   &mosflags,	mOCTAL);
    cmd.get("ITL1",	   &itl[1]);
    cmd.get("ITL2",	   &itl[2]);
    cmd.get("ITL3",	   &itl[3]);
    cmd.get("ITL4",	   &itl[4]);
    cmd.get("ITL5",	   &itl[5]);
    cmd.get("ITL6",	   &itl[6]);
    cmd.get("ITL7",	   &itl[7]);
    cmd.get("ITL8",	   &itl[8]);
    if (cmd.stuck()){
      cmd.check(bWARNING, "what's this?");
      cmd.skiparg();
    }else{
      changed = true;
    }
  }while (cmd.more() && changed);

  if (changed){
    SIM::uninit();
    lowlim = 1 - reltol;
    uplim  = 1 + reltol;
  }
  return changed;
}
/*--------------------------------------------------------------------------*/
/* print: "print" all option values to "where"
 * string is in a form suitable for passing to set
 */
void OPT::print(OMSTREAM where)
{
  where.setfloatwidth(7);
  where << ".options";
  where << ((acct) ?"  acct" :"  noacct");
  where << ((list) ?"  list" :"  nolist");
  where << ((nomod)?"  nomod":"  mod");
  where << ((page) ?"  page" :"  nopage");
  where << ((node) ?"  node" :"  nonode");
  where << ((opts) ?"  opts" :"  noopts");
  where << "  gmin="   << gmin;
  where << "  reltol=" << reltol;
  where << "  abstol=" << abstol;
  where << "  vntol="  << vntol;
  where << "  trtol="  << trtol;
  where << "  chgtol=" << chgtol;
  where << "  pivtol=" << pivtol;
  where << "  pivrel=" << pivrel;
  where << "  numdgt=" << numdgt;
  where << "  tnom="   << tnom+ABS_ZERO;
  where << "  cptime=" << cptime;
  where << "  limtim=" << limtim;
  where << "  limpts=" << limpts;
  where << "  lvlcod=" << lvlcod;
  where << "  lvltim=" << lvltim;
  where << "  method=" << method;
  where << "  maxord=" << maxord;
  for (int ii=1;  ii<ITL_COUNT;  ii++)
    where << "  itl@" << ii << "=" << itl[ii];
  where << "  defl="   << defl;
  where << "  defw="   << defw;
  where << "  defad="  << defad;
  where << "  defas="  << defas;
  where << "  seed="   << seed;
  where << "  wczero=" << wczero;
  where << "  dampmax="<< dampmax;
  where << "  dampmin="<< dampmin;
  where << "  dampstrategy="<< octal(dampstrategy);
  where << "  roundofftol=" << roundofftol;
  where << "  tempamb="<< tempamb+ABS_ZERO;
  where << "  short="  << shortckt;
  where << "  in="     << inwidth;
  where << "  out="    << outwidth;
  where << "  xdivisions=" << xdivisions;
  where << "  ydivisions=" << ydivisions;
  where << "  order="  << order;
  where << "  mode="   << mode;
  where << "  transits=" << transits;
  where << ((dupcheck)?"  dupcheck":"  nodupcheck");
  where << "  "        << bypass;
  where << ((incmode)  ?"  incmode"  :"  noincmode");    
  where << ((lubypass) ?"  lubypass" :"  nolubypass");    
  where << ((fbbypass) ?"  fbbypass" :"  nofbbypass");    
  where << ((traceload)?"  traceload":"  notraceload");    
  where << "  itermin="<< itermin;
  where << "  limit="  << limit;
  where << "  vmax="   << vmax;
  where << "  vmin="   << vmin;
  where << "  dtmin="  << dtmin;
  where << "  dtratio="<< dtratio;
  where << ((rstray)?"  rstray":"  norstray");
  where << ((cstray)?"  cstray":"  nocstray");
  where << "  harmonics="   << harmonics;
  where << "  trstepgrow="  << trstepgrow;
  where << "  trstepshrink="<< trstepshrink;
  where << "  trreject="    << trreject;
  where << "  diodeflags="  << octal(diodeflags);
  where << "  mosflags="    << octal(mosflags);
  where << '\n';
}
/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/
