/*$Id: s_ac_set.cc,v 15.3 1999/09/17 17:27:00 al Exp $ -*- C++ -*-
 * ac analysis setup
 */
#include "u_prblst.h"
#include "u_opt.h"
#include "constant.h"
#include "ap.h"
#include "s_ac.h"
/*--------------------------------------------------------------------------*/
//	void	AC::setup(CS&);
//	void	AC::by(CS&);
//	void	AC::decade(CS&);
//	void	AC::lin(CS&);
//	void	AC::octave(CS&);
//	void	AC::times(CS&);
/*--------------------------------------------------------------------------*/
static int needslinfix;	// flag: lin option needs patch later (spice compat)
/*--------------------------------------------------------------------------*/
void AC::setup(CS& cmd)
{
  out = IO::mstdout;
  out.reset(); /* BUG: don't know why this is needed */
  temp = OPT::tempamb;
  bool ploton = IO::plotset  &&  plotlist().size() > 0;
  cold = cont = echo = false;

       if (cmd.pmatch("*$$"))    times(cmd);
  else if (cmd.pmatch("By"))     by(cmd);
  else if (cmd.pmatch("Decade")) decade(cmd);
  else if (cmd.pmatch("TImes"))  times(cmd);
  else if (cmd.pmatch("LIn"))	 lin(cmd);
  else if (cmd.pmatch("Octave")) octave(cmd);
  
  if (cmd.is_float()){
    start = cmd.ctof();
    stop  = cmd.ctof();
    if (stop==0.){
      stop = start;
    }
    if (cmd.is_float()){
      by(cmd);
    }
  }

  cmd.stuck();
  do{
         if (cmd.pmatch("*$"))     times(cmd);
    else if (cmd.pmatch("+$"))     by(cmd);
    else if (cmd.pmatch("By"))     by(cmd);
    else if (cmd.pmatch("Decade")) decade(cmd);
    else if (cmd.pmatch("TImes"))  times(cmd);
    else if (cmd.pmatch("LIn"))	   lin(cmd);
    else if (cmd.pmatch("Octave")) octave(cmd);
    cmd.get("Ambient",	  &temp,   mOFFSET, OPT::tempamb);
    cmd.get("Cold",	  &cold);
    cmd.get("CONTinue",	  &cont);
    cmd.get("Echo",	  &echo);
    cmd.get("PLot",	  &ploton);
    cmd.get("Reftemp",	  &temp,   mOFFSET, OPT::tnom);
    cmd.get("Temperature",&temp,   mOFFSET, -ABS_ZERO);
    outset(cmd,&out);
  }while (cmd.more() && !cmd.stuck());
  cmd.check(bWARNING, "what's this?");

  IO::plotout = (ploton) ? IO::mstdout : OMSTREAM(0);
  initio(out, IO::whence);
  if (needslinfix){			    // LIN option is # of points.
    untested();
    step=(stop-start)/(step-1.);	    // Must compute step after 
    needslinfix = false;		    // reading start and stop,
  }					    // but step must be read first
  if (step==0.){			    // for Spice compatibility
    step = stop - start;
    linswp = true;
  }
}
/*--------------------------------------------------------------------------*/
void AC::by(CS& cmd)
{
  step = cmd.ctof();
  needslinfix = false;
  linswp = true;
}
/*--------------------------------------------------------------------------*/
void AC::decade(CS& cmd)
{
  step = cmd.ctopf();
  if (step == 0.){
    step = 1.;
  }
  step = pow(10., 1./step);
  needslinfix = false;
  linswp = false;
}
/*--------------------------------------------------------------------------*/
void AC::lin(CS& cmd)
{
  step = cmd.ctopf();		// need to fix step, later
  if (step == 0.){		// do it at the end of setup
    step = 1.;			// a kluge, but this is a patch
    untested();
  }else{
    untested();
  }
  needslinfix = true;		// and I am too lazy to do it
  linswp = true;		// right.
}
/*--------------------------------------------------------------------------*/
void AC::octave(CS& cmd)
{
  step = cmd.ctopf();
  if (step == 0.){
    step = 1.;
    untested();
  }
  step = pow(2.00000001, 1./step);
  needslinfix = false;
  linswp = false;
}
/*--------------------------------------------------------------------------*/
void AC::times(CS& cmd)
{
  step = cmd.ctopf();
  if (step == 0.   &&   start != 0.){
    step = stop / start;
    untested();
  }else{
    untested();
  }
  needslinfix = false;
  linswp = false;
}
/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/
