/*$Id: md.cc,v 14.19 1999/08/18 17:17:11 al Exp $ -*- C++ -*-
 * Non-portable functions.  Do all portability patches here.
 */
#include "md.h"
#include <errno.h>
#include <signal.h>
#if defined(WIN32)
#include <dos.h>
#include <process.h>
#include <time.h>
#endif
/*--------------------------------------------------------------------------*/
	void    initialize_io(void);
	void    setup_traps(void);
static	void	new_ex_handler();
static	void	sig_int(SIGNALARGS);
static	void	sig_fpe(SIGNALARGS);
	int	getrusage(int,struct rusage*);
	void	shell(void);
/*--------------------------------------------------------------------------*/
void initialize_io(void)
{
  IO::stream[static_cast<int>(fileno(stdin ))] = NULL;
  IO::stream[static_cast<int>(fileno(stdout))] = stdout;
  IO::stream[static_cast<int>(fileno(stderr))] = stderr;
  IO::mstdout = IO::error = 1<<fileno(stdout);
}
/*--------------------------------------------------------------------------*/
void setup_traps(void)
{
  signal(SIGFPE,sig_fpe);
  signal(SIGINT,sig_int);
#if !defined(NEW_IS_BROKEN)
  set_new_handler(new_ex_handler);
#endif
}
/*--------------------------------------------------------------------------*/
#if !defined(NEW_IS_BROKEN)
static void new_ex_handler()
{
  untested();
  error(bERROR, "out of memory\n");
}
#endif
/*--------------------------------------------------------------------------*/
/* sig_int: what to do on receipt of interrupt signal (SIGINT)
 * cancel batch files, then back to command mode.
 * (actually, control-c trap)
 */
/*ARGSUSED*/
static void sig_int(SIGNALARGS)
{
  untested();
  signal(SIGINT,sig_int);
  error(bERROR, "\n");
}
/*--------------------------------------------------------------------------*/
static void sig_fpe(SIGNALARGS)
{
  untested();
  signal(SIGFPE,sig_fpe);
  error(bDANGER, "floating point error: %x\n", errno);
}
/*--------------------------------------------------------------------------*/
#if defined(NEEDS_GETRUSAGE)
int getrusage(int /*who*/, struct rusage *rusage)
{
  double ticks = (double)clock();
  rusage->ru_stime.tv_sec = rusage->ru_stime.tv_usec = 0;
  rusage->ru_utime.tv_usec =
    (long)fmod(ticks, (double)CLK_TCK) * (1000000./(double)CLK_TCK);
  rusage->ru_utime.tv_sec = (long)(ticks/(double)CLK_TCK);
  return 0;
}
#endif
/*--------------------------------------------------------------------------*/
#if defined(WIN32)
void shell(void)
{
  char* shell = getenv("COMSPEC");
  if (!shell){
    error(bERROR, "internal error: comspec\n");
  }
  
  int errcod = spawnle(P_WAIT, shell, shell, NULL, environ);
  _fpreset();
  if (errcod == EOF){
    switch (errno){
      case E2BIG:   error(bERROR, "internal error: arg list\n");
      case EINVAL:  error(bERROR, "internal error: mode flag\n");
      case ENOENT:  error(bERROR, "no shell\n");
      case ENOEXEC: error(bERROR, "bad shell\n");
      case ENOMEM:  error(bERROR, "out of memory\n");
      default:	    error(bERROR, "internal error: system\n");
    }
  }
}
#else
void shell(void)
{
  system(getenv("SHELL"));
}
#endif
/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/
