/*$Id: l_inttbl.h,v 14.19 1999/08/18 17:17:11 al Exp $ -*- C++ -*-
 * An interpolation table class
 */
#ifndef L_INTTBL_H
#define L_INTTBL_H
#include "md.h"
#include "m_cpoly.h"
/*--------------------------------------------------------------------------*/
template <class KT, class VT>
class PAIR {
private:
  KT key;
  VT value;
public:
  explicit PAIR()	: key(NOT_VALID), value(NOT_VALID) {untested();}
  explicit PAIR(KT k, const VT& v)	: key(k), value(v) {}
  /*implicit*/ PAIR(const PAIR<KT,VT>& p) : key(p.Key()), value(p.Value()) {}
  KT	Key()const			{return key;}
  VT	Value()const			{return value;}
  bool operator<(PAIR<KT,VT> x)const	{return Key() < x.Key();}
  bool operator<=(PAIR<KT,VT> x)const	{return Key() <= x.Key();}
  bool operator<(KT x)const		{return Key() < x;}
  //bool operator>(KT x)const		{untested(); return key > x;}
};

template <class KT, class VT>
bool operator<(KT x, PAIR<KT,VT> y)	{return x < y.Key();}
template <class KT, class VT>
bool operator>(KT x, PAIR<KT,VT> y)	{return x > y.Key();}
/*--------------------------------------------------------------------------*/
enum INTERP_FLAG {ifEXTEND, ifFLAT};
/*--------------------------------------------------------------------------*/
/* interpolate:  linear interpolation on a table.
 * Keys must be sorted in increasing order.
 */
template <class Iterator>
FPOLY1 interpolate(Iterator begin, Iterator end, 
		   double x, INTERP_FLAG ends=ifEXTEND)
{
  assert(begin != end); // nothing there
  --end;
  {if (begin == end){ // only 1 entry -- constant
    //untested();
    return FPOLY1(x, (*begin).Value(), 0.);
  }else{
    ++begin;
    std::pair<Iterator,Iterator> here = std::equal_range(begin,end,x);
    if (here.first == here.second){	// between or outside
      --here.first;
      {if (ends==ifFLAT && here.second==end && x>(*(here.second)).Key()){
	return FPOLY1(x, (*(here.second)).Value(), 0.);
      }else if (ends==ifFLAT && here.second==begin && x<(*(here.first)).Key()){
	untested();
	return FPOLY1(x, (*(here.first)).Value(), 0.);
      }}
    }					// else exact match
    if ((*(here.second)).Key() < (*(here.first)).Key()){
      untested();
      error(bERROR, "table is not sorted\n");
    }
    double f1 = ((*(here.second)).Value() - (*(here.first)).Value())
      /  ((*(here.second)).Key() - (*(here.first)).Key());
    double f0 = (*(here.first)).Value() + (x - (*(here.first)).Key()) * f1;
    return FPOLY1(x, f0, f1);
  }}
}
/*--------------------------------------------------------------------------*/
template <class KT, class VT>
class INTERP_TABLE {
private:
  PAIR<KT,VT>* a;
  int size;
  mutable VT slope;
public:
  INTERP_TABLE(PAIR<KT,VT>* storage, int sz) : a(storage),size(sz),slope(0) {}
  VT Slope()const {return slope;}
  VT operator[](KT i) const {
    FPOLY1 y(interpolate(a, a+size, i));
    slope = y.f1;
    return y.f0;
  }
};
/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/
#endif
