/*$Id: e_base.cc,v 14.10 1999/07/06 07:32:12 al Exp $ -*- C++ -*-
 * Base class for "cards" in the circuit description file
 */
#include "s__.h"
#include "u_prblst.h"
#include "u_xprobe.h"
#include "constant.h"
#include "e_base.h"
/*--------------------------------------------------------------------------*/
//		 CKT_BASE()::~CKT_BASE();
//	double	 CKT_BASE::probe_num(const std::string&)const;
	double	 CKT_BASE::probe_tr_num(const std::string&)const
				{unreachable();return NOT_VALID;}
//	double	 CKT_BASE::probe_ac_num(const std::string&)const;
	XPROBE CKT_BASE::probe_ac_ext(const std::string&)const
				{unreachable();return XPROBE();}
/*--------------------------------------------------------------------------*/
BSMATRIX<double>  CKT_BASE::aa;
BSMATRIX<double>  CKT_BASE::lu;
BSMATRIX<COMPLEX> CKT_BASE::acx;
int		  CKT_BASE::_devcount = 0;
/*--------------------------------------------------------------------------*/
CKT_BASE::~CKT_BASE()
{
  trace1("~CKT_BASE", _probes);
  PROBE_LISTS::purge(this);
  trace1("", _probes);
  assert(_probes==0);
  --_devcount;
}
/*--------------------------------------------------------------------------*/
double CKT_BASE::probe_num(const std::string& what)const
{
  if (SIM::mode == sAC){
    return probe_ac_num(what);
  }else{
    return probe_tr_num(what);
  }
}
/*--------------------------------------------------------------------------*/
double CKT_BASE::probe_ac_num(const std::string& what)const
{
  int length = what.length();
  mod_t modifier = mtNONE;
  bool want_db = false;
  char parameter[BUFLEN+1];
  strcpy(parameter, what.c_str());

  if (length > 2  &&  pmatch(&parameter[length-2], "DB")){
    want_db = true;
    length -= 2;
  }
  if (length > 1){ // selects modifier based on last letter of parameter
    switch (tolower(parameter[length-1])){
      case 'm': modifier = mtMAG;   length--;	break;
      case 'p': modifier = mtPHASE; length--;	break;
      case 'r': modifier = mtREAL;  length--;	break;
      case 'i': modifier = mtIMAG;  length--;	break;
      default:  modifier = mtNONE;		break;
    }
  }
  parameter[length] = '\0'; // chop
  
  XPROBE xp = probe_ac_ext(parameter); // chopped form
  if (!xp.OK()){
    xp = probe_ac_ext(what); // full form
  }
  return xp(modifier, want_db);
}
/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/
