/*$Id: ap.h,v 15.19 1999/11/03 18:07:50 al Exp $  -*- C++ -*-
 * stuff for the "ap" family of parsing functions
 */
#ifndef AP_H
#define AP_H
#include "md.h"
/*--------------------------------------------------------------------------*/
enum AP_MOD{
  mNONE,	/* nothing special */
  mSCALE,	/* scale it after reading */
  mOFFSET,	/* add an offset */
  mINVERT,	/* save 1 / the number */
  mPOSITIVE,	/* store absolute value */
  mOCTAL,	/* read the number in octal */
  mHEX		/* read the number in hex */
};
  
class CS {
private:
  char* _cmd;
  int  _cnt;
  int  _last;
  bool _ok;
  int  _length;
public:
  // construction and re-construction
  explicit    CS(const std::string& s,int i=0)
    :_cmd(0),
     _cnt(i),
     _last(-1),
     _ok(true),
     _length(s.length())
  {
    _cmd = new char[_length+1];
    strcpy(_cmd, s.c_str());
  }
  explicit    CS(const CS& p)
    :_cmd(0),
     _cnt(p._cnt),
     _last(p._last),
     _ok(p._ok),
     _length(p._length)
  {
    _cmd = new char[_length+1];
    strcpy(_cmd, p._cmd);
  }
  CS&	      operator=(const std::string& s){
    if (_cmd){
      delete[] _cmd;
    }
    _cnt = 0;
    _last = -1;
    _ok = true;
    _length = s.length();
    _cmd = new char[_length+1];
    strcpy(_cmd, s.c_str());
    return *this;
  }    
  CS&	      operator=(const CS& p){
    if (_cmd){
      delete[] _cmd;
    }
    _cnt = p._cnt;
    _last = p._last;
    _ok = p._ok;
    _length = p._length;
    _cmd = new char[_length+1];
    strcpy(_cmd, p._cmd);
    return *this;
  }

	      ~CS()		{delete [] _cmd;}

  // status - non-consuming
  int	      cursor()const	{return _cnt;}
  bool        stuck()		{_ok=_last<_cnt; _last=_cnt; return !_ok;}
  bool        gotit()		{_ok=_last<_cnt; return _ok;}
	    operator bool()const{return _ok;}

  // status - may consume whitespace only
  bool	      more()		{skipbl(); return _cmd[_cnt]!='\0';}
  bool	      end()		{skipbl(); return _cmd[_cnt]=='\0';}

  // get -- non-consuming
  const char* fullstring()const	{return _cmd;}
  const char* tail()const	{return &_cmd[_cnt];}
  char	      peek()const	{return _cmd[_cnt];}

  // control
  CS&	      reset(int c=0)	{_cnt=c; _ok=true; return *this;}

  // exception handling (ap_error.cc) non-consuming
  CS&	      check(int, const std::string&);
  CS&	      warn(int, int, const std::string&);
  CS&         warn(int i, const std::string& s)	{return warn(i,cursor(), s);}

  // string matching (ap_match.cc) possibly consuming
  CS&	      pmatch(const std::string&);
  CS&	      pscan(const std::string&);

  // character tests - non-consuming
  bool	      match(char c)const{return (_cmd[_cnt]==c);}
  bool	      match1(const std::string& c)const
			{return _cmd[_cnt]&&strchr(c.c_str(),_cmd[_cnt]);}
  bool	      is_xdigit()const
		{untested(); return (match1("0123456789abcdefABCDEF"));}
  bool	      is_digit()const	{return (match1("0123456789"));}
  bool	      is_pfloat()const	{return (match1(".0123456789"));}
  bool	      is_float()const	{return (match1("+-.0123456789"));}
  bool	      is_argsym()const	{return (match1("*?$%_&@"));}
  bool	      is_alpha()const	{return !!isalpha(toascii(_cmd[_cnt]));}
  bool	      is_term(const std::string& t = ",=()[]")
	{char c=peek(); return (c=='\0' || isspace(c) || match1(t));}

  // get (ap_get.cc) consuming if match
  CS&         set(const std::string&, bool*, bool);
  CS&         set(const std::string&, int*, int);
  CS&         get(const std::string&, bool*, AP_MOD=mNONE);
  CS&         get(const std::string&, int*, AP_MOD=mNONE, int=0);
  CS&         get(const std::string&, double*, AP_MOD=mNONE, double=0);
  CS&         get(const std::string&, double*, double*);

  // conversions (ap_convert.cc) always consuming
  char	      ctoc()			{return _cmd[_cnt++];}
  double      ctof();					// ap_ctof.cc
  int	      ctoi();					// ap_ctoi.cc
  unsigned    ctou();
  int	      ctoo();
  int	      ctox();
  void        ctostr(char*,int,const std::string&);	// ap_ctos.cc
  std::string ctos(const std::string&);
  double      ctopf()			{return fabs(ctof());}
  CS&         operator>>(int&x)		{x=ctoi();return *this;}
  CS&         operator>>(unsigned&x)	{untested(); x=ctou();return *this;}
  CS&         operator>>(double&x)	{x=ctof();return *this;}

  // skip (ap_skip.cc) always consuming
  CS&	      skip(int c=1)	{_cnt+=c; _ok=_cnt<=_length; return *this;}
  CS&	      skipbl();
  CS&	      skip1b(const std::string&);
  CS&	      skip1(const std::string&);
  CS&	      skiparg();
  CS&	      skipto(const std::string&);
  CS&	      skipto(char);
  CS&	      skipcom()		{return skip1b(",=");}
  CS&	      skiplparen()	{return skip1b("([");}
  CS&	      skiprparen()	{return skip1b(")]");}
  CS&	      skipequal()	{return skip1b("=");}
};	
/*--------------------------------------------------------------------------*/
template <class T>
inline bool set(T* val, T newval) {*val = newval; return true;}
/*--------------------------------------------------------------------------*/
template <class T>
inline CS& set(CS& cmd, const std::string& key, T* val, T newval)
{
  if (cmd.pmatch(key)){
    *val = newval;
  }
  return cmd;
}    
/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/
#endif
