//  UPixmapCache.cpp version 1.5
//  yudit package - Unicode Editor for the X Window System (and Linux) 
//
//  Author: gsinai@iname.com (Gaspar Sinai)
//  GNU Copyright (C) 1997,1998,1999  Gaspar Sinai
// 
//  yudit version 1.5  Copyright(C) 30 November, 1999, Tokyo Japan  Gaspar Sinai
//  yudit version 1.4  Copyright(C) 25 November, 1999, Tokyo Japan  Gaspar Sinai
//  yudit version 1.3  Copyright(C)  5 April,    1999, Tokyo Japan  Gaspar Sinai
//  yudit version 1.2  Copyright(C) 10 December, 1998, Tokyo Japan  Gaspar Sinai
//  yudit version 1.1  Copyright(C) 23 August,   1998, Tokyo Japan  Gaspar Sinai
//  yudit version 1.0  Copyright(C) 17 May,      1998, Tokyo Japan  Gaspar Sinai
//  yudit version 0.99 Copyright(C)  4 April,    1998, Tokyo Japan  Gaspar Sinai
//  yudit version 0.97 Copyright(C)  4 February, 1998, Tokyo Japan  Gaspar Sinai
//  yudit version 0.95 Copyright(C) 10 January,  1998, Tokyo Japan  Gaspar Sinai
//  yudit version 0.94 Copyright(C) 17 December, 1997, Tokyo Japan  Gaspar Sinai
//  yudit version 0.9 Copyright (C)  8 December, 1997, Tokyo Japan  Gaspar Sinai
//  yutex version 0.8 Copyright (C)  5 November, 1997, Tokyo Japan  Gaspar Sinai
//
//  This program is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 2 of the License, or
//  (at your option) any later version.
//
//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with this program; if not, write to the Free Software
//  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
//

#include "UPixmapCache.h"
#include <memory.h>
#include "UCommon.h"

UPixmapCache::UPixmapCache(Display* displayIn, Window win, GC gcIn, GC gcRin, 
	int depthIn)
{
	XGCValues	gcv;
	uPixmaps[0]=0;
	uPixmapArraySize[0]=0;
	uPixmaps[1]=0;
	uPixmapArraySize[1]=0;
	uDisplay = displayIn;
	uDepth = depthIn;
	normalGC = gcIn;
	reverseGC = gcRin;
	gcs[0] = XCreateGC (uDisplay, win, 0, &gcv);
	gcs[1] = XCreateGC (uDisplay, win, 0, &gcv);
	XCopyGC (uDisplay, normalGC, GCForeground | GCBackground, gcs[0]);
	XCopyGC (uDisplay, reverseGC, GCForeground | GCBackground, gcs[1]);
}

void
UPixmapCache::clear ()
{
	int	i;

	if (uPixmapArraySize[0]!=0)
	{ 
		for (i=0; i<uPixmapArraySize[0]; i++)
		{
			if (uPixmaps[0][i]!=0) 
				XFreePixmap (uDisplay, uPixmaps[0][i]);
		}
		delete uPixmaps[0];
		uPixmaps[0] = 0;
		uPixmapArraySize[0] = 0;
	}
	if (uPixmapArraySize[1]!=0)
	{ 
		for (i=0; i<uPixmapArraySize[1]; i++)
		{
			if (uPixmaps[1][i]!=0) 
				XFreePixmap (uDisplay, uPixmaps[1][i]);
		}
		delete uPixmaps[1];
		uPixmaps[1] = 0;
		uPixmapArraySize[1] = 0;
	}
	XCopyGC (uDisplay, normalGC, 
		GCForeground | GCBackground, gcs[0] );
	XCopyGC (uDisplay, reverseGC, 
		GCForeground | GCBackground,  gcs[1]);
}

void
UPixmapCache::grow(int sizeIn, int index)
{
	Pixmap*		newPixmaps;
	int		newArraySize;

	if (uPixmapArraySize[index]>sizeIn) return;
	newArraySize = (sizeIn==0) ? 1 : sizeIn <<1;
	newPixmaps = new Pixmap[newArraySize];
	CHECKNULL (newPixmaps);
	memset (newPixmaps, 0, newArraySize * sizeof (Pixmap));

	if (uPixmapArraySize[index]!=0)
	{
		memcpy (newPixmaps, uPixmaps[index], 
			uPixmapArraySize[index] * sizeof (Pixmap));
	}
	if (uPixmaps[index]!=0) delete uPixmaps[index];
	uPixmapArraySize[index] = newArraySize;
	uPixmaps[index] = newPixmaps;
	cludgeSGC();
}

void
UPixmapCache::cludgeSGC()
{
	if (uDepth==2) uDepth=2;
}

Pixmap
UPixmapCache::get (Pixmap pixmapIn, int indexIn, GC gc, int width, int height)
{
        int             xScreen;
        Window          xRootWindow;
	int		which;
	
	which = (gc == normalGC) ? 0 : 1;
	if (indexIn<uPixmapArraySize[which] &&  uPixmaps[which][indexIn] != 0)
	{
		return uPixmaps[which][indexIn];
	}
	xScreen = DefaultScreen  (uDisplay);
	xRootWindow = XRootWindow (uDisplay, xScreen);
	grow (indexIn, which);
	uPixmaps[which][indexIn] = 
		XCreatePixmap (uDisplay, xRootWindow, width, height, uDepth);
	XCopyPlane (uDisplay, pixmapIn, uPixmaps[which][indexIn], gcs[which],
		0, 0, width, height, 0, 0, 1);
	return uPixmaps[which][indexIn];
	
}

UPixmapCache::~UPixmapCache()
{
	
 	clear ();
	XFreeGC (uDisplay, gcs[0]);
	XFreeGC (uDisplay, gcs[1]);
}
