//  UFreeType.cpp version 1.5
//  yudit package - Unicode Editor for the X Window System (and Linux) 
//
//  Author: gsinai@iname.com (Gaspar Sinai)
//  GNU Copyright (C) 1997,1998,1999  Gaspar Sinai
// 
//  yudit version 1.5  Copyright(C) 30 November, 1999, Tokyo Japan  Gaspar Sinai
//  yudit version 1.4  Copyright(C) 25 November, 1999, Tokyo Japan  Gaspar Sinai
//  yudit version 1.3  Copyright(C)  5 April,    1999, Tokyo Japan  Gaspar Sinai
//  yudit version 1.2  Copyright(C) 10 December, 1998, Tokyo Japan  Gaspar Sinai
//  yudit version 1.1  Copyright(C) 23 August,   1998, Tokyo Japan  Gaspar Sinai
//  yudit version 1.0  Copyright(C) 17 May,      1998, Tokyo Japan  Gaspar Sinai
//  yudit version 0.99 Copyright(C)  4 April,    1998, Tokyo Japan  Gaspar Sinai
//  yudit version 0.97 Copyright(C)  4 February, 1998, Tokyo Japan  Gaspar Sinai
//  yudit version 0.95 Copyright(C) 10 January,  1998, Tokyo Japan  Gaspar Sinai
//  yudit version 0.94 Copyright(C) 17 December, 1997, Tokyo Japan  Gaspar Sinai
//  yudit version 0.9 Copyright (C)  8 December, 1997, Tokyo Japan  Gaspar Sinai
//  yutex version 0.8 Copyright (C)  5 November, 1997, Tokyo Japan  Gaspar Sinai
//
//  This program is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 2 of the License, or
//  (at your option) any later version.
//
//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with this program; if not, write to the Free Software
//  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
//


#include <string.h>
#include "UCommon.h"
#include "UFreeType.h"
#include <UCache.h>
#include "UFont.h"

int		UFreeType::initialized = 0;

static          UCache<UFreeType*>* cache=0;

#ifdef FREETYPE
static TT_Engine	engine;
#endif

void
UFreeTypeFace::setFont (const char* nameIn)
{
	fontFileName = new char[strlen (nameIn) + 1];
	CHECKNULL (fontFileName);
	strcpy (fontFileName, nameIn);
	flags = UNINITED;
}

UFreeTypeFace::UFreeTypeFace (void)
{
	flags = EMPTY;
	fontFileName = 0;
}

UFreeTypeFace::~UFreeTypeFace()
{
	if (fontFileName != 0) delete fontFileName;
}


TT_Face*
UFreeTypeFace::getFace()
{
	if (flags==UNINITED)
	{
		openFace();
	}
	if (flags==EMPTY) return 0;

	return &face;
}

TT_Face_Properties*
UFreeTypeFace::getProperty()
{
	if (flags==UNINITED)
	{
		openFace();
	}
	if (flags==EMPTY) return 0;

	return &properties;
}

void 
UFreeTypeFace::openFace ()
{
	int		cmapCount;
	int		i;
	unsigned short	platform;
	unsigned short	encoding;
#ifndef FREETYPE
	flags=EMPTY; return;
#else
	if (TT_Open_Face (engine, fontFileName, &face))
	{
		cerr << "warn: can not open font " << fontFileName << ".\n";
		flags=EMPTY; return;
	}
	TT_Get_Face_Properties (face, &properties);
	cmapCount = TT_Get_CharMap_Count (face);
	flags=EMPTY; 
	for (i=0; i<cmapCount; i++)
	{
		TT_Get_CharMap_ID (face, i, &platform, &encoding);
		if ((platform == 3 && encoding == 1 )
			|| (platform == 0 && encoding == 0))
		{
			TT_Get_CharMap (face, i, &charMap);
			flags=INITED;
			break;
		}
		
	}
	if (flags==EMPTY)
	{
		cerr << "warn: font '" << fontFileName
			<< "' has no unicode map.\n";
	}
	return;
#endif
}

UFreeType::UStatus
UFreeType::setFontFile (const char* fileNameIn, UWeight weight, USlant slant)
{
	char*	fileFound;
	char*	completeFile;

	completeFile = new char[strlen(fileNameIn) +5];
	CHECKNULL (completeFile);
	strcpy (completeFile, fileNameIn);
	strcat (completeFile, ".ttf");
	// Check for file...
	if ((fileFound=UFindFile (UGetMapPath(), completeFile)) == 0)
	{
		cerr << "error: TrueType font file '" <<
			completeFile << "' not found on path.\n";
		delete completeFile;
		return UFreeType::ERROR;
	}
	freeTypeFace[weight][slant].setFont (fileFound);
	delete fileFound;
	delete completeFile;
	return OK;
}

const char*
UFreeType::getFileName (UWeight weight, USlant slant) const
{
	return freeTypeFace[weight][slant].getName();
}

int
UFreeTypeFace::getCharIndex (const UCS2 ucs2)
{
	UCS2	myucs2;
#if FREETYPE
	myucs2 = ucs2;
	return (int) TT_Char_Index (charMap, (short) ucs2);
#else
	return -1;
#endif
}

UFreeType::UFreeType (const char* nameIn)
{
	myName = new char[strlen (nameIn) + 1];
	CHECKNULL (myName);
	strcpy (myName, nameIn);

	initialized = 0;

#ifdef FREETYPE
	if (initialized == 0)
	{
		if (TT_Init_FreeType(&engine))
		{
			cerr << "error: can not initialize FreeType fonts.\n";
			initialized = -1;
		}
		else
		{
			initialized = 1;
		}
	}
#endif
}

UFreeType::UWeight
UFreeType::freeTypeWeight (int weightIn) // UFont::Weight
{
	switch (weightIn)
	{
	case UFont::ANYWEIGHT:
	case UFont::REGULAR:
	case UFont::MEDIUM:
		return MEDIUM;

	case UFont::DEMIBOLD:
	case UFont::BOLD:
		return BOLD;
	}
	return MEDIUM;
}

UFreeType::USlant
UFreeType::freeTypeSlant (int slantIn) // UFont::slant
{
	switch (slantIn)
	{
	case UFont::ROMAN:
		return ROMAN;
	case UFont::ITALIC:
	case UFont::OBLIQUE:
		return ITALIC;
	}
	return ROMAN;
}

UFreeType::~UFreeType()
{
	if (myName!=0) delete myName;
}

UFreeType::UStatus
UAddFreeType (const char* nameIn)
{
	UFreeType		*xFreeType;

	if (cache == 0)
	{
		cache = new UCache<UFreeType*>;
		CHECKNULL (cache);
	}
	xFreeType = cache->getItem (nameIn);
	if (xFreeType==0)
	{
		xFreeType = new UFreeType (nameIn);
		CHECKNULL (xFreeType);
	}
	cache->addItem (nameIn, xFreeType);
	return UFreeType::OK;
}

UFreeType*
UGetFreeType (const char *nameIn)
{
	if (cache == 0) return 0;
#ifdef FREETYPE
	return cache->getItem (nameIn);
#else
	return 0;
#endif
}

//
// Printer does not need freetype support
//
UFreeType*
UGetFreeTypePrint (const char *nameIn)
{
	if (cache == 0) return 0;
	return cache->getItem (nameIn);
}

UFreeType::UStatus
UDeleteReeType (const char *nameIn)
{
	cache->unuseItem (nameIn);
	return UFreeType::OK;
}
