//  UTop.cpp version 1.5
//  yudit package - Unicode Editor for the X Window System (and Linux) 
//
//  Author: gsinai@iname.com (Gaspar Sinai)
//  GNU Copyright (C) 1997,1998,1999  Gaspar Sinai
// 
//  yudit version 1.5  Copyright(C) 30 November, 1999, Tokyo Japan  Gaspar Sinai
//  yudit version 1.4  Copyright(C) 25 November, 1999, Tokyo Japan  Gaspar Sinai
//  yudit version 1.3  Copyright(C)  5 April,    1999, Tokyo Japan  Gaspar Sinai
//  yudit version 1.2  Copyright(C) 10 December, 1998, Tokyo Japan  Gaspar Sinai
//  yudit version 1.1  Copyright(C) 23 August,   1998, Tokyo Japan  Gaspar Sinai
//  yudit version 1.0  Copyright(C) 17 May,      1998, Tokyo Japan  Gaspar Sinai
//  yudit version 0.99 Copyright(C)  4 April,    1998, Tokyo Japan  Gaspar Sinai
//  yudit version 0.97 Copyright(C)  4 February, 1998, Tokyo Japan  Gaspar Sinai
//  yudit version 0.95 Copyright(C) 10 January,  1998, Tokyo Japan  Gaspar Sinai
//  yudit version 0.94 Copyright(C) 17 December, 1997, Tokyo Japan  Gaspar Sinai
//  yudit version 0.9 Copyright (C)  8 December, 1997, Tokyo Japan  Gaspar Sinai
//  yutex version 0.8 Copyright (C)  5 November, 1997, Tokyo Japan  Gaspar Sinai
//
//  This program is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 2 of the License, or
//  (at your option) any later version.
//
//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with this program; if not, write to the Free Software
//  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
//
//
// The top object that is attached to the display and screen.
//

#include <iostream.h>
#include "UTop.h"
#include "UTextMenu.h"
#include <sys/types.h>
#include <sys/time.h>

UTop::UTop (void)
{
	init ();
}

UTop::~UTop()
{
	if (display!=0)
	{
		if (clipOwner!=None)
		{
			XSetSelectionOwner (display, XA_PRIMARY, None, 
				CurrentTime);
		}
		if (clipBuffer) delete clipBuffer;
		XCloseDisplay (display);
	}
}

void
UTop::init()
{
	display = XOpenDisplay (0);
	if (display == 0)
	{
		cerr << "error: XOpenDisplay\n";
		return;
	}
	screen = DefaultScreen (display);
	root = RootWindow (display, screen);
	border= 0;
	background = WhitePixel (display, screen);
	foreground = BlackPixel (display, screen);
	rectangle.x = 0;
	rectangle.y = 0;
	rectangle.width = 400;
	rectangle.height = 300;
	wmProtocols = XInternAtom (display, "WM_PROTOCOLS", False);
	wmDeleteWindow = XInternAtom (display, "WM_DELETE_WINDOW", False);
}

void
UTop::addComponent (UComponent *shell_)
{
	component.addItem ((unsigned long) shell_->window, (void*) shell_);
}

UComponent*
UTop::findComponent (Window w)
{
	return (UComponent*) (component.findItem ((unsigned long) w));
}

void
UTop::deleteComponent (UComponent *shell_)
{
	if (shell_->window==clipOwner) clipOwner =None;
	component.deleteItem ((unsigned long) shell_->window);
}

void
UTop::addShell (UComponent *shell_)
{
	shell.addItem ((unsigned long) shell_->window, (void*) shell_);
}

void
UTop::deleteShell (UComponent *shell_)
{
	shell.deleteItem ((unsigned long) shell_->window);
}

void
UTop::addEventHandler (UEventHandler* handler, unsigned long mask)
{
	eventHandler.addItem (mask, handler);
}

void
UTop::removeEventHandler (UEventHandler* handler, unsigned long mask)
{
	eventHandler.deleteItem (mask, handler);
}

const unsigned char*
UTop::getClipboard (Window requestor, int* len)
{

	Window		owner;
	Atom		compound;
	Atom		utftext;

	if (clipOwner==(owner=XGetSelectionOwner (display, XA_PRIMARY)))
	{
		if (len!=0) *len = clipLength;
		return clipBuffer;
	}
	if (clipBuffer) delete clipBuffer;
	clipBuffer = 0;
	clipLength = 0;
	clipOwner = None;


	utftext = XInternAtom (display, "UTF8_TEXT", False);

	// Try both.
	getClipboard (utftext, requestor, len);
	if (clipBuffer != 0) return clipBuffer;

	compound = XInternAtom (display, "COMPOUND_TEXT", False);

	getClipboard (compound, requestor, len);
	if (clipBuffer != 0) return clipBuffer;

	getClipboard (XA_STRING, requestor, len);
	return clipBuffer;
}

const unsigned char*
UTop::getClipboard (Atom textType, Window requestor, int* len)
{
	XEvent		xevent;

	time_t		now;
	time_t		start;
	int		count;
	Atom		propty;
	int		propformat;
	unsigned long 	propsize;
	unsigned long 	rest;
	unsigned char*	propvalue;
	Atom		proptype;
	unsigned char*	buffer;

	propty = XInternAtom (display, "YUDIT_SELECTION", False);

	XConvertSelection( display, XA_PRIMARY, textType, 
		propty, requestor, CurrentTime );

	// This is a bug... I dont know why but propty gets wrong
        // in the routine above on X11R5.
	propty = XInternAtom (display, "YUDIT_SELECTION", False);

	XFlush (display);
	start = time (0);
	for (now=start; now-start<8; now=time(0))
	{
		if (XCheckTypedWindowEvent(display, requestor,
			SelectionNotify, &xevent)) break;
	}
	if (now-start>=8)
	{
		cerr << "warn: clipboard timeout.\n";
		return 0;
	}

	count = 0;
	// Read the propty from the selection window
	while (Success==XGetWindowProperty (display, 
			xevent.xselection.requestor, 
			propty,
			count, 100000L, True, AnyPropertyType,
			&proptype,  &propformat, &propsize, &rest, &propvalue))
	{
		if (propvalue==0) break;
		if ((proptype != textType) || propsize==0 || propformat !=8)
		{
			XFree (propvalue);
			break;
		}
		buffer = new unsigned char[propsize+count+4];
		if (count)
		{
			memcpy (buffer, clipBuffer, count);
			delete clipBuffer;
		}
		clipBuffer = buffer;
		memcpy (&clipBuffer[count], propvalue, propsize);
		XFree (propvalue);
		count += propsize;
		if (rest==0) break;
	}
	if (clipBuffer)
	{
		clipBuffer[count] = 0;
	}
	if (len !=0) *len = count;
	return clipBuffer;
}

void
UTop::putClipboard (Window win, const unsigned char*in_, int len)
{
	UComponent*	comp;
	if (clipOwner != win && clipOwner != None)
	{
		comp = findComponent (clipOwner);
		if (comp) comp->clearSelection();
	}
	XSetSelectionOwner (display, XA_PRIMARY, win, CurrentTime);
	if (XGetSelectionOwner (display, XA_PRIMARY) != win)
	{
		// Oops
		clipOwner = None;
		return;
	}
	clipOwner = win;
	if (clipBuffer) delete clipBuffer;
	clipBuffer = new unsigned char [len+4];
	memcpy (clipBuffer, in_, len);
	clipLength = len;
	clipBuffer[len] = 0;
}

void
UTop::clipEvent (XEvent* event)
{
	UComponent* 			comp;
	XEvent				xevent;
	XSelectionRequestEvent&		sel=event->xselectionrequest;
	Atom				compound;
	Atom				utftext;
	Atom				text;

	switch (event->type)
	{
	case SelectionClear:
		comp = findComponent (clipOwner);
		if (comp) comp->clearSelection();
		clipOwner = None;
		return;
	case SelectionNotify:
		clipOwner = None;
		return;
	case SelectionRequest:
		compound = XInternAtom (display, "COMPOUND_TEXT", False);
		utftext = XInternAtom (display, "UTF8_TEXT", False);
		text = XInternAtom (display, "TEXT", False);
		if (sel.target == XA_STRING 
			|| sel.target == compound
			|| sel.target == utftext
			|| sel.target == text)
		{
			XChangeProperty (sel.display, 
					sel.requestor, sel.property,
					compound, 8, PropModeReplace,
					clipBuffer, clipLength);
		}
		xevent.xselection.type = SelectionNotify;
		xevent.xselection.display = sel.display;
		xevent.xselection.requestor = sel.requestor;
		xevent.xselection.selection = sel.selection;
		xevent.xselection.target = sel.target;
		xevent.xselection.time = sel.time;
		xevent.xselection.property = sel.property;
		XSendEvent (sel.display, sel.requestor, False, 0, &xevent);
		return;
	default:
		break;
	}
}
