/************************************************************************/
/*  Scan, main module.							*/
/************************************************************************/

#   include	"config.h"

#   include	<stddef.h>
#   include	<stdio.h>
#   include	<stdlib.h>

#   include	<X11/Xlib.h>

#   include	<sioXprop.h>
#   include	<appImage.h>

#   include	<debugon.h>

/********************************************************************************/
/*										*/
/*  get the image from the clipboard that 'xv' simulates on the root window.	*/
/*										*/
/********************************************************************************/

static Atom	XA_XV_CLIPBOARD= None;

int appImgGetXvClipboard(	BitmapDescription *	bd,
				unsigned char **	pBuffer,
				Display *		display,
				int			screen )
    {
    Window		root= XRootWindow( display, screen );

    SimpleInputStream *	sis;

    int			done;

    if  ( XA_XV_CLIPBOARD == None )
	{
	XA_XV_CLIPBOARD= XInternAtom( display, "XV_CLIPBOARD", False );
	if  ( XA_XV_CLIPBOARD == None )
	    { XDEB(XA_XV_CLIPBOARD); return -1;	}
	}

    sis= sioInXpropOpen( display, root, XA_XV_CLIPBOARD );
    if  ( ! sis )
	{ XDEB(sis); return -1;	}

    done= bmXvReadPaste( bd, pBuffer, sis );

    sioInClose( sis );

    if  ( done < 0 )
	{ LDEB(done); return -1;	}

    return 0;
    }

int appImgPutXvClipboard(	const BitmapDescription *	bd,
				const unsigned char *		buffer,
				Display *			display,
				int				screen )
    {
    Window			root= XRootWindow( display, screen );

    SimpleOutputStream *	sos;

    int				done;

    if  ( XA_XV_CLIPBOARD == None )
	{
	XA_XV_CLIPBOARD= XInternAtom( display, "XV_CLIPBOARD", False );
	if  ( XA_XV_CLIPBOARD == None )
	    { XDEB(XA_XV_CLIPBOARD); return -1;	}
	}

    sos= sioOutXpropOpen( display, root, XA_XV_CLIPBOARD, XA_STRING );
    if  ( ! sos )
	{ XDEB(sos); return -1;	}

    done= bmXvWritePaste( bd, buffer, sos );

    sioOutClose( sos );

    if  ( done < 0 )
	{ LDEB(done); return -1;	}

    return 0;
    }
