/************************************************************************/
/*  Really Quit, Really Close dialogs.					*/
/************************************************************************/

#   include	"config.h"

#   include	<stddef.h>
#   include	<stdio.h>
#   include	<stdlib.h>

#   include	<Xm/Xm.h>
#   include	<Xm/MainW.h>
#   include	<Xm/Form.h>
#   include	<Xm/Label.h>

#   include	<Xm/Protocols.h>
#   include	<Xm/MwmUtil.h>

#   include	"appUtil.h"
#   include	<appFrame.h>

#   include	<debugon.h>

/************************************************************************/
/*  Run a 'Really Close' dialog.					*/
/************************************************************************/

void appRunReallyCloseDialog(	Widget				option,
				EditApplication *		ea,
				EditDocument *			ed,
				XtPointer			call_data )
    {
    int				rcc;

    AppFileMessageResources *	afmr= &(ea->eaFileMessageResources);

    rcc= appQuestionRunSubjectYesNoCancelDialog( ea,
						ed->edTopWidget,
						option,
						ed->edTitle,
						afmr->afmrReallyCloseQuestion,
						afmr->afmrReallyCloseSaveIt,
						afmr->afmrReallyCloseDontSave,
						afmr->afmrReallyCloseCancel );

    switch( rcc )
	{
	case AQDrespYES:
	    if  ( ! ea->eaSaveDocument )
		{ XDEB(ea->eaSaveDocument); return;	}

	    if  ( ! ed->edFilename )
		{ appDocFileSaveAs( option, (void *)ed, call_data ); }
	    else{
		if  ( (*ea->eaSaveDocument)( ea, ed,
					    ed->edFormat, ed->edFilename ) )
		    {
		    appReportSaveFailure( ea, option,
					    ed->edTopWidget, ed->edFilename );
		    }
		else{ appDocumentChanged( ea, ed, 0 ); }
		}

	    if  ( ! ed->edHasBeenChanged )
		{ appCloseDocument( ea, ed );	}
	    break;
	case AQDrespNO:
	    appCloseDocument( ea, ed );
	    break;
	case AQDrespCANCEL:
	    break;
	default:
	    LDEB(rcc); break;
	}

    return;
    }

/************************************************************************/
/*  Run a 'Really Quit' dialog.					*/
/************************************************************************/

int appRunReallyQuitDialog(	Widget				option,
				Widget				relative,
				EditApplication *		ea,
				XtPointer			call_data )
    {
    AppFileMessageResources *	afmr= &(ea->eaFileMessageResources);

    return appQuestionRunYesNoCancelDialog( ea,
					relative,
					option,
					afmr->afmrReallyQuitQuestion,
					afmr->afmrReallyQuitReview,
					afmr->afmrReallyQuitAnyway,
					afmr->afmrReallyQuitCancel );
    }
