/************************************************************************/
/*									*/
/*  A find/replace tool.						*/
/*									*/
/************************************************************************/

#   include	"config.h"

#   include	<stdlib.h>
#   include	<stdio.h>
#   include	<debugon.h>

#   include	<X11/Xatom.h>
#   include	<X11/IntrinsicP.h>
#   include	<Xm/Text.h>
#   include	<Xm/MainW.h>
#   include	<Xm/Form.h>
#   include	<Xm/Label.h>
#   include	<Xm/Frame.h>
#   include	<Xm/List.h>
#   include	<Xm/ScrolledW.h>
#   include	<Xm/Label.h>
#   include	<Xm/RowColumn.h>
#   include	<Xm/DialogS.h>
#   include	<Xm/PanedW.h>

#   include	<Xm/MwmUtil.h>

#   include	<Xm/Protocols.h>


#   include	"appFindTool.h"
#   include	"appFrame.h"
#   include	"appUtil.h"

/************************************************************************/
/*  Represents a find tool.						*/
/************************************************************************/
#   define	FILEL	400

typedef struct AppFindToolResources
    {
    char *	aftrFindTitle;
    char *	aftrFindNext;
    char *	aftrFindPrevious;

    char *	aftrReplaceTitle;
    char *	aftrReplaceFound;
    char *	aftrReplaceNext;
    } AppFindToolResources;

typedef struct AppFindTool
    {
    Widget			aftTopWidget;
    Widget			aftMainWidget;

    Widget			aftPatternText;
    Widget			aftReplaceText;
    Widget			aftReplaceFrame;

    Widget			aftReplaceButton;
    Widget			aftReplaceNextButton;
    Widget			aftFindNextButton;
    Widget			aftFindPrevButton;

    AppToolDestroy		aftDestroy;
    FindToolFind		aftFindNext;
    FindToolFind		aftFindPrev;
    FindToolReplace		aftReplace;

    void *			aftTarget;

    int				aftVisible;
    int				aftLastFindResult;
    } AppFindTool;

/************************************************************************/
/*									*/
/*  Turn buttons on and off depending on the situation.			*/
/*									*/
/************************************************************************/

static void appFindToolReflectPatternText(	AppFindTool *	aft )
    {
    Boolean	sensitive;
    char *	pattern;

    pattern= XmTextGetString( aft->aftPatternText );

    sensitive= pattern[0] != '\0';

    XtFree( pattern );

    XtSetSensitive( aft->aftFindNextButton, sensitive );
    XtSetSensitive( aft->aftFindPrevButton, sensitive );

    return;
    }

static void appFindToolReflectReplaceText(	AppFindTool *	aft )
    {
    Boolean	sensitive;
    char *	replacement;

    replacement= XmTextGetString( aft->aftReplaceText );

    sensitive= replacement[0] != '\0' && aft->aftLastFindResult == 0;

    XtFree( replacement );

    XtSetSensitive( aft->aftReplaceButton, sensitive );
    XtSetSensitive( aft->aftReplaceNextButton, sensitive );

    return;
    }

static void appFindToolSetFindResult(	AppFindTool *	aft,
					int		result )
    {
    Boolean	sensitive;

    aft->aftLastFindResult= result;

    if  ( result )
	{ sensitive= False;	}
    else{
	char *	replacement;

	replacement= XmTextGetString( aft->aftReplaceText );

	sensitive= replacement[0] != '\0';

	XtFree( replacement );
	}

    XtSetSensitive( aft->aftReplaceButton, sensitive );
    XtSetSensitive( aft->aftReplaceNextButton, sensitive );

    return;
    }

static void appFindToolPatternChanged(	Widget		w,
					XtPointer	voidaft,
					XtPointer	call_data )
    {
    AppFindTool *	aft= (AppFindTool *)voidaft;

    appFindToolReflectPatternText( aft );

    return;
    }

static void appFindToolReplacementChanged(	Widget		w,
						XtPointer	voidaft,
						XtPointer	call_data )
    {
    AppFindTool *	aft= (AppFindTool *)voidaft;

    appFindToolReflectReplaceText( aft );

    return;
    }

/************************************************************************/
/*									*/
/*  'Find' button has been pushed.					*/
/*									*/
/************************************************************************/

static int appFindToolGetProgram(	regProg **	pProg,
					AppFindTool *	aft )
    {
    char *		pattern;
    regProg *		prog;

    pattern= XmTextGetString( aft->aftPatternText );

    prog= regCompile( (const unsigned char *)pattern );
    if  ( ! prog )
	{ SXDEB(pattern,prog); XtFree( pattern ); return -1; }

    XtFree( pattern );

    *pProg= prog; return 0;
    }

static void appFindToolFindNext(	Widget		w,
					XtPointer	voidaft,
					XtPointer	voidpbcs	 )
    {
    AppFindTool *	aft= (AppFindTool *)voidaft;
    regProg *		prog;
    int			result;

    if  ( ! aft->aftFindNext )
	{
	XDEB(aft->aftFindNext);
	appFindToolSetFindResult( aft, -1 ); return;
	}

    if  ( appFindToolGetProgram( &prog, aft ) )
	{ appFindToolSetFindResult( aft, -1 ); return; }

    result= (*aft->aftFindNext)( aft->aftTarget, prog );
    appFindToolSetFindResult( aft, result );

    free( prog );

    return;
    }

static void appFindToolFindPrev(	Widget		w,
					XtPointer	voidaft,
					XtPointer	voidpbcs	 )
    {
    AppFindTool *	aft= (AppFindTool *)voidaft;
    regProg *		prog;
    int			result;

    if  ( ! aft->aftFindPrev )
	{
	XDEB(aft->aftFindPrev);
	appFindToolSetFindResult( aft, -1 ); return;
	}

    if  ( appFindToolGetProgram( &prog, aft ) )
	{ appFindToolSetFindResult( aft, -1 ); return; }

    result= (*aft->aftFindPrev)( aft->aftTarget, prog );
    appFindToolSetFindResult( aft, result );

    free( prog );

    return;
    }

/************************************************************************/
/*									*/
/*  'Replace' button has been pushed.					*/
/*									*/
/************************************************************************/

static void appFindToolReplaceSelection(	Widget		w,
						XtPointer	voidaft,
						XtPointer	voidpbcs  )
    {
    AppFindTool *	aft= (AppFindTool *)voidaft;
    char *		replacement;

    if  ( ! aft->aftReplace )
	{ XDEB(aft->aftReplace); return;	}

    replacement= XmTextGetString( aft->aftReplaceText );

    (*aft->aftReplace)( aft->aftTarget, (const unsigned char *)replacement );

    XtFree( replacement );

    XtSetSensitive( aft->aftReplaceButton, False );

    return;
    }

static void appFindToolReplaceNext(	Widget		w,
					XtPointer	voidaft,
					XtPointer	voidpbcs  )
    {
    appFindToolReplaceSelection( w, voidaft, voidpbcs );

    appFindToolFindNext( w, voidaft, voidpbcs );

    return;
    }

/************************************************************************/
/*									*/
/*  Make a row of buttons for the Find Tool.				*/
/*									*/
/************************************************************************/

static void appFindToolMakeButtonRow(	Widget *	pLeftButton,
					Widget *	pRightButton,
					char *		leftLabel,
					char *		rightLabel,
					XtCallbackProc	leftCallback,
					XtCallbackProc	rightCallback,
					AppFindTool *	aft,
					Widget		bboard,
					Widget		parent )

    {
    Widget		row;

    Widget		leftButton;
    Widget		rightButton;

    row= appMakeButtonRow( parent, 2 );

    /***************/

    leftButton= appMakeRowButton( row, leftLabel, leftCallback, (void *)aft,
								0, False );
    rightButton= appMakeRowButton( row, rightLabel, rightCallback, (void *)aft,
								1, False );

    /***************/

    XtVaSetValues( bboard,
			XmNdefaultButton,	leftButton,
			NULL );


    XtManageChild( leftButton );
    XtManageChild( rightButton );

    XtManageChild( row );

    *pLeftButton= leftButton, *pRightButton= rightButton; return;
    }

/************************************************************************/
/*									*/
/*  Make the button part of the find Tool.				*/
/*									*/
/************************************************************************/

static Widget appFindMakeFindFrame(	Widget			parent,
					Display *		display,
					AppFindToolResources *	aftr,
					AppFindTool *		aft 	)
    {
    Widget		frame;
    Widget		bboard;
    Widget		paned;

    appMakeVerticalFrame( &frame, &bboard, &paned, parent,
							aftr->aftrFindTitle );

    appMakeColumnText( &(aft->aftPatternText), paned, 0, True );

    XtAddCallback( aft->aftPatternText, XmNvalueChangedCallback,
				    appFindToolPatternChanged, (void *)aft );

    XtVaSetValues( bboard,
			XmNinitialFocus,	aft->aftPatternText,
			NULL );

    /***************/

    appFindToolMakeButtonRow(
		&(aft->aftFindNextButton), &(aft->aftFindPrevButton),
		aftr->aftrFindNext, aftr->aftrFindPrevious,
		appFindToolFindNext, appFindToolFindPrev,
		aft, bboard, paned );

    /***************/

    XtManageChild( aft->aftPatternText );
    XtManageChild( paned );
    XtManageChild( bboard );
    XtManageChild( frame );

    return frame;
    }

/************************************************************************/
/*  Make the replace part of the find tool.				*/
/************************************************************************/
static Widget appFindMakeReplaceFrame(	Widget			parent,
					Display *		display,
					AppFindToolResources *	aftr,
					AppFindTool *		aft )
    {
    Widget		frame;
    Widget		bboard;
    Widget		paned;

    appMakeVerticalFrame( &frame, &bboard, &paned,
					    parent, aftr->aftrReplaceTitle );
    aft->aftReplaceFrame= frame;

    appMakeColumnText( &(aft->aftReplaceText), paned, 0, True );

    XtAddCallback( aft->aftReplaceText, XmNvalueChangedCallback,
				appFindToolReplacementChanged, (void *)aft );

    XtVaSetValues( bboard,
			XmNinitialFocus,	aft->aftReplaceText,
			NULL );

    /***************/

    appFindToolMakeButtonRow(
		&(aft->aftReplaceButton), &(aft->aftReplaceNextButton),
		aftr->aftrReplaceFound, aftr->aftrReplaceNext,
		appFindToolReplaceSelection, appFindToolReplaceNext,
		aft, bboard, paned );

    /***************/

    XtManageChild( aft->aftReplaceText );
    XtManageChild( paned );
    XtManageChild( bboard );
    XtManageChild( frame );

    return frame;
    }

/************************************************************************/
/*  A find tool must be destroyed.					*/
/************************************************************************/
static void appCloseFindTool(		Widget		w,
					XtPointer	voidaft,
					XtPointer	voidlcs	 )
    {
    AppFindTool *	aft= (AppFindTool *)voidaft;

    if  ( aft->aftDestroy )
	{ (*aft->aftDestroy)( aft->aftTarget );	}

    XtDestroyWidget( w );

    free( aft );

    return;
    }

/************************************************************************/
/*  make a find tool.							*/
/************************************************************************/
static void appFindToolConfigure(	Widget			w,
					void *			voidaft,
					XEvent *		event,
					Boolean *		pRefused )
    {
    XConfigureEvent *		cevent= &(event->xconfigure);

    if  ( cevent->type != ConfigureNotify )
	{ return;	}

    XtVaSetValues( w,	XmNminHeight,	cevent->height,
			XmNmaxHeight,	cevent->height,
			XmNminWidth,	cevent->width,
			NULL );

    XtRemoveEventHandler( w, StructureNotifyMask, False,
					    appFindToolConfigure, voidaft );

    *pRefused= 1;
    return;
    }

static void appFindToolVisible(		Widget			w,
					void *			voidaft,
					XEvent *		event,
					Boolean *		pRefused )
    {
    AppFindTool *	aft= (AppFindTool *)voidaft;

    if  ( event->type == MapNotify )
	{
	XSetInputFocus( XtDisplay( w ), XtWindow( w ),
						RevertToNone, CurrentTime );
	aft->aftVisible= 1;
	}

    if  ( event->type == UnmapNotify )
	{ aft->aftVisible= 0; }

    *pRefused= 1;
    return;
    }

# define xx(x)  x,x

static XtResource APP_FindToolResourceTable[]=
    {
	{ xx("findToolFindTitle"), XtRString, sizeof(char *),
		    offsetof(AppFindToolResources,aftrFindTitle),
		    XtRString, "Find" },
	{ xx("findToolFindNext"), XtRString, sizeof(char *),
		    offsetof(AppFindToolResources,aftrFindNext),
		    XtRString, "Find" },
	{ xx("findToolFindPrevious"), XtRString, sizeof(char *),
		    offsetof(AppFindToolResources,aftrFindPrevious),
		    XtRString, "Previous" },
	{ xx("findToolReplaceTitle"), XtRString, sizeof(char *),
		    offsetof(AppFindToolResources,aftrReplaceTitle),
		    XtRString, "Replace" },
	{ xx("findToolReplaceFound"), XtRString, sizeof(char *),
		    offsetof(AppFindToolResources,aftrReplaceFound),
		    XtRString, "Replace" },
	{ xx("findToolReplaceNext"), XtRString, sizeof(char *),
		    offsetof(AppFindToolResources,aftrReplaceNext),
		    XtRString, "Replace, Next" },
    };

void * appMakeFindTool(		Widget			findOption,
				Widget			topWidget,
				XtAppContext		appContext,
				const char *		applicationName,
				const char *		widgetName,
				Pixmap			iconPixmap,
				Atom			closeAtom,
				AppToolDestroy		destroy,
				FindToolFind		findNext,
				FindToolFind		findPrev,
				FindToolReplace		replace,
				void *			target		)
    {
    Display *		display= XtDisplay( findOption );
    AppFindTool *	aft;
    
    Arg			al[20];
    int			ac= 0;

    Widget		findFrame;
    Widget		replaceFrame;
    
    MwmHints		hints;

    static AppFindToolResources	aftr;
    static int			gotResources;

    if  ( ! gotResources )
	{
	XtGetApplicationResources( topWidget, (void *)&aftr,
		APP_FindToolResourceTable, XtNumber(APP_FindToolResourceTable),
		NULL, 0 );

	gotResources= 1;
	}

    hints.flags= MWM_HINTS_FUNCTIONS|MWM_HINTS_DECORATIONS;
    hints.functions=	MWM_FUNC_MOVE		|
			MWM_FUNC_RESIZE		|
			MWM_FUNC_MINIMIZE	|
			MWM_FUNC_CLOSE		;
    hints.decorations=	MWM_DECOR_BORDER	|
			MWM_DECOR_RESIZEH	|
			MWM_DECOR_TITLE		|
			MWM_DECOR_MENU		|
			MWM_DECOR_MINIMIZE	;

    aft= (AppFindTool *)malloc( sizeof(AppFindTool) );
    if  ( ! aft )
	{ XDEB(aft); return (void *)0;	}

    aft->aftDestroy= destroy;
    aft->aftFindNext= findNext;
    aft->aftFindPrev= findPrev;
    aft->aftReplace= replace;
    aft->aftTarget= target;
    aft->aftVisible= 0;
    
    ac= 0;
    XtSetArg( al[ac], XmNuserData,		(void *)aft ); ac++;
    XtSetArg( al[ac], XmNdeleteResponse,	XmDO_NOTHING ); ac++;
    XtSetArg( al[ac], XmNmwmDecorations,	hints.decorations ); ac++;
    XtSetArg( al[ac], XmNmwmFunctions,		hints.functions ); ac++;
    XtSetArg( al[ac], XmNkeyboardFocusPolicy,	XmEXPLICIT ); ac++;
    XtSetArg( al[ac], XmNinput,			True ); ac++;

    /* Removes MWM border:
    XtSetArg( al[ac], XmNoverrideRedirect,	True ); ac++;
    */

    if  ( iconPixmap )
	{ XtSetArg( al[ac], XmNiconPixmap,	iconPixmap ); ac++; }

    aft->aftTopWidget= XtAppCreateShell( applicationName,
					    widgetName,
					    applicationShellWidgetClass,
					    display, al, ac );

    appSetShellTitle( aft->aftTopWidget, findOption, applicationName );

    XtAddEventHandler( aft->aftTopWidget, StructureNotifyMask, False,
					appFindToolConfigure, (void *)aft );
    XtAddEventHandler( aft->aftTopWidget, StructureNotifyMask, False,
					appFindToolVisible, (void *)aft );

    if  ( closeAtom > 0 )
	{
	XmAddWMProtocolCallback( aft->aftTopWidget, closeAtom,
					appCloseFindTool, (XtPointer)aft );
	}

    ac= 0;
    XtSetArg( al[ac],	XmNuserData,		(void *)aft ); ac++;
    XtSetArg( al[ac],	XmNsashWidth,		1 ); ac++;
    XtSetArg( al[ac],	XmNsashHeight,		1 ); ac++;
    XtSetArg( al[ac],	XmNseparatorOn,		False ); ac++;
    XtSetArg( al[ac],	XmNmarginWidth,		5 ); ac++;
    XtSetArg( al[ac],	XmNmarginHeight,	5 ); ac++;
    XtSetArg( al[ac],	XmNspacing,		5 ); ac++;
    aft->aftMainWidget= XmCreatePanedWindow( aft->aftTopWidget, WIDGET_NAME, al, ac );

    findFrame= appFindMakeFindFrame( aft->aftMainWidget, display, &aftr, aft );

    replaceFrame= appFindMakeReplaceFrame( aft->aftMainWidget,
							display, &aftr, aft );

    XtManageChild( aft->aftReplaceText );

    XtManageChild( aft->aftMainWidget );

    return (void *)aft;
    }

/************************************************************************/
/*									*/
/*  Draw a find tool to front.						*/
/*									*/
/************************************************************************/

void appShowFindTool(		Widget		reference,
				void *		voidaft	)
    {
    AppFindTool *		aft= (AppFindTool *)voidaft;
    Display *			display= XtDisplay( aft->aftTopWidget );

    Dimension			x;
    Dimension			y;
    Dimension			width;
    Dimension			height;

    if  ( ! aft->aftVisible )
	{
	XtVaGetValues( reference,
			    XmNx,		&x,
			    XmNy,		&y,
			    XmNwidth,		&width,
			    XmNheight,		&height,
			    NULL );

	XtVaSetValues( aft->aftTopWidget,
			    XmNx,		x+ width/10,
			    XmNy,		y+ height/10,
			    NULL );

	XtRealizeWidget( aft->aftTopWidget );
	XtMapWidget( aft->aftTopWidget );
	}
    else{
	Window		win=  XtWindow( aft->aftTopWidget );

	XMapRaised( display, win );
	XSetInputFocus( display, win, RevertToNone, CurrentTime );
	}

    appFindToolSetFindResult( aft, -1 );
    appFindToolReflectPatternText( aft );
    appFindToolReflectReplaceText( aft );

    XmProcessTraversal( aft->aftPatternText, XmTRAVERSE_CURRENT );
    }

void appEnableFindTool(		void *	voidaft,
				int	enabled )
    {
    AppFindTool *	aft= (AppFindTool *)voidaft;

    XtSetSensitive( aft->aftMainWidget, enabled != 0 );

    return;
    }

void appFindToolTextReadonly(		void *	voidaft,
					int	readonly )
    {
    AppFindTool *	aft= (AppFindTool *)voidaft;

    XtSetSensitive( aft->aftReplaceFrame, readonly == 0 );

    return;
    }
