#   ifndef	APP_COLOR_H
#   define	APP_COLOR_H

#   include	<X11/Xlib.h>
#   include	<X11/Intrinsic.h>

/************************************************************************/
/*									*/
/*  Administration on colors.						*/
/*									*/
/************************************************************************/

typedef struct AppColors
    {
    XColor		ac222Colors[64];
    XColor *		acColors;
    int			acColorCount;
    Display *		acDisplay;
    int			acDepth;
    Colormap		acColormap;
    int			acVisualClass;
    unsigned int	acRedApproxShift;
    unsigned int	acGreenApproxShift;
    unsigned int	acBlueApproxShift;
    unsigned int	acRedPixelShift;
    unsigned int	acGreenPixelShift;
    unsigned int	acBluePixelShift;
    unsigned int	acRedMask;
    unsigned int	acGreenMask;
    unsigned int	acBlueMask;
    } AppColors;

/************************************************************************/
/*									*/
/*  Macros for indexing colors in an array of colors, usually in an	*/
/*  AppColors structure.						*/
/*									*/
/************************************************************************/

#   define	C555(r,g,b)	( ( ( (r) << 7 ) & 0x7c00 ) | \
				  ( ( (g) << 2 ) & 0x03e0 ) | \
				  ( ( (b) >> 3 ) & 0x001f ) )

#   define	C332(r,g,b)	( ( ( (r) >> 0 ) & 0xe0 ) | \
				  ( ( (g) >> 3 ) & 0x1c ) | \
				  ( ( (b) >> 6 ) & 0x03 ) )

#   define	C222(r,g,b)	( ( ( (r) >> 2 ) & 0x30 ) | \
				  ( ( (g) >> 4 ) & 0x0c ) | \
				  ( ( (b) >> 6 ) & 0x03 ) )

#   define	C111(r,g,b)	( ( ( (r) >> 5 ) & 0x04 ) | \
				  ( ( (g) >> 6 ) & 0x02 ) | \
				  ( ( (b) >> 7 ) & 0x01 ) )

#   define appColorRgbDirect( xc, ac, r, g, b )			\
    {								\
    unsigned int	rr= (r) >> (ac)->acRedApproxShift;	\
    unsigned int	gg= (g) >> (ac)->acGreenApproxShift;	\
    unsigned int	bb= (b) >> (ac)->acBlueApproxShift;	\
    (xc)->red=   ( 65535* rr )/ (ac)->acRedMask;		\
    (xc)->green= ( 65535* gg )/ (ac)->acGreenMask;		\
    (xc)->blue=  ( 65535* bb )/ (ac)->acBlueMask;		\
    (xc)->pixel= ( rr << (ac)->acRedPixelShift )	+	\
		 ( gg << (ac)->acGreenPixelShift )	+	\
		 ( bb << (ac)->acBluePixelShift )	;	\
    }

/************************************************************************/
/*									*/
/*  Routine declarations.						*/
/*									*/
/************************************************************************/

extern void appInitColors(	AppColors *		ac );

extern int appAllocateColors(	Display *		dis,
				AppColors *		ac );

extern void appCleanColors(	Display *		display,
				AppColors *		ac );

extern int appColorRgb222(	XColor *		xc,
				AppColors *		ac,
				int			r,
				int			g,
				int			b );

extern int appColorRgb111(	XColor *		xc,
				AppColors *		ac,
				int			r,
				int			g,
				int			b );

extern int appColorRgb332(	XColor *		xc,
				AppColors *		ac,
				int			r,
				int			g,
				int			b );

extern int appColorRgb555(	XColor *		xc,
				AppColors *		ac,
				int			r,
				int			g,
				int			b );

extern int appColorRgb(		XColor *		xc,
				AppColors *		ac,
				int			r,
				int			g,
				int			b );

extern int appColorFindRgb(	XColor *		xc,
				AppColors *		ac,
				int			r,
				int			g,
				int			b );

extern int appColorNamed(	XColor *		xc,
				AppColors *		ac,
				char *			name );

#   endif
