/************************************************************************/
/*  Ted: interaction with the page layout tool.				*/
/************************************************************************/

#   include	"config.h"

#   include	"tedApp.h"

#   include	<debugon.h>

/************************************************************************/
/*  Show or create a print tool.					*/
/************************************************************************/
static void tedSetPageLayout(	void *				voidea,
				const DocumentGeometry *	dg )
    {
    EditApplication *		ea= (EditApplication *)voidea;
    Display *			display= ea->eaDisplay;
    EditDocument *		ed= ea->eaCurrentDocument;
    AppDrawingData *		add;
    TedDocument *		td;
    BufferDocument *		bd;

    double			horPixPerMM;
    double			verPixPerMM;
    double			xfac;
    double			yfac;

    int				changed= 0;

    int				scrolledX;
    int				scrolledY;

    if  ( ! ed )
	{ XDEB(ed); return;	}

    add= &(ed->edDrawingData);
    td= (TedDocument *)ed->edPrivateData;
    bd= bd= td->tdDocument;

    appSetDocumentGeometry( &(bd->bdGeometry), dg, &changed );

    if  ( changed )
	{
	int	hasSelection= tedHasSelection( td );

	appDocumentChanged( ed->edApplication, ed, 1 );

	appGetFactors( ea, &horPixPerMM, &verPixPerMM, &xfac, &yfac );
	tedSetRectangles( ed, &(bd->bdGeometry), xfac, yfac );

	tedLayoutDocument( ed, bd );

	if  ( hasSelection )
	    {
	    tedCalculateSelectedLines( td );
	    tedSelectionCoordinates( &(td->tdSelection), add );

	    tedSelectionRectangle( &(td->tdSelectedRectangle),
						 add, &(td->tdSelection) );
	    }

	appDocSetScrollbarValues( ed );
	appSetShellConstraints( ed );

	if  ( TED_FormatTool )
	    { tedAdaptFormatToolToDocument( TED_FormatTool, ed );	}

	if  ( hasSelection )
	    {
	    tedDocAdaptHorizontalRuler( ed, td->tdSelection.bsBegin.bpBi, 1 );

	    if  ( tedHasIBarSelection( td ) )
		{
		tedScrollToPosition( ed, &(td->tdSelection.bsBegin),
						    &scrolledX, &scrolledY );
		}
	    else{
		tedScrollToSelection( ed, &(td->tdSelection),
						    &scrolledX, &scrolledY );
		}

	    if  ( td->tdObjectSelected )
		{ tedMoveObjectWindows( ed->edDocumentWidget, ed );	}
	    }

	XClearArea( display, XtWindow( ed->edDocumentWidget ),
							0, 0, 0, 0, True );
	}

    return;
    }

void tedAppShowPageTool(		Widget		pageOption,
					XtPointer	voidea,
					XtPointer	voidcbs	 )
    {
    EditApplication *	ea=	(EditApplication *)voidea;
    EditDocument *	ed= ea->eaCurrentDocument;

    if  ( ! ed )
	{ XDEB(ed); return;	}

    if  ( ! ea->eaPageTool )
	{
	char *			pixmapName= "page";

	ea->eaPageTool= appMakePageTool( ea, pageOption,
					    pixmapName, tedSetPageLayout );
	}
    else{ appShowPageTool( ea->eaPageTool ); }

    tedAdaptPageToolToDocument( ea, ed );

    return;
    }

/************************************************************************/
/*									*/
/*  Adapt the page tool to a document.					*/
/*									*/
/************************************************************************/
void tedAdaptPageToolToDocument(	EditApplication *	ea,
					EditDocument *		ed )
    {
    TedDocument *		td;

    if  ( ! ea->eaPageTool )
	{ return;	}

    td= (TedDocument *)ed->edPrivateData;

    appPageToolSetProperties( ea->eaPageTool, &(td->tdDocument->bdGeometry) );

    appEnablePageTool( ea->eaPageTool, ! ed->edIsReadonly );

    return;
    }

/************************************************************************/
/*									*/
/*  Derive private ractangles from document properties.			*/
/*									*/
/*  1)  HACK: IMAGEABLE AREA OF PRINTER					*/
/*									*/
/************************************************************************/
# define MINMARG	300

void tedSetRectangles(	EditDocument *		ed,
			DocumentGeometry *	dg,
			double			xfac,
			double			yfac )
    {
    AppDrawingData *		add= &(ed->edDrawingData);

    /*  1  */
    if  ( dg->dgLeftMarginTwips < MINMARG )
	{ dg->dgLeftMarginTwips= MINMARG;	}
    if  ( dg->dgTopMarginTwips < MINMARG )
	{ dg->dgTopMarginTwips= MINMARG;	}
    if  ( dg->dgRightMarginTwips < MINMARG )
	{ dg->dgRightMarginTwips= MINMARG;	}
    if  ( dg->dgBottomMarginTwips < MINMARG )
	{ dg->dgBottomMarginTwips= MINMARG;	}

    add->addBackRect.drX0= 0;
    add->addBackRect.drY0= 0;
    add->addBackRect.drX1= TWIPStoPIXELS( xfac, dg->dgPaperWideTwips );
    add->addBackRect.drY1= TWIPStoPIXELS( yfac, dg->dgPaperHighTwips );

    add->addPaperRect.drX0= 0;
    add->addPaperRect.drY0= 0;
    add->addPaperRect.drX1= TWIPStoPIXELS( xfac, dg->dgPaperWideTwips );
    add->addPaperRect.drY1= TWIPStoPIXELS( yfac, dg->dgPaperHighTwips );

    add->addDocRect.drX0= TWIPStoPIXELS( xfac, dg->dgLeftMarginTwips );
    add->addDocRect.drY0= TWIPStoPIXELS( yfac, dg->dgTopMarginTwips );
    add->addDocRect.drX1= TWIPStoPIXELS( xfac,
			    ( dg->dgPaperWideTwips- dg->dgRightMarginTwips ) );
    add->addDocRect.drY1= TWIPStoPIXELS( yfac,
			    ( dg->dgPaperHighTwips- dg->dgBottomMarginTwips ) );

    appSetShellConstraints( ed );

    return;
    }

/************************************************************************/
/*									*/
/*  (re)Calculate the layout of a whole document.			*/
/*									*/
/************************************************************************/
int tedLayoutDocument(	EditDocument *		ed,
			BufferDocument *	bd )
    {
    DocumentGeometry *		dg= &(bd->bdGeometry);
    AppDrawingData *		add= &(ed->edDrawingData);

    int				lastY= 0;
    int				y;

    int				i;

    y= add->addDocRect.drY0;
    if  ( tedLayoutItem( &(bd->bdItem), bd, add, y, &y, &lastY ) )
	{ LDEB(y); return -1;	}

    add->addDocRect.drY1= y;
    add->addBackRect.drY1= y+ TWIPStoPIXELS( add->addMagnifiedPixelsPerTwip,
						dg->dgBottomMarginTwips );

    for ( i= 0; i < bd->bdItem.biGroupChildCount; i++ )
	{
	BufferItem *	sectBi= bd->bdItem.biGroupChildren[i];
	int		sectY0= 0;
	int		sectY1;
	int		sectLastY;

	if  ( sectBi->biSectHeader )
	    {
	    if  ( tedLayoutHeaderItem( sectBi->biSectHeader, bd, add,
						sectY0, &sectY1, &sectLastY ) )
		{ XDEB(sectBi->biSectHeader); return -1;	}
	    }

	if  ( sectBi->biSectFirstPageHeader )
	    {
	    if  ( tedLayoutHeaderItem( sectBi->biSectFirstPageHeader, bd, add,
						sectY0, &sectY1, &sectLastY ) )
		{ XDEB(sectBi->biSectFirstPageHeader); return -1;	}
	    }

	if  ( sectBi->biSectLeftPageHeader )
	    {
	    if  ( tedLayoutHeaderItem( sectBi->biSectLeftPageHeader, bd, add,
						sectY0, &sectY1, &sectLastY ) )
		{ XDEB(sectBi->biSectLeftPageHeader); return -1;	}
	    }

	if  ( sectBi->biSectRightPageHeader )
	    {
	    if  ( tedLayoutHeaderItem( sectBi->biSectRightPageHeader, bd, add,
						sectY0, &sectY1, &sectLastY ) )
		{ XDEB(sectBi->biSectRightPageHeader); return -1;	}
	    }

	if  ( sectBi->biSectFooter )
	    {
	    if  ( tedLayoutHeaderItem( sectBi->biSectFooter, bd, add,
						sectY0, &sectY1, &sectLastY ) )
		{ XDEB(sectBi->biSectFooter); return -1;	}
	    }

	if  ( sectBi->biSectFirstPageFooter )
	    {
	    if  ( tedLayoutHeaderItem( sectBi->biSectFirstPageFooter, bd, add,
						sectY0, &sectY1, &sectLastY ) )
		{ XDEB(sectBi->biSectFirstPageFooter); return -1;	}
	    }

	if  ( sectBi->biSectLeftPageFooter )
	    {
	    if  ( tedLayoutHeaderItem( sectBi->biSectLeftPageFooter, bd, add,
						sectY0, &sectY1, &sectLastY ) )
		{ XDEB(sectBi->biSectLeftPageFooter); return -1;	}
	    }

	if  ( sectBi->biSectRightPageFooter )
	    {
	    if  ( tedLayoutHeaderItem( sectBi->biSectRightPageFooter, bd, add,
						sectY0, &sectY1, &sectLastY ) )
		{ XDEB(sectBi->biSectRightPageFooter); return -1;	}
	    }
	}

    return 0;
    }

/************************************************************************/
/*									*/
/*  Show the page setup dialog for a certain document.			*/
/*									*/
/************************************************************************/
void tedDocShowPageTool(		Widget		pageOption,
					XtPointer	voided,
					XtPointer	voidcbs	 )
    {
    EditDocument *	ed= (EditDocument *)voided;

    tedAppShowPageTool( pageOption, (void *)ed->edApplication, voidcbs );
    }
