/************************************************************************/
/*  Ted, main module.							*/
/************************************************************************/

#   include	"config.h"

#   include	<stddef.h>
#   include	<stdlib.h>
#   include	<stdio.h>
#   include	<ctype.h>

#   include	"tedApp.h"
#   include	<appFont.h>
#   include	<appSymbolPicker.h>
#   include	<Xm/ToggleB.h>

#   include	<debugon.h>

/************************************************************************/
/*									*/
/*  Change to font attributes of the current selection.			*/
/*									*/
/************************************************************************/

static void tedSetCurrentAttribute(	TedDocument *		td,
					AppDrawingData *	add,
					unsigned int		updMask,
					TextAttribute		taNew )
    {
    BufferDocument *		bd= td->tdDocument;
    DocumentFontList *		dfl= &(bd->bdFontList);
    TextAttribute *		taDoc= &(td->tdCurrentTextAttribute);

    if  ( updMask & TAmaskFONTFAMILY )
	{ taDoc->taFontNumber= taNew.taFontNumber;	}
    if  ( updMask & TAmaskFONTSIZE )
	{ taDoc->taFontSizeHalfPoints= taNew.taFontSizeHalfPoints; }
    if  ( updMask & TAmaskFONTBOLD )
	{ taDoc->taFontIsBold= taNew.taFontIsBold;		}
    if  ( updMask & TAmaskFONTSLANTED )
	{ taDoc->taFontIsSlanted= taNew.taFontIsSlanted;	}
    if  ( updMask & TAmaskTEXTUNDERLINED )
	{ taDoc->taIsUnderlined= taNew.taIsUnderlined;	}
    if  ( updMask & TAmaskTEXTINFIELD )
	{ taDoc->taInField= taNew.taInField;		}
    if  ( updMask & TAmaskSUPERSUB )
	{ taDoc->taSuperSub= taNew.taSuperSub;		}

    td->tdCurrentPhysicalFont= appOpenDocumentFont( add, dfl,
						td->tdCurrentTextAttribute );

    return;
    }

static void tedAppChangeSelectionAttribute(	EditDocument *	ed,
						unsigned int	updMask,
						TextAttribute	taNew )
    {
    AppDrawingData *		add= &(ed->edDrawingData);
    TedDocument *		td= (TedDocument *)ed->edPrivateData;

    tedSetCurrentAttribute( td, add, updMask, taNew );

    tedChangeSelectionProperties( ed,
			    updMask, taNew,
			    (unsigned int)0, (const ParagraphProperties *)0 );

    return;
    }

/************************************************************************/
/*									*/
/*  Adapt fonts tool to the current document.				*/
/*									*/
/************************************************************************/
void tedAdaptFontsToolToDocument(	EditApplication *	ea,
					EditDocument *		ed )
    {
    TedDocument *	td= (TedDocument *)ed->edPrivateData;

    char *		familyName;
    int			psFamilyNumber;

    unsigned int	updMask;
    TextAttribute	taNew;

    if  ( tedGetDocumentAttributes( td, &familyName, &psFamilyNumber,
							&updMask, &taNew ) )
	{ return;	}

    appFontSetCurrentFont( ea->eaFontsTool, psFamilyNumber, updMask, taNew );

    if  ( ea->eaSymbolPicker )
	{
	appAdaptSymbolPickerToFontFamily( ea->eaSymbolPicker, psFamilyNumber );
	}

    appFontToolTextReadonly( ea->eaFontsTool, ed->edIsReadonly );

    return;
    }

/************************************************************************/
/*									*/
/*  1)  Adapt fonts tool &c to the current selection.			*/
/*  2)  Adapt fonts tool &c to the current values.			*/
/*									*/
/************************************************************************/

/*  1  */
void tedAdaptFontIndicatorsToSelection(	EditApplication *	ea,
					EditDocument *		ed )
    {
    TedDocument *	td= (TedDocument *)ed->edPrivateData;

    char *		familyName;
    int			psFamilyNumber;

    unsigned int	updMask;
    TextAttribute	taNew;

    if  ( tedGetDocumentAttributes( td, &familyName, &psFamilyNumber,
							&updMask, &taNew ) )
	{ return;	}

    tedAdaptFontIndicatorsToValues( ed, familyName, psFamilyNumber,
							    updMask, taNew );

    return;
    }


/*  2  */
void tedAdaptFontIndicatorsToValues(	EditDocument *		ed,
					char *			familyName,
					int			psFamilyNumber,
					unsigned int		updMask,
					TextAttribute		taNew )
    {
    EditApplication *	ea= ed->edApplication;
    TedDocument *	td= (TedDocument *)ed->edPrivateData;

    if  ( ea->eaFontsTool )
	{
	appFontSetCurrentFont( ea->eaFontsTool, psFamilyNumber,
							    updMask, taNew );
	}

    if  ( ea->eaSymbolPicker )
	{
	appAdaptSymbolPickerToFontFamily( ea->eaSymbolPicker, psFamilyNumber );
	}

    XmToggleButtonSetState( td->tdFontBoldOption,
	    ( updMask & TAmaskFONTBOLD ) && taNew.taFontIsBold, False );

    XmToggleButtonSetState( td->tdFontItalicOption,
	    ( updMask & TAmaskFONTSLANTED ) && taNew.taFontIsSlanted, False );

    XmToggleButtonSetState( td->tdFontUnderlinedOption,
	    ( updMask & TAmaskTEXTUNDERLINED ) && taNew.taIsUnderlined, False );

    XmToggleButtonSetState( td->tdFontSuperscriptOption,
				    ( updMask & TAmaskSUPERSUB ) &&
				    taNew.taSuperSub == DOCfontSUPERSCRIPT,
				    False );

    XmToggleButtonSetState( td->tdFontSubscriptOption,
				    ( updMask & TAmaskSUPERSUB ) &&
				    taNew.taSuperSub == DOCfontSUBSCRIPT,
				    False );

    return;
    }

/************************************************************************/
/*									*/
/*  One of the text attribute options has been pushed.			*/
/*									*/
/************************************************************************/

static void tedTextAttributePushed(	Widget		attributeOption,
					XtPointer	voided,
					XtPointer	voidcbs,
					unsigned int	updMask )
    {
    EditDocument *	ed= (EditDocument *)voided;
    EditApplication *	ea= ed->edApplication;

    TextAttribute	taNew;
    XmToggleButtonCallbackStruct *	cbs;

    cbs= (XmToggleButtonCallbackStruct *)voidcbs;

    docInitTextAttribute( &taNew );

    switch( updMask )
	{
	case TAmaskFONTBOLD:
	    taNew.taFontIsBold= ( cbs->set != 0 );
	    break;
	case TAmaskFONTSLANTED:
	    taNew.taFontIsSlanted= ( cbs->set != 0 );
	    break;
	case TAmaskTEXTUNDERLINED:
	    taNew.taIsUnderlined= ( cbs->set != 0 );
	    break;
	default:
	    XDEB(updMask);
	    return;
	}

    tedAppChangeSelectionAttribute( ed, updMask, taNew );

    if  ( ea->eaFontsTool )
	{ tedAdaptFontsToolToDocument( ea, ed );	}

    return;
    }

int tedAppChangeSelectionAttributeString(	EditDocument *	ed,
						char *		attrString )
    {
    char *		familyName;

    TextAttribute	taNew;
    unsigned int	updMask;

    EditApplication *	ea= ed->edApplication;

    if  ( appFontGetAttributes( attrString, &familyName, &updMask, &taNew ) )
	{ SDEB( attrString ); return -1;	}

    if  ( updMask & TAmaskFONTFAMILY )
	{
	TedDocument *		td= (TedDocument *)ed->edPrivateData;
	BufferDocument *	bd= td->tdDocument;
	DocumentFontList *	dfl= &(bd->bdFontList);

	taNew.taFontNumber= docGetFontByName( dfl, familyName );
	if  ( taNew.taFontNumber < 0 )
	    { SLDEB(familyName,taNew.taFontNumber); return -1;	}
	}

    tedAppChangeSelectionAttribute( ed, updMask, taNew );

    tedAdaptFontIndicatorsToSelection( ea, ed );

    return 0;
    }

void tedDocFontBold(		Widget		option,
				XtPointer	voided,
				XtPointer	voidcbs	 )
    { tedTextAttributePushed( option, voided, voidcbs, TAmaskFONTBOLD ); }

void tedDocFontItalic(	Widget		option,
			XtPointer	voided,
			XtPointer	voidcbs	 )
    {
    tedTextAttributePushed( option, voided, voidcbs, TAmaskFONTSLANTED );
    }

void tedDocFontUnderlined(	Widget		option,
				XtPointer	voided,
				XtPointer	voidcbs	 )
    {
    tedTextAttributePushed( option, voided, voidcbs, TAmaskTEXTUNDERLINED );
    }

void tedDocFontSupersub(	Widget		option,
				XtPointer	voided,
				XtPointer	voidcbs	 )
    {
    EditDocument *	ed= (EditDocument *)voided;
    TedDocument *	td= (TedDocument *)ed->edPrivateData;

    unsigned int	updMask= TAmaskSUPERSUB;
    TextAttribute	taNew;

    XmToggleButtonCallbackStruct *	cbs;

    cbs= (XmToggleButtonCallbackStruct *)voidcbs;

    docInitTextAttribute( &taNew );

    if  ( cbs->set )
	{
	if  ( option == td->tdFontSubscriptOption )
	    { taNew.taSuperSub= DOCfontSUBSCRIPT;	}

	if  ( option == td->tdFontSuperscriptOption )
	    { taNew.taSuperSub= DOCfontSUPERSCRIPT;	}
	}
    else{ taNew.taSuperSub= DOCfontREGULAR;	}

    tedAppChangeSelectionAttribute( ed, updMask, taNew );

    XmToggleButtonSetState( td->tdFontSuperscriptOption,
				    ( updMask & TAmaskSUPERSUB ) &&
				    taNew.taSuperSub == DOCfontSUPERSCRIPT,
				    False );

    XmToggleButtonSetState( td->tdFontSubscriptOption,
				    ( updMask & TAmaskSUPERSUB ) &&
				    taNew.taSuperSub == DOCfontSUBSCRIPT,
				    False );

    return;
    }

/************************************************************************/
/*  Ted, cope with the fonts tool.					*/
/************************************************************************/
static void tedFontsToolClosed(		void *		voidea	)
    {
    EditApplication *	ea=	(EditApplication *)voidea;

    ea->eaFontsTool= (void *)0;
    }

static void tedFontToolSet(		void *		voidea,
					char *		familyName,
					int		psFamilyNumber,
					int		fontBold,
					int		fontSlanted,
					int		fontSize	)
    {
    EditApplication *	ea= (EditApplication *)voidea;
    EditDocument *	ed= ea->eaCurrentDocument;
    TedDocument *	td;

    unsigned int	updMask;
    TextAttribute	taNew;

    if  ( ! ed )
	{ XDEB(ed); return;	}

    td= (TedDocument *)ed->edPrivateData;

    docInitTextAttribute( &taNew );
    updMask= 0;

    if  ( familyName )
	{
	BufferDocument *	bd= td->tdDocument;
	DocumentFontList *	dfl= &(bd->bdFontList);

	taNew.taFontNumber= docGetFontByName( dfl, familyName );
	if  ( taNew.taFontNumber < 0 )
	    { SLDEB(familyName,taNew.taFontNumber); return;	}

	updMask |= TAmaskFONTFAMILY;
	}

    if  ( fontBold >= 0 )
	{
	taNew.taFontIsBold= ( fontBold != 0 );
	updMask |= TAmaskFONTBOLD;
	}

    if  ( fontSlanted >= 0 )
	{
	taNew.taFontIsSlanted= ( fontSlanted != 0 );
	updMask |= TAmaskFONTSLANTED;
	}

    if  ( fontSize > 0 )
	{
	taNew.taFontSizeHalfPoints= 2* fontSize;
	updMask |= TAmaskFONTSIZE;
	}

    tedAppChangeSelectionAttribute( ed, updMask, taNew );

    if  ( fontBold < 0 || fontSlanted < 0 )
	{
	if  ( tedGetDocumentAttributes( td, &familyName, &psFamilyNumber,
							&updMask, &taNew ) )
	    { LLDEB(fontBold,fontSlanted);	}
	}

    XmToggleButtonSetState( td->tdFontBoldOption,
	    ( updMask & TAmaskFONTBOLD ) && taNew.taFontIsBold, False );

    XmToggleButtonSetState( td->tdFontItalicOption,
	    ( updMask & TAmaskFONTSLANTED ) && taNew.taFontIsSlanted, False );

    if  ( ea->eaSymbolPicker )
	{
	appAdaptSymbolPickerToFontFamily( ea->eaSymbolPicker, psFamilyNumber );
	}

    return;
    }


void tedShowFontsTool(		Widget			fontsOption,
				EditApplication *	ea,
				XtPointer		voidcbs	 )
    {
    EditDocument *	ed= ea->eaCurrentDocument;

    if  ( ! ea->eaFontsTool )
	{
	char *		pixmapName= "tedfont";
	Pixmap		iconPixmap= (Pixmap)0;

	if  ( ! ed )
	    { XDEB(ed); return;	}

	if  ( appGetImagePixmap( ea, pixmapName, &iconPixmap )  )
	    { SDEB(pixmapName); return;	}

	ea->eaFontsTool= appMakeFontsTool( fontsOption, ea->eaTopWidget,
		    ea->eaApplicationName, "tedFontTool",
		    iconPixmap, ea->eaCloseAtom,
		    tedFontsToolClosed, tedFontToolSet,
		    ea->eaMagnifiedPixelsPerTwip, ea );
	}
    else{ appShowFontsTool( ea->eaFontsTool );	}

    if  ( ed )
	{ tedAdaptFontsToolToDocument( ea, ed );	}

    return;
    }

/************************************************************************/
/*  Show or create a symbol picker.					*/
/************************************************************************/

static void tedSymbolPickerInsert(	void *		voidea,
					int		symbol,
					int		psFamilyNumberSet,
					char *		familyNameSet )
    {
    unsigned char	fresh[2];

    EditApplication *	ea= (EditApplication *)voidea;
    EditDocument *	ed= ea->eaCurrentDocument;
    AppDrawingData *	add;
    TedDocument *	td;

    if  ( ! ed )
	{ XDEB(ed); return;	}

    td= (TedDocument *)ed->edPrivateData;
    add= &(ed->edDrawingData);

    fresh[0]= symbol;
    fresh[1]= '\0';

    if  ( td->tdSelection.bsBegin.bpBi && td->tdCanReplaceSelection )
	{
	char *		familyName;
	int		psFamilyNumber;

	unsigned int	updMask;
	TextAttribute	taNew;

	if  ( tedGetDocumentAttributes( td, &familyName, &psFamilyNumber,
							&updMask, &taNew ) )
	    { LDEB(1); return;	}

	if  ( ! ( updMask & TAmaskFONTFAMILY )		||
	      psFamilyNumberSet != psFamilyNumber	)
	    {
	    BufferDocument *	bd= td->tdDocument;
	    DocumentFontList *	dfl= &(bd->bdFontList);

	    taNew.taFontNumber= docGetFontByName( dfl, familyNameSet );
	    if  ( taNew.taFontNumber < 0 )
		{ SLDEB(familyNameSet,taNew.taFontNumber); return;	}

	    td->tdCurrentTextAttribute.taFontNumber= taNew.taFontNumber;
	    td->tdCurrentPhysicalFont= appOpenDocumentFont( add, dfl,
						td->tdCurrentTextAttribute );
	    }

	tedAppReplaceSelection( ed, fresh, 1 );
	}

    return;
    }

static void tedSymbolPickerClosed(	void *		voidea	)
    {
    EditApplication *	ea=	(EditApplication *)voidea;

    ea->eaSymbolPicker= (void *)0;
    }

void tedDocToolInsertSymbol(	Widget		symbolOption,
				XtPointer	voided,
				XtPointer	voidcbs	 )
    {
    EditDocument *	ed= (EditDocument *)voided;
    TedDocument *	td= (TedDocument *)ed->edPrivateData;
    EditApplication *	ea= ed->edApplication;

    if  ( ! td->tdCanReplaceSelection )
	{ LDEB(td->tdCanReplaceSelection); return;	}

    if  ( ! ea->eaSymbolPicker )
	{
	char *		pixmapName= "tedsymbol";
	Pixmap		iconPixmap= (Pixmap)0;

	char *		familyName;
	int		psFamilyNumber;

	unsigned int	updMask;
	TextAttribute	taNew;

	if  ( tedGetDocumentAttributes( td, &familyName, &psFamilyNumber,
							&updMask, &taNew ) )
	    { return;	}

	if  ( ! ( updMask & TAmaskFONTFAMILY ) )
	    { XDEB(updMask); return;	}

	if  ( appGetImagePixmap( ea, pixmapName, &iconPixmap )  )
	    { SDEB(pixmapName); return;	}

	ea->eaSymbolPicker= appMakeSymbolPicker( symbolOption, ea,
			    "tedSymbolPicker",
			    iconPixmap, ea->eaCloseAtom,
			    tedSymbolPickerInsert,
			    tedSymbolPickerClosed,
			    (void *)ea );

	appAdaptSymbolPickerToFontFamily( ea->eaSymbolPicker, psFamilyNumber );
	}
    else{ appShowSymbolPicker( ea->eaSymbolPicker ); }

    return;
    }
