/*
 * multilingual support for nvi
 * Copyright(c) 1996, 1997 by Jun-ichiro Itoh.  All rights reserved.
 * Author contact: <itojun@mt.cs.keio.ac.jp>
 * $Id: multi_euc.c,v 1.1.2.1 1997/09/23 00:43:47 itojun Exp $
 *
 * Freely redistributable, reusable, unless otherwise noted in accompanying
 * document. (for example, redistribution is prohibited during alpha-test
 * period)
 * Absolutely no warranty.
 *
 * The code is based on:
 *	jelvis japanization patch by Jun-ichiro Itoh
 *	nvi 1.03 japanization patch by Yoshitaka Tokugawa <toku@dit.co.jp>
 */

#include "config.h"

#ifdef MULTIBYTE

#include <sys/types.h>
#include <sys/queue.h>

#include <bitstring.h>
#include <ctype.h>
#include <errno.h>
#include <fcntl.h>
#include <limits.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include "../common/common.h"
#include "multibyte.h"

#if 0
int
euc_to_int(sp, e, dst, pdlen, src, slen, pflags, state)
	SCR *sp;
	ENCODING const *e;
	CHAR_T *dst;
	size_t *pdlen;
	CHAR_T *src;
	size_t slen;
	int *pflags;
	ISO2022STATE *state;
{
	CHAR_T *p;
	CHAR_T *q;
	size_t i;

	/* sanity check. */
	if (ischarset(e->initg0)) {
		if (charset(e->initg0).type != CS94)
			abort();
	}
	if (ischarset(e->initg1)) {
		if (charset(e->initg1).type != CS9494)
			abort();
	}
	if (ischarset(e->initg2)) {
		if (charset(e->initg2).type != CS94)
			abort();
	}
	if (ischarset(e->initg3)) {
		if (charset(e->initg3).type != CS9494)
			abort();
	}
	
	q = dst;
	p = src;
	if (pflags)
		FL_INIT(*pflags, 0);

	for (i = 0; i < slen; i++) {
		if (i + 1 < slen && iseuckanji(p[0]) && iseuckanji(p[1])) {
			if (!ischarset(e->initg1))
				goto raw;

			if (dst) {
				*q++ = e->initg1;
				*q++ = *p++ & 0x7f;
				*q++ = *p++ & 0x7f;
			} else {
				q += 3;
				p += 2;
			}
			i++;		/*plus one at for loop*/
			if (pflags)
				FL_SET(*pflags, MB_MULTIBYTE);
			continue;
		}
		if (i + 1 < slen && p[0] == 0x8e && iseuckanji(p[1])) {
			if (!ischarset(e->initg2))
				goto raw;

			if (dst) {
				p++;
				*q++ = e->initg2;
				*q++ = *p++ & 0x7f;
			} else {
				q += 2;
				p += 2;
			}
			i++;		/*plus one at for loop*/
			if (pflags)
				FL_SET(*pflags, MB_MULTIBYTE);
			continue;
		}
		if (i + 2 < slen && p[0] == 0x8f
		 && iseuckanji(p[1]) && iseuckanji(p[2])) {
			if (!ischarset(e->initg3))
				goto raw;

			if (dst) {
				p++;
				*q++ = e->initg3;
				*q++ = *p++ & 0x7f;
				*q++ = *p++ & 0x7f;
			} else {
				q += 3;
				p += 3;
			}
			i += 2;		/*plus one at for loop*/
			if (pflags)
				FL_SET(*pflags, MB_MULTIBYTE);
			continue;
		}

raw:
		/*
		 * ASCII and other binary encodings.
		 */
		if (p[0] & 0x80) {
			if (dst) {
				*q++ = CS_RAW0 + v_key_len(sp, *p);
				*q++ = *p & 0x7f;
				p++;
			} else {
				q += 2;
				p++;
			}
			if (pflags)
				FL_SET(*pflags, MB_MULTIBYTE|MB_RAW);
			continue;
		}

		if (dst)
			*q++ = *p++;
		else {
			q++;
			p++;
		}
	}

	if (pdlen)
		*pdlen = q - dst;
	return 0;
}
#endif

#if 0
int
int_to_euc(sp, e, dst, pdlen, src, slen, pflags, state)
	SCR *sp;
	ENCODING const *e;
	CHAR_T *dst;
	size_t *pdlen;
	CHAR_T *src;
	size_t slen;
	int *pflags;
	ISO2022STATE *state;
{
	CHAR_T *p;
	CHAR_T *q;
	size_t i;

	/* sanity check. */
	if (ischarset(e->initg0)) {
		if (charset(e->initg0).type != CS94)
			abort();
	}
	if (ischarset(e->initg1)) {
		if (charset(e->initg1).type != CS9494)
			abort();
	}
	if (ischarset(e->initg2)) {
		if (charset(e->initg2).type != CS94)
			abort();
	}
	if (ischarset(e->initg3)) {
		if (charset(e->initg3).type != CS9494)
			abort();
	}
	
	if (pflags)
		FL_INIT(*pflags, 0);
	q = dst;
	p = src;

	for (i = 0; i < slen; i++) {
		if (CS_RAW(p[0])) {
			if (dst) {
				*q++ = p[1] | 0x80;
				p += 2;
			} else {
				q++;
				p += 2;
			}
			i++;		/*plus one at for loop*/
			if (pflags)
				FL_SET(*pflags, MB_MULTIBYTE|MB_RAW);
			continue;
		}
		if (ischarset(e->initg1) && p[0] == e->initg1) {
			/*
			 * If we're using euc-jp, there's no distinction
			 * between JIS0208 variants.
			 */
			if (dst) {
				p++;
				*q++ = *p++ | 0x80;
				*q++ = *p++ | 0x80;
			} else {
				q += 2;
				p += 3;
			}
			i += 2;		/*plus one at for loop*/
			if (pflags)
				FL_SET(*pflags, MB_MULTIBYTE);
			continue;
		}
		if (ischarset(e->initg2) && p[0] == e->initg2) {
			if (dst) {
				p++;
				*q++ = 0x8e;
				*q++ = *p++ | 0x80;
			} else {
				q += 2;
				p += 2;
			}
			i++;		/*plus one at for loop*/
			if (pflags)
				FL_SET(*pflags, MB_MULTIBYTE);
			continue;
		}
		if (ischarset(e->initg3) && p[0] == e->initg3) {
			if (dst) {
				p++;
				*q++ = 0x8f;
				*q++ = *p++ | 0x80;
				*q++ = *p++ | 0x80;
			} else {
				q += 3;
				p += 3;
			}
			i += 2;		/*plus one at for loop*/
			if (pflags)
				FL_SET(*pflags, MB_MULTIBYTE);
			continue;
		}
		if (p[0] & 0x80) {
			/*
			 * Unknown encoding.  Simply skip them.
			 */
			p += charset(p[0]).blen;
			i += 2;		/*plus one at for loop*/
			if (pflags)
				FL_SET(*pflags, MB_MULTIBYTE|MB_SKIP);
			continue;
		}

		if (dst)
			*q++ = *p++;
		else {
			q++;
			p++;
		}
	}

	if (pdlen)
		*pdlen = q - dst;
	return 0;
}
#endif

int
euc_recommendation(cs, e)
	CHARSET const *cs;
	ENCODING const *e;
{
	CHAR_T ch;

	if (cs == NULL)
		return 0;

	ch = CS_RAW0 + (cs - charsettab);
	if (ch == e->initg1)
		return 1;
	if (ch == e->initg2)
		return 2;
	if (ch == e->initg3)
		return 3;
	if (!ischarset(e->initg2) && (cs->type == CS94 || cs->type == CS96))
		return 2;
	if (!ischarset(e->initg3) && (cs->type == CS9494 || cs->type == CS9696))
		return 3;
	
	/* don't mix them up with GR chars... */
	return 0;
}

#if 0
void
euc_keyinput(sp, e, kbuf, kbuflen, intbuf, pintbuflen, pstate, pconsumed)
	SCR *sp;
	ENCODING const *e;
	CHAR_T *kbuf;
	size_t kbuflen;
	CHAR_T *intbuf;
	size_t *pintbuflen;
	int *pstate;
	size_t *pconsumed;
{
	size_t i;
	size_t j;
	size_t consumed;

	i = j = consumed = 0;
	while (i < kbuflen) {
		/*
		 * Kanji cases.
		 */
		if (ischarset(e->initg1) && i + 1 < kbuflen
		 && iseuckanji(kbuf[i]) && iseuckanji(kbuf[i + 1])) {
			/*
			 * we got G1 char.
			 */
			intbuf[j++] = e->initg1;
			intbuf[j++] = kbuf[i++] & 0x7f;
			intbuf[j++] = kbuf[i++] & 0x7f;
			*pstate = 0;
			consumed += 2;
		} else if (ischarset(e->initg2) && i + 1 < kbuflen
		 && kbuf[i] == 0x8e && iseuckanji(kbuf[i + 1])) {
			/*
			 * we got G2 char.
			 */
			intbuf[j++] = e->initg2;
			intbuf[j++] = kbuf[i + 1] & 0x7f;
			i += 2;
			*pstate = 0;
			consumed += 2;
		} else if (ischarset(e->initg3) && i + 2 < kbuflen
		 && kbuf[i] == 0x8f
		 && iseuckanji(kbuf[i + 1]) && iseuckanji(kbuf[i + 2])) {
			/*
			 * we got G3 char.
			 */
			intbuf[j++] = e->initg3;
			intbuf[j++] = kbuf[i + 1] & 0x7f;
			intbuf[j++] = kbuf[i + 2] & 0x7f;
			i += 3;
			*pstate = 0;
			consumed += 3;
		} else if (i + 1 == kbuflen && iseuckanji(kbuf[i])) {
			/*
			 * Only the firstbyte for G1 char is available.
			 * Keep this kanji char till next round.
			 */
			i++;
			*pstate = 1;
		} else if (i + 1 == kbuflen && kbuf[i] == 0x8e) {
			/*
			 * Only the firstbyte for G2 char is available.
			 * Keep this kanji char till next round.
			 */
			i++;
			*pstate = 2;
		} else if (i + 1 == kbuflen && kbuf[i] == 0x8f) {
			/*
			 * Only the firstbyte for G3 char is available.
			 * Keep this kanji char till next round.
			 */
			i++;
			*pstate = 3;
		} else if (i + 2 == kbuflen
		 && kbuf[i] == 0x8f && iseuckanji(kbuf[i + 1])) {
			/*
			 * Only the 1st and 2nd byte for G3 char is available.
			 * Keep this kanji char till next round.
			 */
			i += 2;
			*pstate = 4;
		}

		/*
		 * Non-kanji cases.
		 */
		else if (kbuf[i] & 0x80) {
			intbuf[j++] = CS_RAW0 + v_key_len(sp, kbuf[i]);
			intbuf[j++] = kbuf[i] & 0x7f;
			i++;
			*pstate = 0;
			consumed++;
		} else {
			intbuf[j++] = kbuf[i++];
			*pstate = 0;
			consumed++;
		}
	}
	*pintbuflen = j;
	*pconsumed = consumed;
}
#endif

int
euc_display(sp, e, name, p)
	SCR *sp;
	ENCODING const *e;
	CHAR_T *name;
	CHAR_T *p;
{
	if (ischarset(e->initg1) && p[0] == e->initg1) {
		name[0] = p[1] | 0x80;
		name[1] = p[2] | 0x80;
		name[2] = '\0';
		return 1;
	}
	return 0;
}
#endif /*MULTIBYTE*/
