/* 94.7.15  modified for Mule Ver.2.0 by K.Handa <handa@etl.go.jp>
	Extracted from charset.c. */

#include <config.h>
#include <sys/types.h>		/* regex.h needs this. */
#include "lisp.h"
#include "buffer.h"
#include "syntax.h"
#include "regex.h"
#include "window.h"

Lisp_Object VMULE, VEGG, VWNN, VSJ3; /* 92.7.8 by K.Handa and Y.Kawabe */
/* 95.6.1 by S.Tomura */

Lisp_Object Vre_word;

int re_short_flag;

DEFUN ("define-word-pattern", Fdefine_word_pattern, Sdefine_word_pattern,
       1, 1, 0,
  "Don't call this function directly, instead use 'define-word' which\n\
accept a pattern compiled by 'regexp-compile' with word-option t.")
  (pattern)
      Lisp_Object pattern;
{				/* 93.7.13 by K.Handa -- Big change */
  int i, len;
  char *p;
  Lisp_Object temp;
  struct Lisp_String *s;

  CHECK_CONS (pattern, 0);
  len = XFASTINT (Flength (pattern));
  if (len > MAXWORDBUF)
    error ("Too complicated regular expression for word!");
  for (i = 0; i < len; i++) {
    temp =XCONS (pattern)->car;
    CHECK_VECTOR (temp, 1);
    CHECK_STRING (XVECTOR (temp)->contents[0], 2);
    s = XSTRING (XVECTOR (temp)->contents[0]);
    if (!wordbuf[i])
      wordbuf[i] = (struct re_pattern_buffer *) xmalloc (sizeof (struct re_pattern_buffer));
    else
      if (wordbuf[i]->buffer) free (wordbuf[i]->buffer);
    wordbuf[i]->buffer = (char *)xmalloc (s->size + 1);
    wordbuf[i]->used = s->size;
    bcopy (s->data, wordbuf[i]->buffer, s->size + 1);
#ifndef EMACS18_REGEXP
    wordbuf[i]->translate = 0;
    wordbuf[i]->fastmap_accurate = 0;
    wordbuf[i]->fastmap = 0;
    wordbuf[i]->can_be_null = 1;

    wordbuf[i]->mc_flag = 1;
    wordbuf[i]->short_flag = 0;
    wordbuf[i]->no_empty = 0;

    wordbuf[i]->syntax_version = 0;
    wordbuf[i]->category_version = 0;

    wordbuf[i]->regs_allocated = REGS_UNALLOCATED;
    wordbuf[i]->re_nsub = 0;				
    wordbuf[i]->no_sub = 0;
    wordbuf[i]->newline_anchor = 1;

    wordbuf[i]->syntax = 0;
    wordbuf[i]->not_bol = wordbuf[i]->not_eol = 0;
#endif
    pattern = XCONS (pattern)->cdr;
  }
  for (; i < MAXWORDBUF && wordbuf[i]; i++) {
    if (wordbuf[i]->buffer) free (wordbuf[i]->buffer);
    free (wordbuf[i]);
    wordbuf[i] = (struct re_pattern_buffer *)0;
  }    
  return Qnil;
}


syms_of_mule ()
{
  defsubr (&Sdefine_word_pattern);

  DEFVAR_BOOL ("re-short-flag", &re_short_flag,
    "*T means regexp search success when the shortest match is found.");
  re_short_flag = 0;

  DEFVAR_LISP ("MULE", &VMULE, "");
  VMULE = Qt;

#ifdef EGG
  DEFVAR_LISP ("EGG", &VEGG, "");
  VEGG = Qt;
/* 92.7.8 by K.Handa and Y.Kawabe */
/* 95.6.1 by S.Tomura */
#ifdef WNN
  DEFVAR_LISP ("WNN", &VWNN, "");
  VWNN = Qt;
#else  /* not WNN */
#ifdef SJ3
  DEFVAR_LISP ("SJ3", &VSJ3, "");
  VSJ3 = Qt;
#endif /* SJ3 */
#endif /* not WNN */
#endif /* EGG */
}

#ifdef MULE_DEBUG

#include <stdio.h>

#define max(a,b) ((a)>(b) ? (a) : (b))

char inspect_str[1024];

inspect(obj)			/* Inspect Lisp Data */
     Lisp_Object obj;
{
  switch (XTYPE (obj)) {
  case Lisp_Symbol:
    printf("Type:Symbol Name:%s\n", XSYMBOL (obj)->name->data); break;
  case Lisp_Int:
    printf("Type:Integer Value:%d\n", XINT (obj)); break;
  case Lisp_String:
    strncpy(inspect_str, XSTRING (obj)->data, max (XSTRING (obj)->size, 1023));
    printf("Type:String[%d] Value:%s\n", XSTRING (obj)->size, inspect_str);
    break;
  case Lisp_Vector:
    printf("Type:Vector Size:%d\n", XVECTOR (obj)->size);
    break;
  default:
    printf("Type:%d\n", XTYPE (obj));
  }
  fflush(stdout);
}

inspect_vector(obj,idx)
     Lisp_Object obj;
     int idx;
{
  if (!VECTORP (obj)) {
    printf("Not a vector!\n");
    return;
  }
  if (XVECTOR (obj)->size <= idx) {
    printf("Subscript out of range!");
    return;
  }
  printf("Value = %x\n", XVECTOR (obj)->contents[idx]);
  inspect(XVECTOR (obj)->contents[idx]);
  fflush(stdout);
}

inspect_array(p, n)
     unsigned char *p;
     int n;
{
  int i;

  for (i = 0; i < n; i++) printf("%d:%d ", i, p[i]);
  putchar('\n');
  fflush(stdout);
}

#endif MULE_DEBUG
