#include "XMenuInt.h"
#undef XDrawString

/* <MULE-COMMENT>
   Passing selected_frame to fs_load_font is always legal?  Even if there
   is more X Display?
   </MULE-COMMENT> */
extern struct frame *selected_frame;

XFontStruct *
MuleLoadQueryFont(display, name)
     Display *display;
     char *name;
{
  int fsID = query_fontset(name);
  int fontID;

  if (fsID < 0)
    fsID = find_fontset_from_font(name, LCASCII);
  if (fsID < 0)
    fsID = DEFAULT_FONTSET;
  fontID = fs_load_font(selected_frame, fsID, LCASCII, 0);

  return (XFontStruct *)font_table[fontID].font;
}

static
find_fontset_from_fid(fid)
     Font fid;
{
  int i;

  for (i = 0; i < n_fontsets; i++) {
    if (FS_FONT(i,LCASCII)
	&& ((XFontStruct *)(FS_FONT(i,LCASCII)))->fid == fid)
      return i;
  }
  return -1;
}

MuleTextWidth(font, str, len)
     XFontStruct *font;
     unsigned char *str;
     int len;
{
  int i, width;
  int fsID = find_fontset_from_fid(font->fid);
  int column_width = ((XFontStruct *)FS_FONT(fsID, LCASCII))->max_bounds.width;

  for (i = 0, width = 0; i < len; i += char_bytes[str[i]])
    width += char_width[str[i]] * column_width;
  return width;
}

MuleDrawString(display, window, gc, x, y, str, len, menu)
     Display *display;
     Drawable window;
     GC gc;
     int x, y;
     unsigned char *str;
     int len;
     XMenu *menu;
{
  int current_lc, lc;
  unsigned char *endp = str + len;
  XChar2b *buf = (XChar2b *) malloc(sizeof(*buf) * len);
  XFontStruct *ascii_fontinfo =
    gc == menu->pane_GC ? menu->p_fnt_info : menu->s_fnt_info;
  int fsID = find_fontset_from_fid(ascii_fontinfo->fid);
  int font_changed = 0;
  unsigned char mask;

  current_lc = *str < 0x80 ? LCASCII : *str < LCPRV11 ? *str : *(str + 1);
  while (str < endp) {
    int n = 0;
    FONT_INFO *font;
    XFontStruct *fontinfo;

    if (current_lc != LCASCII)
      fs_load_font (selected_frame, fsID, current_lc,
		    FS_FONT_INFO(fsID, LCASCII).size);
    font = &FS_FONT_INFO(fsID, current_lc);
    fontinfo = (XFontStruct *)(font->font);

    while (str < endp) {
      lc = *str < 0x80 ? LCASCII : *str < LCPRV11 ? *str : *(str + 1);
      if (current_lc != lc)
	break;
      if (lc == LCASCII)
	str++;
      else {
	unsigned char mask = font->encoding ? 0xFF : 0x7F;

	if (lc < LCPRV11) {
	  if (char_type[lc] < TYPE94N)
	    buf[n].byte1 = 0, buf[n].byte2 = str[1] & mask;
	  else
	    buf[n].byte1 = str[1] & mask, buf[n].byte2 = str[2] & mask;
	} else {
	  if (char_type[lc] < TYPE94N)
	    buf[n].byte1 = 0, buf[n].byte2 = str[2] & mask;
	  else
	    buf[n].byte1 = str[2] & mask, buf[n].byte2 = str[3] & mask;
	}
	str += char_bytes[lc];
      }
      n++;
    }
    if (current_lc == LCASCII) {
      if (font_changed) {
	XSetFont(display, gc, fontinfo->fid);
	font_changed = 0;
      }
      XDrawString(display, window, gc, x, y, str - n, n);
    } else {
      font_changed = 1;
      XSetFont(display, gc, fontinfo->fid);
      XDrawString16(display, window, gc, x,
		    y +
		    (fontinfo->max_byte1
		     ? ((fontinfo->ascent-fontinfo->descent)
			- (ascii_fontinfo->ascent-ascii_fontinfo->descent)) / 2
		     : font->yoffset - FS_FONT_INFO(fsID,LCASCII).yoffset),
		    buf, n);
    }
    x += fontinfo->max_bounds.width * n;
    current_lc = lc;
  }
  if (font_changed)
    XSetFont(display, gc, ascii_fontinfo->fid);

  free(buf);
}
